/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kson;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.nustaq.kson.Kson;
import org.nustaq.kson.KsonCharOutput;
import org.nustaq.kson.KsonTypeMapper;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTConfiguration;

public class KsonSerializer {
    protected KsonCharOutput out;
    protected KsonTypeMapper mapper;
    protected boolean pretty = true;
    protected boolean writeNull = false;
    protected FSTConfiguration conf;
    static Character zeroC = new Character('\u0000');

    public KsonSerializer(KsonCharOutput out, KsonTypeMapper mapper, FSTConfiguration conf) {
        this.out = out;
        this.mapper = mapper;
        this.conf = conf;
    }

    public void writeObject(Object o) throws Exception {
        this.writeObjectInternal(null, null, o, 0);
    }

    protected void writeObjectInternal(Class expectedClass, Class expectedValueClass, Object o, int indent) throws Exception {
        if (o == null) {
            if (indent >= 0) {
                this.writeIndent(indent);
            }
            this.out.writeString("null");
            if (indent >= 0) {
                this.writeln();
            }
            return;
        }
        if (o instanceof Character) {
            char ch;
            if (indent >= 0) {
                this.writeIndent(indent);
            }
            if ((ch = ((Character)o).charValue()) == '\u0000') {
                System.out.println("POK");
            }
            if (ch < '\u0080' && ch > ' ') {
                this.out.writeString(o.toString());
            } else {
                this.out.writeString(Integer.toString(ch));
            }
            if (indent >= 0) {
                this.writeln();
            }
        } else if (o instanceof Number || o instanceof Boolean) {
            if (indent >= 0) {
                this.writeIndent(indent);
            }
            this.out.writeString(o.toString());
            if (indent >= 0) {
                this.writeln();
            }
        } else if (o instanceof String) {
            if (indent >= 0) {
                this.writeIndent(indent);
            }
            this.writeString((String)o);
            if (indent >= 0) {
                this.writeln();
            }
        } else if (o instanceof Map) {
            Map map = (Map)o;
            this.writeIndent(indent);
            this.out.writeString("{");
            this.writeln();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                Object value = map.get(next);
                boolean valueSingleLine = this.isSingleLine(null, value);
                boolean keySingleLine = this.isSingleLine(null, next);
                if (keySingleLine) {
                    this.writeIndent(indent + 1);
                    if (next instanceof String) {
                        this.writeKey((String)next);
                    } else {
                        this.writeObjectInternal(expectedClass, null, next, -1);
                    }
                    this.out.writeString(" : ");
                    if (!valueSingleLine) {
                        this.writeln();
                    }
                } else {
                    this.writeObjectInternal(expectedClass, null, next, indent + 1);
                    this.writeIndent(indent + 1);
                    this.out.writeString(":");
                    if (!valueSingleLine) {
                        this.writeln();
                    }
                }
                if (valueSingleLine) {
                    this.out.writeChar(' ');
                    this.writeObjectInternal(expectedValueClass, null, value, -1);
                    if (iterator.hasNext()) {
                        this.writeListSep();
                    }
                    this.writeln();
                    continue;
                }
                this.writeObjectInternal(expectedValueClass, null, value, indent + 1);
                if (!iterator.hasNext()) continue;
                this.writeListSep();
            }
            this.writeIndent(indent);
            this.out.writeChar('}');
            this.writeln();
        } else if (o instanceof Collection) {
            Collection coll = (Collection)o;
            this.writeIndent(indent);
            this.writeListStart();
            this.writeln();
            Iterator iterator = coll.iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                this.writeObjectInternal(expectedClass, null, next, indent + 1);
                if (!iterator.hasNext()) continue;
                this.writeListSep();
            }
            this.writeIndent(indent);
            this.writeListEnd();
            this.writeln();
        } else if (o.getClass().isArray()) {
            this.writeIndent(indent);
            this.writeListStart();
            int len = Array.getLength(o);
            boolean lastWasSL = true;
            Class<?> expect = o.getClass().getComponentType();
            for (int ii = 0; ii < len; ++ii) {
                Object val = Array.get(o, ii);
                if (lastWasSL && (this.isSingleLine(null, val) || this.isSingleLineCLazz(expect))) {
                    this.writeObjectInternal(expect, null, val, -1);
                    this.out.writeChar(' ');
                    if (ii >= len - 1) continue;
                    this.writeListSep();
                    continue;
                }
                if (ii == 0) {
                    this.writeln();
                }
                this.writeObjectInternal(expect, null, val, indent + 1);
                if (ii < len - 1) {
                    this.writeListSep();
                }
                lastWasSL = false;
            }
            if (!lastWasSL) {
                this.writeIndent(indent);
            }
            this.writeListEnd();
            this.writeln();
        } else {
            this.writeIndent(indent);
            this.writeClazzTag(expectedClass, o);
            this.writeln();
            FSTClazzInfo clInfo = this.conf.getCLInfoRegistry().getCLInfo(o.getClass());
            FSTClazzInfo.FSTFieldInfo[] fieldInfo = clInfo.getFieldInfo();
            for (int i = 0; i < fieldInfo.length; ++i) {
                FSTClazzInfo.FSTFieldInfo fstFieldInfo = fieldInfo[i];
                Class expectedKey = Kson.fumbleOutGenericKeyType(fstFieldInfo.getField());
                Class expectedValue = Kson.fumbleOutGenericValueType(fstFieldInfo.getField());
                Object fieldValue = fstFieldInfo.getField().get(o);
                if (this.isNullValue(fstFieldInfo, fieldValue) && !this.writeNull) continue;
                this.writeIndent(indent + 1);
                String name = fstFieldInfo.getField().getName();
                this.writeKey(name);
                this.out.writeChar(':');
                if (this.isSingleLine(fstFieldInfo, fieldValue)) {
                    this.out.writeString(" ");
                    this.writeObjectInternal(expectedKey, expectedValue, fieldValue, 0);
                    this.writeListSep();
                    continue;
                }
                this.writeln();
                this.writeObjectInternal(expectedKey, expectedValue, fieldValue, indent + 2);
                this.writeListSep();
            }
            this.removeLastListSep();
            this.writeIndent(indent);
            this.out.writeChar('}');
            this.writeln();
        }
    }

    protected void writeKey(String name) {
        this.out.writeString(name);
    }

    protected void writeClazzTag(Class expectedClass, Object o) {
        if (expectedClass == o.getClass()) {
            this.out.writeString("{");
        } else {
            String stringForType = this.mapper.getStringForType(o.getClass());
            this.out.writeString(stringForType + " {");
        }
    }

    protected void writeListEnd() {
        this.out.writeChar(']');
    }

    protected void writeListStart() {
        this.out.writeString("[ ");
    }

    protected void removeLastListSep() {
    }

    protected void writeListSep() {
    }

    private boolean isSingleLine(FSTClazzInfo.FSTFieldInfo fstFieldInfo, Object fieldValue) {
        if (fstFieldInfo == null) {
            if (fieldValue instanceof Class) {
                Class clz = (Class)fieldValue;
                return this.isSingleLineCLazz(clz);
            }
            return fieldValue == null || this.isSingleLineCLazz(fieldValue.getClass());
        }
        if (fstFieldInfo.isArray() && this.isSingleLine(null, fstFieldInfo.getType().getComponentType())) {
            return true;
        }
        return fieldValue == null || this.isSingleLineCLazz(fieldValue.getClass()) || this.isSingleLineCLazz(fstFieldInfo.getType());
    }

    private boolean isSingleLineCLazz(Class clz) {
        return String.class.isAssignableFrom(clz) || Number.class.isAssignableFrom(clz) || clz.isPrimitive() || clz == Boolean.class || clz == Character.class;
    }

    private boolean isNullValue(FSTClazzInfo.FSTFieldInfo fstFieldInfo, Object fieldValue) {
        if (fieldValue == null) {
            return true;
        }
        if (this.writeNull) {
            return false;
        }
        if (fstFieldInfo != null && fstFieldInfo.getType().isPrimitive()) {
            if (fieldValue instanceof Number) {
                return ((Number)fieldValue).doubleValue() == 0.0;
            }
            return fieldValue.equals(zeroC) || fieldValue.equals(Boolean.FALSE);
        }
        return false;
    }

    protected void writeln() {
        if (this.pretty) {
            this.out.writeChar('\n');
        }
    }

    public void writeString(String string) {
        if (string == null) {
            this.out.writeString("null");
            return;
        }
        if (string.length() == 0) {
            this.out.writeString("\"\"");
            return;
        }
        char c = '\u0000';
        int len = string.length();
        boolean ws = this.shouldQuote(string);
        if (ws) {
            this.out.writeChar('\"');
        }
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    this.out.writeChar('\\');
                    this.out.writeChar(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        this.out.writeChar('\\');
                    }
                    this.out.writeChar(c);
                    continue block9;
                }
                case '\b': {
                    this.out.writeString("\\b");
                    continue block9;
                }
                case '\t': {
                    this.out.writeString("\\t");
                    continue block9;
                }
                case '\n': {
                    this.out.writeString("\\n");
                    continue block9;
                }
                case '\f': {
                    this.out.writeString("\\f");
                    continue block9;
                }
                case '\r': {
                    this.out.writeString("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        this.out.writeString("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    this.out.writeChar(c);
                }
            }
        }
        if (ws) {
            this.out.writeChar('\"');
        }
    }

    protected boolean shouldQuote(String string) {
        boolean ws = false;
        for (int ii = 0; ii < string.length(); ++ii) {
            char ch = string.charAt(ii);
            if (ii == 0 && !Character.isLetter(ch)) {
                return true;
            }
            if (Character.isLetterOrDigit(ch) || ch == '_' || ch == '-' || ch == '(' || ch == ')' || ch == '[' || ch == ']' || ch == '.') continue;
            ws = true;
            break;
        }
        return ws;
    }

    protected void writeIndent(int indent) {
        if (this.pretty) {
            for (int i = 0; i < indent * 2; ++i) {
                this.out.writeChar(' ');
            }
        }
    }

    public boolean isWriteNull() {
        return this.writeNull;
    }

    public void setWriteNull(boolean writeNull) {
        this.writeNull = writeNull;
    }

    public void writeObject(Object o, Class aClass) throws Exception {
        this.writeObjectInternal(aClass, null, o, 0);
    }
}

