/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.offheap.structs;

import org.nustaq.offheap.bytez.Bytez;
import org.nustaq.offheap.bytez.BytezAllocator;
import org.nustaq.offheap.bytez.malloc.MallocBytezAllocator;
import org.nustaq.offheap.bytez.onheap.HeapBytezAllocator;
import org.nustaq.offheap.structs.FSTStruct;
import org.nustaq.offheap.structs.structtypes.StructArray;
import org.nustaq.offheap.structs.unsafeimpl.FSTStructFactory;
import org.nustaq.serialization.util.FSTUtil;

public class FSTStructAllocator {
    protected int chunkSize;
    protected Bytez chunk;
    protected int chunkIndex;
    BytezAllocator alloc = new HeapBytezAllocator();
    int chunkObjCount = 0;

    protected FSTStructAllocator() {
    }

    public static FSTStruct createStructPointer(Bytez b, int index) {
        return FSTStructFactory.getInstance().getStructPointerByOffset(b, index).detach();
    }

    public static <T extends FSTStruct> T toStruct(T onHeapTemplate) {
        return FSTStructFactory.getInstance().toStruct(onHeapTemplate);
    }

    public static FSTStruct getVolatileStructPointer(Bytez b, int index) {
        return FSTStructFactory.getInstance().getStructPointerByOffset(b, index);
    }

    public static <C extends FSTStruct> C newPointer(Class<C> clazz) {
        try {
            return (C)((FSTStruct)FSTStructAllocator.allocInstance(clazz));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static <C extends FSTStruct> Object allocInstance(Class<C> clazz) throws Exception {
        return FSTUtil.getUnsafe().allocateInstance(FSTStructFactory.getInstance().getProxyClass(clazz));
    }

    public FSTStructAllocator(int chunkSizeBytes) {
        this.chunkSize = chunkSizeBytes;
    }

    public FSTStructAllocator(int chunkSizeBytes, BytezAllocator allocator) {
        this.chunkSize = chunkSizeBytes;
        this.alloc = allocator;
    }

    public <X extends FSTStruct> StructArray<X> newArray(int size, X templ) {
        return this.newArray(size, templ, this.alloc);
    }

    public <X extends FSTStruct> StructArray<X> newArray(int size, X templ, BytezAllocator alloc) {
        StructArray<X> aTemplate = new StructArray<X>(size, templ);
        int siz = this.getFactory().calcStructSize(aTemplate);
        try {
            if (siz < this.chunkSize) {
                return this.newStruct(aTemplate);
            }
            return this.getFactory().toStruct(aTemplate, alloc);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void free() {
        this.alloc.freeAll();
    }

    public <S extends FSTStruct> S newStruct(S aTemplate) {
        return this.newStruct(aTemplate, this.alloc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends FSTStruct> S newStruct(S aTemplate, BytezAllocator alloc) {
        aTemplate = this.getFactory().toStruct(aTemplate);
        if (aTemplate.getByteSize() >= this.chunkSize) {
            return (S)aTemplate.createCopy();
        }
        int byteSize = aTemplate.getByteSize();
        FSTStructAllocator fSTStructAllocator = this;
        synchronized (fSTStructAllocator) {
            if (this.chunk == null || (long)(this.chunkIndex + byteSize) >= this.chunk.length()) {
                this.chunk = alloc.alloc(this.chunkSize);
                System.out.println("[Allocator] sum allocated " + MallocBytezAllocator.alloced.get() / 1024L / 1024L + " MB");
                this.chunkIndex = 0;
                this.chunkObjCount = 0;
            }
            aTemplate.___bytes.copyTo(this.chunk, this.chunkIndex, aTemplate.___offset, byteSize);
            FSTStruct res = this.getFactory().createStructWrapper(this.chunk, this.chunkIndex);
            this.chunkIndex += byteSize;
            ++this.chunkObjCount;
            return (S)res;
        }
    }

    protected FSTStructFactory getFactory() {
        return FSTStructFactory.getInstance();
    }
}

