/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.heapoff;

import de.ruedigermoeller.serialization.FSTConfiguration;
import de.ruedigermoeller.serialization.FSTObjectInput;
import de.ruedigermoeller.serialization.FSTObjectOutput;
import de.ruedigermoeller.serialization.util.FSTOrderedConcurrentJobExecutor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;

public class FSTOffheapQueue {
    private static final int HEADER_SIZE = 4;
    ByteBuffer buffer;
    FSTConfiguration conf = FSTConfiguration.createDefaultConfiguration();
    int headPosition = 0;
    int tailPosition = 0;
    int currentQeueEnd = 0;
    int count = 0;
    private final FSTOrderedConcurrentJobExecutor writeExec;
    private final FSTOrderedConcurrentJobExecutor readExec;
    BlockingQueue resQueue;
    ArrayList<FSTObjectOutput> outputs = new ArrayList();
    Object rwLock = "QueueRW";
    ConcurrentWriteContext writer;
    ConcurrentReadContext reader;
    boolean terminatePrefetch = false;
    private boolean prefetcherAlive = false;
    Thread prefetcher = new Thread("prefetch"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!FSTOffheapQueue.this.terminatePrefetch) {
                try {
                    FSTOffheapQueue.this.preFetch();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Object object = FSTOffheapQueue.this.rwLock;
            synchronized (object) {
                FSTOffheapQueue.this.prefetcherAlive = false;
            }
        }
    };
    final ByteBufferResult prefBuff = new ByteBufferResult();
    ThreadLocal<FSTObjectInput> thinp = new ThreadLocal();

    public FSTOffheapQueue(int sizeMB) throws IOException {
        this(ByteBuffer.allocateDirect(sizeMB * 1000 * 1000), 4);
    }

    public FSTOffheapQueue(int sizeMB, int numThreads) throws IOException {
        this(ByteBuffer.allocateDirect(sizeMB * 1000 * 1000), 4);
    }

    public FSTOffheapQueue(ByteBuffer buffer) throws IOException {
        this(buffer, 4);
    }

    public FSTOffheapQueue(ByteBuffer buffer, int numThreads) throws IOException {
        this.buffer = buffer;
        this.currentQeueEnd = buffer.limit();
        this.writer = this.createConcurrentWriter();
        this.reader = this.createConcurrentReader();
        this.writeExec = new FSTOrderedConcurrentJobExecutor(numThreads);
        this.readExec = new FSTOrderedConcurrentJobExecutor(numThreads);
        this.resQueue = new LinkedBlockingQueue(numThreads * 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FSTObjectOutput getCachedOutput() {
        ArrayList<FSTObjectOutput> arrayList = this.outputs;
        synchronized (arrayList) {
            if (this.outputs.size() == 0) {
                return new FSTObjectOutput(this.conf);
            }
            FSTObjectOutput ret = this.outputs.get(this.outputs.size() - 1);
            this.outputs.remove(this.outputs.size() - 1);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnOut(FSTObjectOutput ou) {
        ArrayList<FSTObjectOutput> arrayList = this.outputs;
        synchronized (arrayList) {
            this.outputs.add(ou);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startPrefetch() {
        if (this.prefetcherAlive) {
            return;
        }
        Object object = this.rwLock;
        synchronized (object) {
            this.terminatePrefetch = false;
            if (!this.prefetcherAlive) {
                this.prefetcherAlive = true;
                this.prefetcher.start();
            }
        }
    }

    public boolean addBytes(byte[] b) throws IOException {
        int siz = b.length;
        return this.addBytes(siz, b);
    }

    public boolean add(Object o) throws IOException {
        return this.writer.add(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConcurrent(final Object o) throws IOException, ExecutionException, InterruptedException {
        FSTOrderedConcurrentJobExecutor fSTOrderedConcurrentJobExecutor = this.writeExec;
        synchronized (fSTOrderedConcurrentJobExecutor) {
            this.writeExec.addCall(new FSTOrderedConcurrentJobExecutor.FSTRunnable(){
                FSTObjectOutput tmp;

                @Override
                public void runConcurrent() {
                    this.tmp = FSTOffheapQueue.this.getCachedOutput();
                    this.tmp.resetForReUse();
                    try {
                        this.tmp.writeObject(o);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void runInOrder() {
                    int siz = this.tmp.getWritten();
                    byte[] towrite = this.tmp.getBuffer();
                    FSTOffheapQueue.this.addBytes(siz, towrite);
                    FSTOffheapQueue.this.returnOut(this.tmp);
                }
            });
        }
    }

    public void waitForFinish() throws InterruptedException {
        this.writeExec.waitForFinish();
    }

    public ConcurrentWriteContext createConcurrentWriter() {
        return new ConcurrentWriteContext();
    }

    public ConcurrentReadContext createConcurrentReader() throws IOException {
        return new ConcurrentReadContext();
    }

    void preFetch() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException, InterruptedException {
        if (this.takeBytes(this.prefBuff)) {
            final byte[] b = this.prefBuff.b;
            this.readExec.addCall(new FSTOrderedConcurrentJobExecutor.FSTRunnable(){
                FSTObjectInput inp;
                Object result;

                @Override
                public void runConcurrent() {
                    try {
                        this.inp = FSTOffheapQueue.this.thinp.get();
                        if (this.inp == null) {
                            try {
                                this.inp = new FSTObjectInput(FSTOffheapQueue.this.conf);
                                FSTOffheapQueue.this.thinp.set(this.inp);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                        this.inp.resetForReuseUseArray(b, 0, b.length);
                        this.result = this.inp.readObject();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void runInOrder() {
                    try {
                        FSTOffheapQueue.this.resQueue.put(this.result);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addBytes(int siz, byte[] towrite) {
        Object object = this.rwLock;
        synchronized (object) {
            boolean full;
            if (siz + this.tailPosition + 4 >= this.buffer.limit()) {
                this.currentQeueEnd = this.tailPosition;
                this.tailPosition = 0;
            }
            boolean bl = full = this.count > 0;
            if (full) {
                full = this.tailPosition < this.headPosition ? this.tailPosition + siz >= this.headPosition : this.tailPosition <= this.headPosition;
            }
            if (!full) {
                this.buffer.putInt(this.tailPosition, siz);
                this.buffer.position(this.tailPosition + 4);
                this.buffer.put(towrite, 0, siz);
                this.tailPosition += siz + 4;
                ++this.count;
                this.rwLock.notifyAll();
            } else {
                try {
                    this.rwLock.wait();
                    this.addBytes(siz, towrite);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    public Object takeObject(int[] sizeResult) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        return this.reader.takeObject(sizeResult);
    }

    public Object takeObjectConcurrent() throws InterruptedException {
        this.startPrefetch();
        return this.resQueue.take();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean takeBytes(ByteBufferResult res) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        Object object = this.rwLock;
        synchronized (object) {
            if (this.headPosition == this.currentQeueEnd) {
                this.headPosition = 0;
            }
            while (this.count <= 0) {
                try {
                    this.rwLock.wait();
                }
                catch (InterruptedException e) {
                    return false;
                }
                if (this.headPosition != this.currentQeueEnd) continue;
                this.headPosition = 0;
            }
            res.len = this.buffer.getInt(this.headPosition);
            this.buffer.position(this.headPosition + 4);
            byte[] b = new byte[res.len];
            this.buffer.get(b);
            res.buffer = ByteBuffer.wrap(b);
            res.off = 0;
            res.b = b;
            this.headPosition += res.len + 4;
            --this.count;
            this.rwLock.notifyAll();
        }
        return true;
    }

    public class ConcurrentReadContext {
        FSTObjectInput in;
        ByteBufferResult tmpRes = new ByteBufferResult();

        public ConcurrentReadContext() throws IOException {
            this.in = new FSTObjectInput(FSTOffheapQueue.this.conf);
        }

        public Object takeObject(int[] sizeResult) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
            if (FSTOffheapQueue.this.takeBytes(this.tmpRes)) {
                this.in.resetForReuseUseArray(this.tmpRes.b, 0, this.tmpRes.b.length);
                if (sizeResult != null) {
                    sizeResult[0] = this.tmpRes.b.length;
                }
                return this.in.readObject();
            }
            return null;
        }
    }

    public class ConcurrentWriteContext {
        FSTObjectOutput out;

        public ConcurrentWriteContext() {
            this.out = new FSTObjectOutput(FSTOffheapQueue.this.conf);
        }

        public boolean add(Object o) throws IOException {
            this.out.resetForReUse();
            this.out.writeObject(o);
            int siz = this.out.getWritten();
            byte[] towrite = this.out.getBuffer();
            return FSTOffheapQueue.this.addBytes(siz, towrite);
        }
    }

    public static class ByteBufferResult {
        public int off;
        public int len;
        public ByteBuffer buffer;
        public byte[] b;
    }
}

