/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.heapoff;

import de.ruedigermoeller.heapoff.FSTByteBufferOffheap;
import de.ruedigermoeller.serialization.FSTConfiguration;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FSTOffHeapMap<K, V>
extends AbstractMap<K, V> {
    HashMap<K, Integer> hmap;
    FSTByteBufferOffheap heap;
    FSTByteBufferOffheap.OffHeapAccess access;

    public FSTOffHeapMap(FSTByteBufferOffheap heap) {
        this.heap = heap;
        this.hmap = new HashMap();
        this.access = heap.createAccess();
    }

    public FSTOffHeapMap(int sizeMB) throws IOException {
        this.heap = new FSTByteBufferOffheap(sizeMB);
        this.hmap = new HashMap();
        this.access = this.heap.createAccess();
    }

    public FSTConfiguration getConf() {
        return this.getHeap().getConf();
    }

    @Override
    public int size() {
        return this.hmap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.hmap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hmap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<K> iterator = this.hmap.keySet().iterator();
        while (iterator.hasNext()) {
            V v = this.get(iterator.next());
            if (v == null || !v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Integer integer = this.hmap.get(key);
        try {
            Object res = this.access.getObject(integer);
            if (res == null) {
                return null;
            }
            return (V)res;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public V put(K key, V value) {
        try {
            if (this.hmap.containsKey(key)) {
                return this.get(key);
            }
            int res = this.access.add(value, null);
            this.hmap.put(key, res);
            return value;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public V remove(Object key) {
        V res = this.get(key);
        this.hmap.remove(key);
        return res;
    }

    @Override
    public void clear() {
        this.hmap.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new FSTOffHeapMapEntrySet();
    }

    public FSTByteBufferOffheap getHeap() {
        return this.heap;
    }

    private final class FSTOffHeapMapEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private FSTOffHeapMapEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            final Iterator it = FSTOffHeapMap.this.hmap.keySet().iterator();
            return new Iterator<Map.Entry<K, V>>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    final Object next = it.next();
                    return new Map.Entry<K, V>(){
                        V cachedV;

                        @Override
                        public K getKey() {
                            return next;
                        }

                        @Override
                        public V getValue() {
                            if (this.cachedV == null) {
                                this.cachedV = FSTOffHeapMap.this.get(next);
                            }
                            return this.cachedV;
                        }

                        @Override
                        public V setValue(V value) {
                            throw new RuntimeException("not implemented");
                        }

                        @Override
                        public boolean equals(Object o) {
                            boolean res = false;
                            if (o instanceof Map.Entry) {
                                Map.Entry e = (Map.Entry)o;
                                if (this.getValue() != null) {
                                    return this.getKey().equals(((Map.Entry)o).getKey()) && this.getValue().equals(((Map.Entry)o).getValue());
                                }
                                return this.getKey().equals(((Map.Entry)o).getKey()) && ((Map.Entry)o).getValue() == null;
                            }
                            return false;
                        }

                        @Override
                        public int hashCode() {
                            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
                        }
                    };
                }

                @Override
                public void remove() {
                    throw new RuntimeException("not implemented");
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public int size() {
            return FSTOffHeapMap.this.hmap.size();
        }

        @Override
        public void clear() {
            FSTOffHeapMap.this.hmap.clear();
        }
    }
}

