/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization;

import de.ruedigermoeller.serialization.FSTClazzInfo;
import de.ruedigermoeller.serialization.FSTSerializerRegistry;
import de.ruedigermoeller.serialization.FSTSerializerRegistryDelegate;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSTClazzInfoRegistry {
    HashMap mInfos = new HashMap(97);
    FSTSerializerRegistry serializerRegistry = new FSTSerializerRegistry();
    boolean ignoreAnnotations = false;
    final AtomicBoolean rwLock = new AtomicBoolean(false);
    private boolean structMode = false;

    public static void addAllReferencedClasses(Class cl, ArrayList<String> names) {
        HashSet<String> names1 = new HashSet<String>();
        FSTClazzInfoRegistry.addAllReferencedClasses(cl, names1, new HashSet<String>());
        names.addAll(names1);
    }

    static void addAllReferencedClasses(Class cl, HashSet<String> names, HashSet<String> topLevelDone) {
        if (cl == null || topLevelDone.contains(cl.getName())) {
            return;
        }
        topLevelDone.add(cl.getName());
        Field[] declaredFields = cl.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            Field declaredField = declaredFields[i];
            Class<?> type = declaredField.getType();
            if (type.isPrimitive() || type.isArray()) continue;
            names.add(type.getName());
            FSTClazzInfoRegistry.addAllReferencedClasses(type, names, topLevelDone);
        }
        Class<?>[] declaredClasses = cl.getDeclaredClasses();
        for (int i = 0; i < declaredClasses.length; ++i) {
            Class<?> declaredClass = declaredClasses[i];
            if (declaredClass.isPrimitive() || declaredClass.isArray()) continue;
            names.add(declaredClass.getName());
            FSTClazzInfoRegistry.addAllReferencedClasses(declaredClass, names, topLevelDone);
        }
        Method[] declaredMethods = cl.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method declaredMethod = declaredMethods[i];
            Class<?> returnType = declaredMethod.getReturnType();
            if (!returnType.isPrimitive() && !returnType.isArray()) {
                names.add(returnType.getName());
                FSTClazzInfoRegistry.addAllReferencedClasses(returnType, names, topLevelDone);
            }
            Class<?>[] parameterTypes = declaredMethod.getParameterTypes();
            for (int j = 0; j < parameterTypes.length; ++j) {
                Class<?> parameterType = parameterTypes[j];
                if (parameterType.isPrimitive() || parameterType.isArray()) continue;
                names.add(parameterType.getName());
                FSTClazzInfoRegistry.addAllReferencedClasses(parameterType, names, topLevelDone);
            }
        }
        Class<?>[] classes = cl.getDeclaredClasses();
        for (int i = 0; i < classes.length; ++i) {
            Class<?> aClass = classes[i];
            if (aClass.isPrimitive() || aClass.isArray()) continue;
            names.add(aClass.getName());
            FSTClazzInfoRegistry.addAllReferencedClasses(aClass, names, topLevelDone);
        }
        Class<?> enclosingClass = cl.getEnclosingClass();
        if (enclosingClass != null) {
            names.add(enclosingClass.getName());
            FSTClazzInfoRegistry.addAllReferencedClasses(enclosingClass, names, topLevelDone);
        }
        names.add(cl.getName());
        FSTClazzInfoRegistry.addAllReferencedClasses(cl.getSuperclass(), names, topLevelDone);
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            if (anInterface.isPrimitive() || anInterface.isArray()) continue;
            names.add(anInterface.getName());
            FSTClazzInfoRegistry.addAllReferencedClasses(anInterface, names, topLevelDone);
        }
    }

    public FSTClazzInfo getCLInfo(Class c) {
        while (!this.rwLock.compareAndSet(false, true)) {
        }
        FSTClazzInfo res = (FSTClazzInfo)this.mInfos.get(c);
        if (res == null) {
            if (c == null) {
                this.rwLock.set(false);
                throw new NullPointerException("Class is null");
            }
            res = new FSTClazzInfo(c, this, this.ignoreAnnotations);
            this.mInfos.put(c, res);
        }
        this.rwLock.set(false);
        return res;
    }

    public final boolean isIgnoreAnnotations() {
        return this.ignoreAnnotations;
    }

    public void setIgnoreAnnotations(boolean ignoreAnnotations) {
        this.ignoreAnnotations = ignoreAnnotations;
    }

    public void setSerializerRegistryDelegate(FSTSerializerRegistryDelegate delegate) {
        this.serializerRegistry.setDelegate(delegate);
    }

    public FSTSerializerRegistryDelegate getSerializerRegistryDelegate() {
        return this.serializerRegistry.getDelegate();
    }

    public void setStructMode(boolean structMode) {
        this.structMode = structMode;
    }

    public boolean isStructMode() {
        return this.structMode;
    }
}

