/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.heapoff.bytez.onheap;

import de.ruedigermoeller.heapoff.bytez.Bytez;
import de.ruedigermoeller.heapoff.bytez.malloc.MallocBytez;
import de.ruedigermoeller.serialization.util.FSTUtil;
import sun.misc.Unsafe;

public class HeapBytez
implements Bytez {
    static Unsafe unsafe = FSTUtil.getUnsafe();
    static long byteoff = FSTUtil.bufoff;
    static long caoff = FSTUtil.choff;
    static long saoff = FSTUtil.choff;
    static long iaoff = FSTUtil.intoff;
    static long laoff = FSTUtil.longoff;
    static long daoff = FSTUtil.doubleoff;
    static long faoff = FSTUtil.floatoff;
    byte[] base;
    long off;
    long len;

    public HeapBytez(byte[] base) {
        this(base, 0L);
    }

    public HeapBytez(byte[] base, long off) {
        this(base, off, (long)base.length - off);
    }

    public HeapBytez(byte[] base, long off, long len) {
        this.base = base;
        this.off = byteoff + off;
        this.len = len;
    }

    public byte get(long byteIndex) {
        return unsafe.getByte(this.base, this.off + byteIndex);
    }

    public boolean getBool(long byteIndex) {
        return unsafe.getByte(this.base, this.off + byteIndex) != 0;
    }

    public char getChar(long byteIndex) {
        return unsafe.getChar(this.base, this.off + byteIndex);
    }

    public short getShort(long byteIndex) {
        return unsafe.getShort(this.base, this.off + byteIndex);
    }

    public int getInt(long byteIndex) {
        int res = unsafe.getInt(this.base, this.off + byteIndex);
        return res;
    }

    public long getLong(long byteIndex) {
        return unsafe.getLong(this.base, this.off + byteIndex);
    }

    public float getFloat(long byteIndex) {
        return unsafe.getFloat(this.base, this.off + byteIndex);
    }

    public double getDouble(long byteIndex) {
        return unsafe.getDouble(this.base, this.off + byteIndex);
    }

    public void put(long byteIndex, byte value) {
        unsafe.putByte(this.base, this.off + byteIndex, value);
    }

    public void putBool(long byteIndex, boolean val) {
        this.put(byteIndex, (byte)(val ? 1 : 0));
    }

    public void putChar(long byteIndex, char c) {
        unsafe.putChar(this.base, this.off + byteIndex, c);
    }

    public void putShort(long byteIndex, short s) {
        unsafe.putShort(this.base, this.off + byteIndex, s);
    }

    public void putInt(long byteIndex, int i) {
        unsafe.putInt(this.base, this.off + byteIndex, i);
    }

    public void putLong(long byteIndex, long l) {
        unsafe.putLong(this.base, this.off + byteIndex, l);
    }

    public void putFloat(long byteIndex, float f) {
        unsafe.putFloat(this.base, this.off + byteIndex, f);
    }

    public void putDouble(long byteIndex, double d) {
        unsafe.putDouble(this.base, this.off + byteIndex, d);
    }

    public long length() {
        return this.base.length;
    }

    public void getArr(long byteIndex, byte[] target, int elemoff, int numElems) {
        unsafe.copyMemory(this.base, this.off + byteIndex, target, this.off + (long)elemoff, numElems);
    }

    public void getCharArr(long byteIndex, char[] target, int elemoff, int numElems) {
        unsafe.copyMemory(this.base, this.off + byteIndex, target, caoff + (long)(elemoff * 2) + this.off - byteoff, numElems * 2);
    }

    public void getShortArr(long byteIndex, short[] target, int elemoff, int numElems) {
        unsafe.copyMemory(this.base, this.off + byteIndex, target, saoff + (long)(elemoff * 2) + this.off - byteoff, numElems * 2);
    }

    public void getIntArr(long byteIndex, int[] target, int elemoff, int numElems) {
        unsafe.copyMemory(this.base, this.off + byteIndex, target, iaoff + (long)(elemoff * 4) + this.off - byteoff, numElems * 4);
    }

    public void getLongArr(long byteIndex, long[] target, int elemoff, int numElems) {
        unsafe.copyMemory(this.base, this.off + byteIndex, target, laoff + (long)(elemoff * 8) + this.off - byteoff, numElems * 8);
    }

    public void getFloatArr(long byteIndex, float[] target, int elemoff, int numElems) {
        unsafe.copyMemory(this.base, this.off + byteIndex, target, faoff + (long)(elemoff * 4) + this.off - byteoff, numElems * 4);
    }

    public void getDoubleArr(long byteIndex, double[] target, int elemoff, int numElems) {
        unsafe.copyMemory(this.base, this.off + byteIndex, target, daoff + (long)(elemoff * 4) + this.off - byteoff, numElems * 8);
    }

    public void set(long byteIndex, byte[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, this.off + (long)elemoff, this.base, this.off + byteIndex, numElems);
    }

    public void setChar(long byteIndex, char[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, caoff + this.off - byteoff + (long)(elemoff * 2), this.base, this.off + byteIndex, numElems * 2);
    }

    public void setShort(long byteIndex, short[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, caoff + this.off - byteoff + (long)(elemoff * 2), this.base, this.off + byteIndex, numElems * 2);
    }

    public void setInt(long byteIndex, int[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, iaoff + this.off - byteoff + (long)(elemoff * 4), this.base, this.off + byteIndex, numElems * 4);
    }

    public void setLong(long byteIndex, long[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, laoff + this.off - byteoff + (long)(elemoff * 8), this.base, this.off + byteIndex, numElems * 8);
    }

    public void setFloat(long byteIndex, float[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, faoff + this.off - byteoff + (long)(elemoff * 4), this.base, this.off + byteIndex, numElems * 4);
    }

    public void setDouble(long byteIndex, double[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, daoff + this.off - byteoff + (long)(elemoff * 8), this.base, this.off + byteIndex, numElems * 8);
    }

    public void setBoolean(int byteIndex, boolean[] o, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            this.put(byteIndex + i, (byte)(o[i + elemoff] ? 1 : 0));
        }
    }

    public void copyTo(Bytez other, long otherByteIndex, long myByteIndex, long lenBytes) {
        if (other instanceof HeapBytez) {
            HeapBytez hp = (HeapBytez)other;
            unsafe.copyMemory(this.base, this.off + myByteIndex, hp.base, hp.off + otherByteIndex, lenBytes);
        } else if (other instanceof MallocBytez) {
            MallocBytez mb = (MallocBytez)other;
            unsafe.copyMemory(this.base, this.off + myByteIndex, null, otherByteIndex + mb.getBaseAdress(), lenBytes);
        } else {
            for (long i = 0L; i < lenBytes; ++i) {
                other.put(otherByteIndex + i, this.get(myByteIndex + i));
            }
        }
    }

    public Bytez newInstance(long size) {
        return new HeapBytez(new byte[(int)size]);
    }

    public boolean compareAndSwapInt(long offset, int expect, int newVal) {
        return unsafe.compareAndSwapInt(this.base, this.off + offset, expect, newVal);
    }

    public boolean compareAndSwapLong(long offset, long expect, long newVal) {
        return unsafe.compareAndSwapLong(this.base, this.off + offset, expect, newVal);
    }

    public byte[] toBytes(int startIndex, int len) {
        byte[] res = new byte[len];
        System.arraycopy(this.base, (int)(this.off - FSTUtil.bufoff) + startIndex, res, 0, len);
        return res;
    }

    public byte[] asByteArray() {
        return this.base;
    }

    public int getBAOffsetIndex() {
        return (int)(this.off - FSTUtil.bufoff);
    }

    public int getBALength() {
        return 0;
    }

    public int hashCode() {
        return this.base.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof HeapBytez) {
            return this.base == ((HeapBytez)obj).base;
        }
        return false;
    }

    public boolean getBoolVolatile(long byteIndex) {
        return this.getVolatile(byteIndex) != 0;
    }

    public byte getVolatile(long byteIndex) {
        return unsafe.getByteVolatile(this.base, this.off + byteIndex);
    }

    public char getCharVolatile(long byteIndex) {
        return unsafe.getCharVolatile(this.base, this.off + byteIndex);
    }

    public short getShortVolatile(long byteIndex) {
        return unsafe.getShortVolatile(this.base, this.off + byteIndex);
    }

    public int getIntVolatile(long byteIndex) {
        return unsafe.getIntVolatile(this.base, this.off + byteIndex);
    }

    public long getLongVolatile(long byteIndex) {
        return unsafe.getLongVolatile(this.base, this.off + byteIndex);
    }

    public float getFloatVolatile(long byteIndex) {
        return unsafe.getFloatVolatile(this.base, this.off + byteIndex);
    }

    public double getDoubleVolatile(long byteIndex) {
        return unsafe.getDoubleVolatile(this.base, this.off + byteIndex);
    }

    public void putBoolVolatile(long byteIndex, boolean value) {
        this.putVolatile(byteIndex, (byte)(value ? 1 : 0));
    }

    public void putVolatile(long byteIndex, byte value) {
        unsafe.putByteVolatile(this.base, this.off + byteIndex, value);
    }

    public void putCharVolatile(long byteIndex, char c) {
        unsafe.putCharVolatile(this.base, this.off + byteIndex, c);
    }

    public void putShortVolatile(long byteIndex, short s) {
        unsafe.putShortVolatile(this.base, this.off + byteIndex, s);
    }

    public void putIntVolatile(long byteIndex, int i) {
        unsafe.putIntVolatile(this.base, this.off + byteIndex, i);
    }

    public void putLongVolatile(long byteIndex, long l) {
        unsafe.putLongVolatile(this.base, this.off + byteIndex, l);
    }

    public void putFloatVolatile(long byteIndex, float f) {
        unsafe.putFloatVolatile(this.base, this.off + byteIndex, f);
    }

    public void putDoubleVolatile(long byteIndex, double d) {
        unsafe.putDoubleVolatile(this.base, this.off + byteIndex, d);
    }

    public byte[] getBase() {
        return this.base;
    }

    public long getOff() {
        return this.off;
    }
}

