/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization;

import de.ruedigermoeller.heapoff.structs.unsafeimpl.FSTStructFactory;
import de.ruedigermoeller.serialization.FSTClazzInfo;
import de.ruedigermoeller.serialization.FSTConfiguration;
import de.ruedigermoeller.serialization.FSTObjectInput;
import de.ruedigermoeller.serialization.FSTObjectOutput;
import de.ruedigermoeller.serialization.util.FSTInt2ObjectMap;
import de.ruedigermoeller.serialization.util.FSTObject2IntMap;
import de.ruedigermoeller.serialization.util.FSTUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class FSTClazzNameRegistry {
    FSTObject2IntMap<Class> clzToId = new FSTObject2IntMap(13, false);
    FSTInt2ObjectMap idToClz = new FSTInt2ObjectMap(13);
    int classIdCount = 3;
    int lastCatch;
    FSTClazzNameRegistry parent;
    private FSTConfiguration conf;
    HashMap<String, Class> classCache = new HashMap(200);
    AtomicBoolean classCacheLock = new AtomicBoolean(false);

    public FSTClazzNameRegistry(FSTClazzNameRegistry par, FSTConfiguration conf) {
        this.parent = par;
        this.conf = conf;
        if (this.parent != null) {
            this.classIdCount = this.parent.classIdCount + 1;
        }
    }

    public void clear() {
        this.lastCatch = 0;
        this.clzToId.clear();
        this.idToClz.clear();
        this.classIdCount = 3;
        if (this.parent != null) {
            this.classIdCount = this.parent.classIdCount + 1;
        }
    }

    public void registerClass(Class c) {
        this.registerClass(c, false);
    }

    void registerClass(Class c, boolean forRead) {
        if (this.getIdFromClazz(c) != Integer.MIN_VALUE) {
            return;
        }
        this.addClassMapping(c, this.classIdCount++);
        Class[] pred = this.conf.getCLInfoRegistry().getCLInfo(c).getPredict();
        if (pred != null) {
            for (int i = 0; i < pred.length; ++i) {
                Class aClass = pred[i];
                this.registerClass(aClass);
            }
        }
    }

    public void registerClass(Class c, int code) {
        if (this.getIdFromClazz(c) != Integer.MIN_VALUE) {
            return;
        }
        this.addClassMapping(c, code);
    }

    protected void addClassMapping(Class c, int id) {
        this.clzToId.put(c, id);
        FSTClazzInfo clInfo = this.conf.getCLInfoRegistry().getCLInfo(c);
        this.idToClz.put(id, clInfo);
        if (this.parent == null) {
            clInfo.setClzId(id);
        }
    }

    public int getIdFromClazz(Class c) {
        int res = Integer.MIN_VALUE;
        if (this.parent != null) {
            res = this.parent.getIdFromClazz(c);
        }
        if (res == Integer.MIN_VALUE) {
            res = this.clzToId.get(c);
        }
        return res;
    }

    public void encodeClass(FSTObjectOutput out, FSTClazzInfo ci) throws IOException {
        int clzId = ci.getClzId();
        if (clzId >= 0) {
            out.writeCShort((short)clzId);
        } else {
            this.encodeClass(out, ci.getClazz());
        }
    }

    public void encodeClass(FSTObjectOutput out, Class c) throws IOException {
        int clid = this.getIdFromClazz(c);
        if (clid != Integer.MIN_VALUE) {
            out.writeCShort((short)clid);
        } else {
            out.writeCShort((short)0);
            out.writeStringUTF(c.getName());
            this.registerClass(c, false);
        }
    }

    public FSTClazzInfo decodeClass(FSTObjectInput in) throws IOException, ClassNotFoundException {
        short c = in.readCShort();
        if (c == 0) {
            String clName = in.readStringUTF();
            Class cl = this.classForName(clName);
            this.registerClass(cl, true);
            return this.conf.getCLInfoRegistry().getCLInfo(cl);
        }
        FSTClazzInfo aClass = this.getClazzFromId(c);
        if (aClass == null) {
            throw new RuntimeException("unable to decode class from code " + c);
        }
        return aClass;
    }

    public Class classForName(String clName) throws ClassNotFoundException {
        if (this.parent != null) {
            return this.parent.classForName(clName);
        }
        while (!this.classCacheLock.compareAndSet(false, true)) {
        }
        Class res = this.classCache.get(clName);
        if (res == null) {
            try {
                res = Class.forName(clName, false, this.conf.getClassLoader());
            }
            catch (Throwable th) {
                if (clName.endsWith("_Struct")) {
                    try {
                        clName = clName.substring(0, clName.length() - "_Struct".length());
                        Class<?> onHeapStructClz = this.classCache.get(clName);
                        if (onHeapStructClz == null) {
                            onHeapStructClz = Class.forName(clName);
                        }
                        res = FSTStructFactory.getInstance().getProxyClass(onHeapStructClz);
                    }
                    catch (Throwable th1) {
                        throw FSTUtil.rethrow(th1);
                    }
                }
                throw new RuntimeException("CLASSNAME:" + clName, th);
            }
            if (res != null) {
                this.classCache.put(clName, res);
            }
        }
        this.classCacheLock.set(false);
        return res;
    }

    public void registerClazzFromOtherLoader(Class cl) {
        while (!this.classCacheLock.compareAndSet(false, true)) {
        }
        this.classCache.put(cl.getName(), cl);
        this.classCacheLock.set(false);
    }

    public FSTClazzInfo getClazzFromId(int c) {
        FSTClazzInfo res = null;
        if (this.parent != null) {
            res = this.parent.getClazzFromId(c);
        }
        if (res == null) {
            return (FSTClazzInfo)this.idToClz.get(c);
        }
        return res;
    }
}

