/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization.serializers;

import de.ruedigermoeller.serialization.FSTBasicObjectSerializer;
import de.ruedigermoeller.serialization.FSTClazzInfo;
import de.ruedigermoeller.serialization.FSTObjectInput;
import de.ruedigermoeller.serialization.FSTObjectOutput;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class FSTCollectionSerializer
extends FSTBasicObjectSerializer {
    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        Collection col = (Collection)toWrite;
        int size = col.size();
        out.writeCInt(size);
        Class[] possibleClasses = referencedBy.getPossibleClasses();
        if (possibleClasses == null || possibleClasses.length == 0) {
            possibleClasses = new Class[]{null};
            if (col instanceof List) {
                List l = (List)col;
                for (int i = 0; i < size; ++i) {
                    Object o = l.get(i);
                    out.writeObjectInternal(o, possibleClasses);
                    if (o == null) continue;
                    possibleClasses[0] = o.getClass();
                }
            } else {
                for (Object o : col) {
                    out.writeObjectInternal(o, possibleClasses);
                    if (o == null) continue;
                    possibleClasses[0] = o.getClass();
                }
            }
        } else if (col instanceof List) {
            List l = (List)col;
            for (int i = 0; i < size; ++i) {
                Object o = l.get(i);
                out.writeObjectInternal(o, possibleClasses);
            }
        } else {
            for (Object o : col) {
                out.writeObjectInternal(o, possibleClasses);
            }
        }
    }

    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPositioin) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        try {
            Class[] possibleClasses;
            AbstractCollection res = null;
            int len = in.readCInt();
            res = objectClass == ArrayList.class ? new ArrayList(len) : (objectClass == HashSet.class ? new HashSet(len) : (objectClass == Vector.class ? new Vector(len) : (objectClass == LinkedList.class ? new LinkedList() : objectClass.newInstance())));
            in.registerObject(res, streamPositioin, serializationInfo, referencee);
            Collection col = res;
            if (col instanceof ArrayList) {
                ((ArrayList)col).ensureCapacity(len);
            }
            if ((possibleClasses = referencee.getPossibleClasses()) == null || possibleClasses.length == 0) {
                possibleClasses = new Class[]{null};
                for (int i = 0; i < len; ++i) {
                    Object obj = in.readObjectInternal(possibleClasses);
                    col.add(obj);
                    if (obj == null) continue;
                    possibleClasses[0] = obj.getClass();
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    Object o = in.readObjectInternal(possibleClasses);
                    col.add(o);
                }
            }
            return res;
        }
        catch (Throwable th) {
            th.printStackTrace();
            return null;
        }
    }
}

