/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.heapoff.structs;

import de.ruedigermoeller.heapoff.bytez.BytezAllocator;
import de.ruedigermoeller.heapoff.structs.FSTStruct;
import de.ruedigermoeller.heapoff.structs.FSTStructAllocator;
import de.ruedigermoeller.heapoff.structs.structtypes.StructArray;
import de.ruedigermoeller.heapoff.structs.structtypes.StructMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSTTypedStructAllocator<T extends FSTStruct>
extends FSTStructAllocator {
    T template;

    public FSTTypedStructAllocator(T ontpl) {
        this.template = this.getFactory().toStruct(ontpl);
        this.chunkSize = ((FSTStruct)this.template).getByteSize();
    }

    public FSTTypedStructAllocator(T ontpl, int objectsPerChunk) {
        this(ontpl);
        this.chunkSize = objectsPerChunk * ((FSTStruct)this.template).getByteSize();
    }

    public FSTTypedStructAllocator(T ontpl, int objectsPerChunk, BytezAllocator alloc) {
        this.alloc = alloc;
        this.template = this.getFactory().toStruct(ontpl);
        this.chunkSize = objectsPerChunk * ((FSTStruct)this.template).getByteSize();
    }

    public FSTTypedStructAllocator(int chunkSizeBytes, T template) {
        this(template);
        this.chunkSize = chunkSizeBytes;
    }

    public FSTTypedStructAllocator(int chunkSizeBytes, T template, BytezAllocator alloc) {
        super(chunkSizeBytes, alloc);
        this.template = this.getFactory().toStruct(template);
    }

    public StructArray<T> newArray(int size) {
        if (this.template == null) {
            throw new RuntimeException("need to specify a template in constructore in order to use this.");
        }
        return this.newArray(size, this.template, this.alloc);
    }

    public <K extends FSTStruct> StructMap<K, T> newMap(int size, K keyTemplate) {
        if (this.template == null) {
            throw new RuntimeException("need to specify a template in constructore in order to use this.");
        }
        return this.newStruct(new StructMap((FSTStruct)keyTemplate, (FSTStruct)this.template, size), this.alloc);
    }

    public T newStruct() {
        if (this.template == null) {
            throw new RuntimeException("need to specify a template in constructore in order to use this. Use newStruct(template) instead.");
        }
        return this.newStruct(this.template);
    }

    public int getTemplateSize() {
        return ((FSTStruct)this.template).getByteSize();
    }
}

