/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.heapoff.structs.unsafeimpl;

import de.ruedigermoeller.heapoff.structs.FSTArrayElementSizeCalculator;
import de.ruedigermoeller.heapoff.structs.FSTEmbeddedBinary;
import de.ruedigermoeller.heapoff.structs.FSTStruct;
import de.ruedigermoeller.heapoff.structs.NoAssist;
import de.ruedigermoeller.heapoff.structs.Templated;
import de.ruedigermoeller.heapoff.structs.structtypes.StructArray;
import de.ruedigermoeller.heapoff.structs.structtypes.StructMap;
import de.ruedigermoeller.heapoff.structs.structtypes.StructString;
import de.ruedigermoeller.heapoff.structs.unsafeimpl.FSTByteArrayUnsafeStructGeneration;
import de.ruedigermoeller.heapoff.structs.unsafeimpl.FSTStructGeneration;
import de.ruedigermoeller.serialization.FSTClazzInfo;
import de.ruedigermoeller.serialization.FSTConfiguration;
import de.ruedigermoeller.serialization.util.FSTInt2ObjectMap;
import de.ruedigermoeller.serialization.util.FSTUtil;
import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javassist.CannotCompileException;
import javassist.ClassMap;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Loader;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import sun.misc.Unsafe;

public class FSTStructFactory {
    public static int SIZE_ALIGN = 2;
    static FSTStructFactory instance;
    public static final int MAX_CLASSES = 1000;
    static Unsafe unsafe;
    static FSTConfiguration conf;
    static Loader proxyLoader;
    ConcurrentHashMap<Class, Class> proxyClzMap = new ConcurrentHashMap();
    FSTStructGeneration structGen = new FSTByteArrayUnsafeStructGeneration();
    boolean autoRegister = true;
    ThreadLocal<Object[]> cachedWrapperMap = new ThreadLocal<Object[]>(){

        @Override
        protected Object[] initialValue() {
            return new Object[1000];
        }
    };
    FSTInt2ObjectMap<Class> mIntToClz = new FSTInt2ObjectMap(97);
    HashMap<Class, Integer> mClzToInt = new HashMap();
    int idCount = 1;

    public static FSTStructFactory getInstance() {
        if (instance == null) {
            instance = new FSTStructFactory();
        }
        return instance;
    }

    public FSTStructFactory() {
        this.registerClz(FSTStruct.class);
        this.registerClz(StructString.class);
        this.registerClz(StructArray.class);
        this.registerClz(StructArray.StructArrIterator.class);
        this.registerClz(StructMap.class);
    }

    <T> Class<T> createStructClz(Class<T> clazz) throws Exception {
        if (Modifier.isFinal((int)clazz.getModifiers()) || Modifier.isAbstract((int)clazz.getModifiers())) {
            throw new RuntimeException("Cannot add final classes to structs");
        }
        String proxyName = clazz.getName() + "_Struct";
        Class present = null;
        try {
            present = proxyLoader.loadClass(proxyName);
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        if (present != null) {
            return present;
        }
        ClassPool pool = ClassPool.getDefault();
        CtClass newClz = pool.makeClass(proxyName);
        CtClass orig = pool.get(clazz.getName());
        newClz.setSuperclass(orig);
        final FSTClazzInfo clInfo = conf.getClassInfo(clazz);
        CtMethod[] methods = orig.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            CtMethod method = methods[i];
            Class<?> curClz = Class.forName(method.getDeclaringClass().getName());
            boolean allowed = (method.getModifiers() & 0x400) == 0 && (method.getModifiers() & 0x100) == 0 && (method.getModifiers() & 0x10) == 0 && !method.getDeclaringClass().getName().equals(FSTStruct.class.getName()) && !method.getDeclaringClass().getName().equals(Object.class.getName());
            allowed &= method.getAnnotation(NoAssist.class) == null;
            if ((allowed &= (method.getModifiers() & 8) == 0) && (method.getModifiers() & 0x10) != 0 && !method.getDeclaringClass().getName().equals("java.lang.Object")) {
                throw new RuntimeException("final methods are not allowed for struct classes:" + method.getName());
            }
            if (allowed && (method.getModifiers() & 2) != 0 && !method.getDeclaringClass().getName().equals("java.lang.Object")) {
                throw new RuntimeException("private methods are not allowed for struct classes:" + method.getName());
            }
            if (!allowed) continue;
            ClassMap mp = new ClassMap();
            mp.fix(clazz.getName());
            mp.fix(clazz.getSuperclass().getName());
            method = new CtMethod(method, newClz, mp);
            String methName = method.getName();
            FSTClazzInfo.FSTFieldInfo arrayFi = this.checkForSpecialArrayMethod(clInfo, method, "", null, null);
            FSTClazzInfo.FSTFieldInfo lenfi = this.checkForSpecialArrayMethod(clInfo, method, "Len", CtClass.intType, new CtClass[0]);
            FSTClazzInfo.FSTFieldInfo indexfi = this.checkForSpecialArrayMethod(clInfo, method, "Index", CtClass.intType, new CtClass[0]);
            FSTClazzInfo.FSTFieldInfo elemlen = this.checkForSpecialArrayMethod(clInfo, method, "ElementSize", CtClass.intType, new CtClass[0]);
            FSTClazzInfo.FSTFieldInfo pointerfi = this.checkForSpecialArrayMethod(clInfo, method, "Pointer", null, null);
            FSTClazzInfo.FSTFieldInfo structIndex = this.checkForSpecialMethod(clInfo, method, "StructIndex", CtClass.intType, new CtClass[0], false);
            FSTClazzInfo.FSTFieldInfo casAcc = this.checkForSpecialMethod(clInfo, method, "CAS", CtClass.booleanType, null, false);
            if (casAcc != null) {
                this.structGen.defineStructSetCAS(casAcc, clInfo, method);
                newClz.addMethod(method);
                continue;
            }
            if (pointerfi != null) {
                this.structGen.defineArrayPointer(pointerfi, clInfo, method);
                newClz.addMethod(method);
                continue;
            }
            if (structIndex != null) {
                this.structGen.defineFieldStructIndex(structIndex, clInfo, method);
                newClz.addMethod(method);
                continue;
            }
            if (indexfi != null) {
                this.structGen.defineArrayIndex(indexfi, clInfo, method);
                newClz.addMethod(method);
                continue;
            }
            if (elemlen != null) {
                this.structGen.defineArrayElementSize(elemlen, clInfo, method);
                newClz.addMethod(method);
                continue;
            }
            if (arrayFi != null) {
                this.structGen.defineArrayAccessor(arrayFi, clInfo, method);
                newClz.addMethod(method);
                continue;
            }
            if (methName.endsWith("Len") && lenfi != null) {
                this.structGen.defineArrayLength(lenfi, clInfo, method);
                newClz.addMethod(method);
                continue;
            }
            newClz.addMethod(method);
            method.instrument(new ExprEditor(){

                public void edit(FieldAccess f) throws CannotCompileException {
                    try {
                        if (!f.isStatic()) {
                            CtClass type = null;
                            type = f.getField().getType();
                            FSTClazzInfo.FSTFieldInfo fieldInfo = clInfo.getFieldInfo(f.getFieldName(), null);
                            if (fieldInfo == null) {
                                return;
                            }
                            if (f.isReader()) {
                                FSTStructFactory.this.structGen.defineStructReadAccess(f, type, fieldInfo);
                            } else if (f.isWriter()) {
                                FSTStructFactory.this.structGen.defineStructWriteAccess(f, type, fieldInfo);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return this.loadProxyClass(clazz, pool, newClz);
    }

    FSTClazzInfo.FSTFieldInfo checkForSpecialArrayMethod(FSTClazzInfo clzInfo, CtMethod method, String postFix, Object returnType, CtClass[] requiredArgs) {
        return this.checkForSpecialMethod(clzInfo, method, postFix, returnType, requiredArgs, true);
    }

    FSTClazzInfo.FSTFieldInfo checkForSpecialMethod(FSTClazzInfo clzInfo, CtMethod method, String postFix, Object returnType, CtClass[] requiredArgs, boolean array) {
        int len = postFix.length();
        String methName = method.getName();
        if (!methName.endsWith(postFix)) {
            return null;
        }
        FSTClazzInfo.FSTFieldInfo res = clzInfo.getFieldInfo(methName.substring(0, methName.length() - len), null);
        if (res == null) {
            return null;
        }
        if (array && res.isArray() && res.getArrayType().isArray()) {
            throw new RuntimeException("nested arrays not supported " + res.getDesc());
        }
        if (array && !res.isArray()) {
            return null;
        }
        if (res.isArray() || !array) {
            if (returnType instanceof Class) {
                try {
                    if (!method.getReturnType().getName().equals(((Class)returnType).getName())) {
                        throw new RuntimeException("expected method " + method + " to return " + returnType);
                    }
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                }
            } else if (returnType instanceof CtClass) {
                try {
                    if (!method.getReturnType().equals(returnType)) {
                        throw new RuntimeException("expected method " + method + " to return " + returnType);
                    }
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                }
            }
            return res;
        }
        return null;
    }

    private <T> Class loadProxyClass(Class<T> clazz, ClassPool pool, CtClass cc) throws ClassNotFoundException {
        proxyLoader.delegateLoadingOf(Unsafe.class.getName());
        proxyLoader.delegateLoadingOf(clazz.getName());
        proxyLoader.delegateLoadingOf(Externalizable.class.getName());
        proxyLoader.delegateLoadingOf(FSTUtil.class.getName());
        proxyLoader.delegateLoadingOf(Serializable.class.getName());
        proxyLoader.delegateLoadingOf(FSTStructFactory.class.getName());
        proxyLoader.delegateLoadingOf(FSTStruct.class.getName());
        Class ccClz = proxyLoader.loadClass(cc.getName());
        return ccClz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getProxyClass(Class clz) throws Exception {
        FSTStructFactory fSTStructFactory = this;
        synchronized (fSTStructFactory) {
            Class res = this.proxyClzMap.get(clz);
            if (res == null) {
                res = this.createStructClz(clz);
                this.proxyClzMap.put(clz, res);
            }
            return res;
        }
    }

    public <T extends FSTStruct> T createWrapper(Class<T> onHeap, byte[] bytes, int index) throws Exception {
        Class proxy = this.getProxyClass(onHeap);
        FSTStruct res = (FSTStruct)unsafe.allocateInstance(proxy);
        res.baseOn(bytes, FSTStruct.bufoff + (long)index, this);
        return (T)res;
    }

    public FSTStruct createStructWrapper(byte[] b, int index) {
        int clzId = unsafe.getInt(b, FSTStruct.bufoff + (long)index + 4L);
        return this.createStructPointer(b, index, clzId);
    }

    public FSTStruct createStructPointer(byte[] b, int index, int clzId) {
        FSTStructFactory fSTStructFactory = this;
        synchronized (fSTStructFactory) {
            Class clazz = this.mIntToClz.get(clzId);
            if (clazz == null) {
                throw new RuntimeException("unregistered class " + clzId);
            }
            try {
                return this.createWrapper(clazz, b, index);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public FSTStruct createTypedArrayBasePointer(byte[] base, long objectBaseOffset, int arrayStructIndex) {
        int arrayElementZeroindex = unsafe.getInt(base, objectBaseOffset + (long)arrayStructIndex);
        int elemSiz = unsafe.getInt(base, objectBaseOffset + (long)arrayStructIndex + 8L);
        int len = unsafe.getInt(base, objectBaseOffset + (long)arrayStructIndex + 4L);
        int clId = unsafe.getInt(base, objectBaseOffset + (long)arrayStructIndex + 12L);
        FSTStruct structPointer = null;
        if (clId <= 0) {
            structPointer = new FSTStruct();
            structPointer.baseOn(base, objectBaseOffset + (long)arrayElementZeroindex, this);
        } else {
            structPointer = this.createStructPointer(base, (int)(objectBaseOffset + (long)arrayElementZeroindex - FSTStruct.bufoff), clId);
        }
        structPointer.___elementSize = elemSiz;
        return structPointer;
    }

    public void fillTypedArrayBasePointer(FSTStruct result, byte[] base, long objectBaseOffset, int arrayStructIndex) {
        int arrayElementZeroindex = unsafe.getInt(base, objectBaseOffset + (long)arrayStructIndex);
        int elemSiz = unsafe.getInt(base, objectBaseOffset + (long)arrayStructIndex + 8L);
        result.baseOn(base, objectBaseOffset + (long)arrayElementZeroindex, this);
        result.___elementSize = elemSiz;
    }

    public void fillPrimitiveArrayBasePointer(FSTStruct result, byte[] base, long objectBaseOffset, int arrayStructIndex) {
        int arrayElementZeroindex = unsafe.getInt(base, objectBaseOffset + (long)arrayStructIndex);
        result.baseOn(base, objectBaseOffset + (long)arrayElementZeroindex, this);
    }

    public FSTStruct createPrimitiveArrayBasePointer(byte[] base, long objectBaseOffset, int arrayStructIndex) {
        int arrayElementZeroindex = unsafe.getInt(base, objectBaseOffset + (long)arrayStructIndex);
        FSTStruct structPointer = new FSTStruct();
        structPointer.baseOn(base, objectBaseOffset + (long)arrayElementZeroindex, this);
        return structPointer;
    }

    public <T extends FSTStruct> StructArray<T> toStructArray(int size, T onHeap) {
        StructArray<T> arr = new StructArray<T>(size, onHeap);
        return this.toStruct(arr);
    }

    public <T extends FSTStruct> T toStruct(T onHeap) {
        if (onHeap.isOffHeap()) {
            return onHeap;
        }
        try {
            byte[] b = this.toByteArray(onHeap);
            return (T)this.createWrapper(onHeap.getClass(), b, 0);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public void detach(FSTStruct structPointer) {
        int id = structPointer.getClzId();
        Object o = this.cachedWrapperMap.get()[id];
        if (o == structPointer) {
            this.cachedWrapperMap.get()[id] = null;
        }
    }

    public FSTStruct getStructPointerByOffset(byte[] b, long offset) {
        if (offset < FSTStruct.bufoff) {
            return null;
        }
        int clzId = unsafe.getInt(b, offset + 4L);
        int ptr = unsafe.getInt(b, offset);
        if (clzId <= 0) {
            return null;
        }
        Object[] wrapperMap = this.cachedWrapperMap.get();
        Object res = wrapperMap[clzId];
        if (res != null) {
            ((FSTStruct)res).baseOn(b, offset, this);
            return (FSTStruct)res;
        }
        wrapperMap[clzId] = res = this.createStructPointer(b, (int)(offset - FSTStruct.bufoff), clzId);
        return (FSTStruct)res;
    }

    public FSTStruct getStructPointer(byte[] b, int index) {
        return this.getStructPointerByOffset(b, FSTStruct.bufoff + (long)index);
    }

    public static int align(int val, int align) {
        while (val % align != 0) {
            ++val;
        }
        return val;
    }

    public int calcStructSize(FSTStruct onHeapStruct) {
        try {
            if (onHeapStruct == null) {
                return 0;
            }
            if (onHeapStruct.isOffHeap()) {
                return onHeapStruct.getByteSize();
            }
            int siz = 8;
            FSTClazzInfo clInfo = conf.getClassInfo(onHeapStruct.getClass());
            FSTClazzInfo.FSTFieldInfo[] fis = clInfo.getFieldInfo();
            for (int i = 0; i < fis.length; ++i) {
                FSTClazzInfo.FSTFieldInfo fi = fis[i];
                if (fi.getField().getDeclaringClass() == FSTStruct.class) continue;
                int modifiers = fi.getField().getModifiers();
                if (!Modifier.isProtected((int)modifiers) && !Modifier.isPublic((int)modifiers)) {
                    throw new RuntimeException("all fields of a structable class must be public or protected. Field:" + fi.getField().getName() + " in class " + fi.getField().getDeclaringClass().getName());
                }
                if (fi.getType().isArray()) {
                    Object[] objectValue;
                    if (fi.getType().getComponentType().isArray()) {
                        throw new RuntimeException("nested arrays not supported");
                    }
                    if (fi.isIntegral()) {
                        objectValue = fi.getObjectValue(onHeapStruct);
                        if (objectValue == null) {
                            throw new RuntimeException("arrays in struct templates must not be null !");
                        }
                        siz += Array.getLength(objectValue) * fi.getComponentStructSize() + fi.getStructSize() + fi.getAlignPad() + (fi.getAlign() > 0 ? fi.getAlign() - 1 : 0);
                        continue;
                    }
                    objectValue = (Object[])fi.getObjectValue(onHeapStruct);
                    if (objectValue == null) {
                        siz += fi.getStructSize() + fi.getAlignPad() + (fi.getAlign() > 0 ? fi.getAlign() - 1 : 0);
                        continue;
                    }
                    int elemSiz = this.computeElemSize(onHeapStruct, objectValue, fi);
                    siz += Array.getLength(objectValue) * elemSiz + fi.getStructSize() + fi.getAlignPad() + (fi.getAlign() > 0 ? fi.getAlign() - 1 : 0);
                    continue;
                }
                if (fi.isIntegral()) {
                    siz += fi.getStructSize();
                    continue;
                }
                FSTStruct obj = (FSTStruct)fi.getObjectValue(onHeapStruct);
                siz += fi.getStructSize() + this.calcStructSize(obj) + fi.getAlignPad();
            }
            if (onHeapStruct instanceof FSTEmbeddedBinary) {
                siz += ((FSTEmbeddedBinary)((Object)onHeapStruct)).getEmbeddedSizeAdditon(this);
            }
            return siz;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected int computeElemSize(Object container, Object[] objectValue, FSTClazzInfo.FSTFieldInfo fi) {
        int res;
        if (container instanceof FSTArrayElementSizeCalculator && (res = ((FSTArrayElementSizeCalculator)container).getElementSize(fi.getField(), this)) >= 0) {
            return res;
        }
        Templated annotation = fi.getField().getAnnotation(Templated.class);
        if (annotation != null) {
            Object template = objectValue[0];
            return FSTStructFactory.align(this.calcStructSize((FSTStruct)template), SIZE_ALIGN);
        }
        int elemSiz = 0;
        for (int j = 0; j < objectValue.length; ++j) {
            Object o = objectValue[j];
            if (o == null) continue;
            elemSiz = Math.max(elemSiz, this.calcStructSize((FSTStruct)o));
        }
        return FSTStructFactory.align(elemSiz, SIZE_ALIGN);
    }

    public void registerClz(Class ... classes) {
        for (int i = 0; i < classes.length; ++i) {
            int id;
            Class c = classes[i];
            if (this.mClzToInt.containsKey(c)) continue;
            ++this.idCount;
            this.mIntToClz.put(id, c);
            this.mClzToInt.put(c, id);
        }
    }

    public void registerSystemClz(byte startVal, Class ... classes) {
        for (int i = 0; i < classes.length; ++i) {
            Class c = classes[i];
            if (this.mClzToInt.containsKey(c)) continue;
            byte by = startVal;
            startVal = (byte)(startVal - 1);
            byte id = by;
            this.mIntToClz.put(id, c);
            this.mClzToInt.put(c, Integer.valueOf(id));
        }
    }

    public int getClzId(Class c) {
        Integer integer = this.mClzToInt.get(c);
        if (this.autoRegister && integer == null && c != null) {
            if (c.getName().endsWith("_Struct")) {
                return this.getClzId(c.getSuperclass());
            }
            this.registerClz(c);
            return this.getClzId(c);
        }
        return integer == null ? 0 : integer;
    }

    public Class getClazz(int clzId) {
        return this.mIntToClz.get(clzId);
    }

    public byte[] toByteArray(FSTStruct onHeapStruct) {
        try {
            int sz = FSTStructFactory.align(this.calcStructSize(onHeapStruct), SIZE_ALIGN);
            byte[] b = new byte[sz];
            this.toByteArray(onHeapStruct, b, 0);
            return b;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public int toByteArray(FSTStruct onHeapStruct, byte[] bytes, int index) throws Exception {
        int i;
        ArrayList<ForwardEntry> positions = new ArrayList<ForwardEntry>();
        if (onHeapStruct == null) {
            return index;
        }
        if (onHeapStruct.isOffHeap()) {
            unsafe.copyMemory(onHeapStruct.___bytes, onHeapStruct.___offset, bytes, FSTStruct.bufoff + (long)index, onHeapStruct.getByteSize());
            return onHeapStruct.getByteSize();
        }
        int initialIndex = index;
        Class<?> aClass = onHeapStruct.getClass();
        int clzId = this.getClzId(aClass);
        unsafe.putInt(bytes, FSTStruct.bufoff + (long)index + 4L, clzId);
        index += 8;
        FSTClazzInfo clInfo = conf.getClassInfo(aClass);
        FSTClazzInfo.FSTFieldInfo[] fis = clInfo.getFieldInfo();
        for (i = 0; i < fis.length; ++i) {
            FSTClazzInfo.FSTFieldInfo fi = fis[i];
            if (fi.getField().getDeclaringClass() == FSTStruct.class) continue;
            index += fi.getAlignPad();
            if (fi.getType().isArray()) {
                if (fi.getType().getComponentType().isArray()) {
                    throw new RuntimeException("nested arrays not supported");
                }
                if (fi.isIntegral()) {
                    Object objectValue = fi.getObjectValue(onHeapStruct);
                    positions.add(new ForwardEntry(index, objectValue, fi));
                    index += fi.getStructSize();
                    continue;
                }
                Object[] objArr = (Object[])fi.getObjectValue(onHeapStruct);
                if (objArr == null) {
                    unsafe.putInt(bytes, FSTStruct.bufoff + (long)index, -1);
                    index += fi.getStructSize();
                    continue;
                }
                Templated takeFirst = fi.getField().getAnnotation(Templated.class);
                ForwardEntry fe = new ForwardEntry(index, objArr, fi);
                if (takeFirst != null) {
                    fe.template = (FSTStruct)objArr[0];
                }
                positions.add(fe);
                int elemSiz = this.computeElemSize(onHeapStruct, objArr, fi);
                unsafe.putInt(bytes, FSTStruct.bufoff + (long)(index += fi.getStructSize()) - 8L, elemSiz);
                continue;
            }
            if (fi.isIntegral()) {
                Class type = fi.getType();
                int structIndex = fi.getStructOffset();
                if (index != structIndex + initialIndex) {
                    throw new RuntimeException("internal error. please file an issue");
                }
                if (type == Boolean.TYPE) {
                    unsafe.putByte(bytes, FSTStruct.bufoff + (long)index, (byte)(fi.getBooleanValue(onHeapStruct) ? 1 : 0));
                } else if (type == Byte.TYPE) {
                    unsafe.putByte(bytes, FSTStruct.bufoff + (long)index, (byte)fi.getByteValue(onHeapStruct));
                } else if (type == Character.TYPE) {
                    unsafe.putChar(bytes, FSTStruct.bufoff + (long)index, (char)fi.getCharValue(onHeapStruct));
                } else if (type == Short.TYPE) {
                    unsafe.putShort(bytes, FSTStruct.bufoff + (long)index, (short)fi.getShortValue(onHeapStruct));
                } else if (type == Integer.TYPE) {
                    unsafe.putInt(bytes, FSTStruct.bufoff + (long)index, fi.getIntValue(onHeapStruct));
                } else if (type == Long.TYPE) {
                    unsafe.putLong(bytes, FSTStruct.bufoff + (long)index, fi.getLongValue(onHeapStruct));
                } else if (type == Float.TYPE) {
                    unsafe.putFloat(bytes, FSTStruct.bufoff + (long)index, fi.getFloatValue(onHeapStruct));
                } else if (type == Double.TYPE) {
                    unsafe.putDouble(bytes, FSTStruct.bufoff + (long)index, fi.getDoubleValue(onHeapStruct));
                } else {
                    throw new RuntimeException("this is an error");
                }
                index += fi.getStructSize();
                continue;
            }
            Object obj = fi.getObjectValue(onHeapStruct);
            int structIndex = fi.getStructOffset();
            if (index != structIndex + initialIndex) {
                throw new RuntimeException("internal error. please file an issue");
            }
            if (obj == null) {
                unsafe.putInt(bytes, FSTStruct.bufoff + (long)index, -1);
                unsafe.putInt(bytes, FSTStruct.bufoff + (long)index + 4L, -1);
                index += fi.getStructSize();
                continue;
            }
            Object objectValue = fi.getObjectValue(onHeapStruct);
            positions.add(new ForwardEntry(index, objectValue, fi));
            index += fi.getStructSize();
        }
        for (i = 0; i < positions.size(); ++i) {
            ForwardEntry en = (ForwardEntry)positions.get(i);
            Object o = en.forwardObject;
            if (o == null) {
                throw new RuntimeException("this is a bug");
            }
            Class<?> c = o.getClass();
            if (c.isArray()) {
                if (en.fi.getAlign() > 0) {
                    while (index % en.fi.getAlign() != 0) {
                        ++index;
                    }
                }
                long siz = 0L;
                if (c == byte[].class) {
                    siz = Array.getLength(o);
                    unsafe.copyMemory(o, FSTStruct.bufoff, bytes, FSTStruct.bufoff + (long)index, siz);
                } else if (c == boolean[].class) {
                    siz = Array.getLength(o);
                    unsafe.copyMemory(o, FSTStruct.bufoff, bytes, FSTStruct.bufoff + (long)index, siz);
                } else if (c == char[].class) {
                    siz = (long)Array.getLength(o) * FSTUtil.chscal;
                    unsafe.copyMemory(o, FSTUtil.choff, bytes, FSTStruct.bufoff + (long)index, siz);
                } else if (c == short[].class) {
                    siz = (long)Array.getLength(o) * FSTUtil.chscal;
                    unsafe.copyMemory(o, FSTUtil.choff, bytes, FSTStruct.bufoff + (long)index, siz);
                } else if (c == int[].class) {
                    siz = (long)Array.getLength(o) * FSTUtil.intscal;
                    unsafe.copyMemory(o, FSTUtil.intoff, bytes, FSTStruct.bufoff + (long)index, siz);
                } else if (c == long[].class) {
                    siz = (long)Array.getLength(o) * FSTUtil.longscal;
                    unsafe.copyMemory(o, FSTUtil.longoff, bytes, FSTStruct.bufoff + (long)index, siz);
                } else if (c == float[].class) {
                    siz = (long)Array.getLength(o) * FSTUtil.floatscal;
                    unsafe.copyMemory(o, FSTUtil.floatoff, bytes, FSTStruct.bufoff + (long)index, siz);
                } else if (c == double[].class) {
                    siz = (long)Array.getLength(o) * FSTUtil.doublescal;
                    unsafe.copyMemory(o, FSTUtil.doubleoff, bytes, FSTStruct.bufoff + (long)index, siz);
                } else {
                    Class<? extends FSTStruct> elemClz;
                    Object[] objArr = (Object[])o;
                    int elemSiz = unsafe.getInt(bytes, FSTStruct.bufoff + (long)en.pointerPos + 8L);
                    siz = Array.getLength(o) * elemSiz;
                    int tmpIndex = index;
                    byte[] templatearr = null;
                    boolean hasClzId = false;
                    if (onHeapStruct instanceof FSTArrayElementSizeCalculator && (elemClz = ((FSTArrayElementSizeCalculator)((Object)onHeapStruct)).getElementType(en.fi.getField(), this)) != null) {
                        int clid = this.getClzId(elemClz);
                        unsafe.putInt(bytes, FSTStruct.bufoff + (long)en.pointerPos + 12L, clid);
                        hasClzId = true;
                    }
                    if (en.template != null) {
                        templatearr = this.toByteArray(en.template);
                        if (!hasClzId) {
                            unsafe.putInt(bytes, FSTStruct.bufoff + (long)en.pointerPos + 12L, this.getClzId(en.template.getClass()));
                            hasClzId = true;
                        }
                    }
                    for (int j = 0; j < objArr.length; ++j) {
                        Object objectValue = objArr[j];
                        if (templatearr != null) {
                            unsafe.copyMemory(templatearr, FSTStruct.bufoff, bytes, FSTStruct.bufoff + (long)tmpIndex, templatearr.length);
                            tmpIndex += elemSiz;
                            continue;
                        }
                        if (objectValue == null) {
                            unsafe.putInt(bytes, FSTStruct.bufoff + (long)tmpIndex + 4L, -1);
                            tmpIndex += elemSiz;
                            continue;
                        }
                        this.toByteArray((FSTStruct)objectValue, bytes, tmpIndex);
                        unsafe.putInt(bytes, FSTStruct.bufoff + (long)tmpIndex, elemSiz);
                        tmpIndex += elemSiz;
                        if (hasClzId) continue;
                        unsafe.putInt(bytes, FSTStruct.bufoff + (long)en.pointerPos + 12L, this.getClzId(en.fi.getArrayType()));
                        hasClzId = true;
                    }
                }
                unsafe.putInt(bytes, FSTStruct.bufoff + (long)en.pointerPos, index - initialIndex);
                unsafe.putInt(bytes, FSTStruct.bufoff + (long)en.pointerPos + 4L, Array.getLength(o));
                index = (int)((long)index + siz);
                continue;
            }
            int newoffset = this.toByteArray((FSTStruct)o, bytes, index);
            unsafe.putInt(bytes, FSTStruct.bufoff + (long)en.pointerPos, index - initialIndex);
            index = newoffset;
        }
        if (onHeapStruct instanceof FSTEmbeddedBinary) {
            FSTEmbeddedBinary embeddedBinary = (FSTEmbeddedBinary)((Object)onHeapStruct);
            index = embeddedBinary.insertEmbedded(this, bytes, index);
        }
        unsafe.putInt(bytes, FSTStruct.bufoff + (long)initialIndex, index - initialIndex);
        return index;
    }

    public int getShallowStructSize(Class clz) {
        return conf.getClassInfo(clz).getStructSize();
    }

    static {
        unsafe = FSTUtil.unFlaggedUnsafe;
        conf = FSTConfiguration.createStructConfiguration();
        proxyLoader = new Loader(FSTStructFactory.class.getClassLoader(), ClassPool.getDefault());
    }

    static class ForwardEntry {
        FSTClazzInfo.FSTFieldInfo fi;
        int pointerPos;
        Object forwardObject;
        FSTStruct template;

        ForwardEntry(int pointerPos, Object forwardObject, FSTClazzInfo.FSTFieldInfo fsfi) {
            this.pointerPos = pointerPos;
            this.forwardObject = forwardObject;
            this.fi = fsfi;
        }
    }
}

