/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.heapoff.structs;

import de.ruedigermoeller.heapoff.structs.unsafeimpl.FSTStructFactory;
import de.ruedigermoeller.serialization.util.FSTUtil;
import java.io.Serializable;
import sun.misc.Unsafe;

public class FSTStruct
implements Serializable {
    public static Unsafe unsafe = FSTUtil.getUnsafe();
    public static long bufoff = FSTUtil.bufoff;
    public transient long ___offset;
    public transient byte[] ___bytes;
    public transient FSTStructFactory ___fac;
    public transient int ___elementSize;

    protected Unsafe getUnsafe() {
        return unsafe;
    }

    protected void setAbsoluteOffset(long off) {
        this.___offset = off;
    }

    protected long getAbsoluteOffset() {
        return this.___offset;
    }

    public int getOffset() {
        return (int)(this.___offset - bufoff);
    }

    public int getIndexInBase() {
        return (int)(this.___offset - bufoff);
    }

    public int getByteSize() {
        if (!this.isOffHeap()) {
            return 0;
        }
        return unsafe.getInt(this.___bytes, this.___offset);
    }

    public Class getPointedClass() {
        if (!this.isOffHeap()) {
            throw new RuntimeException("cannot call on heap");
        }
        Class clazz = this.___fac.getClazz(this.getClzId());
        if (clazz == null) {
            return FSTStruct.class;
        }
        return clazz;
    }

    public int getClzId() {
        if (!this.isOffHeap()) {
            throw new RuntimeException("cannot call on heap");
        }
        return unsafe.getInt(this.___bytes, this.___offset + 4L);
    }

    public boolean pointsToNull() {
        return this.getClzId() <= 0;
    }

    protected void addOffset(long off) {
        this.___offset += off;
    }

    protected void setBase(byte[] base) {
        this.___bytes = base;
    }

    public byte[] getBase() {
        return this.___bytes;
    }

    public FSTStructFactory getFac() {
        return this.___fac;
    }

    public void baseOn(byte[] base, long offset, FSTStructFactory fac) {
        this.___bytes = base;
        this.___offset = offset;
        this.___fac = fac;
    }

    public void baseOn(byte[] base, int index) {
        this.___bytes = base;
        this.___offset = bufoff + (long)index;
        if (this.___fac == null) {
            this.___fac = FSTStructFactory.getInstance();
        }
    }

    public boolean isIdenticTo(FSTStruct other) {
        return other.getBase() == this.___bytes && other.getAbsoluteOffset() == this.___offset;
    }

    public boolean isOffHeap() {
        return this.___fac != null;
    }

    public int getElementInArraySize() {
        return this.___elementSize;
    }

    public boolean isStructArrayPointer() {
        return this.___elementSize > 0;
    }

    public boolean isNull() {
        return this.getClzId() <= 0;
    }

    public FSTStruct detach() {
        if (this.isOffHeap()) {
            this.___fac.detach(this);
        }
        return this;
    }

    public final void next() {
        if (this.___elementSize > 0) {
            this.___offset += (long)this.___elementSize;
        } else {
            throw new RuntimeException("not pointing to a struct array");
        }
    }

    public final void next(int offset) {
        this.___offset += (long)offset;
    }

    public final void previous() {
        if (this.___elementSize > 0) {
            this.___offset -= (long)this.___elementSize;
        } else {
            throw new RuntimeException("not pointing to a struct array");
        }
    }

    public <T extends FSTStruct> T cast(Class<T> to) {
        int clzId = this.___fac.getClzId(to);
        if (this.getClass().getSuperclass() == to) {
            return (T)this;
        }
        FSTStruct res = this.___fac.createStructPointer(this.___bytes, (int)(this.___offset - bufoff), clzId);
        res.___elementSize = this.___elementSize;
        return (T)res;
    }

    public FSTStruct cast() {
        int clzId = this.getClzId();
        if (this.___fac.getClazz(clzId) == this.getClass().getSuperclass()) {
            return this;
        }
        FSTStruct res = this.___fac.getStructPointerByOffset(this.___bytes, this.___offset);
        res.___elementSize = this.___elementSize;
        return res;
    }

    public byte getByte() {
        return unsafe.getByte(this.___bytes, this.___offset);
    }

    public void setByte(byte i) {
        unsafe.putByte(this.___bytes, this.___offset, i);
    }

    public char getChar() {
        return unsafe.getChar(this.___bytes, this.___offset);
    }

    public short getShort() {
        return unsafe.getShort(this.___bytes, this.___offset);
    }

    public void setShort(short i) {
        unsafe.putShort(this.___bytes, this.___offset, i);
    }

    public int getInt() {
        return unsafe.getInt(this.___bytes, this.___offset);
    }

    public void setInt(int i) {
        unsafe.putInt(this.___bytes, this.___offset, i);
    }

    public long getLong() {
        return unsafe.getLong(this.___bytes, this.___offset);
    }

    public void setLong(long i) {
        unsafe.putLong(this.___bytes, this.___offset, i);
    }

    public float getFloat() {
        return unsafe.getFloat(this.___bytes, this.___offset);
    }

    public double getDouble() {
        return unsafe.getDouble(this.___bytes, this.___offset);
    }

    public void getBytes(byte[] target, int startIndex) {
        if (!this.isOffHeap()) {
            throw new RuntimeException("must be offheap to call this");
        }
        if (target.length + startIndex > this.getByteSize()) {
            throw new RuntimeException("ArrayIndexOutofBounds byte len:" + target.length + " start+size:" + (startIndex + this.getByteSize()));
        }
        unsafe.copyMemory(this.___bytes, this.___offset, target, bufoff, target.length);
    }

    public void setBytes(byte[] source, int sourceIndex, int len) {
        if (!this.isOffHeap()) {
            throw new RuntimeException("must be offheap to call this");
        }
        unsafe.copyMemory(source, bufoff + (long)sourceIndex, this.___bytes, this.___offset, len);
    }

    public FSTStruct createCopy() {
        if (!this.isOffHeap()) {
            throw new RuntimeException("must be offheap to call this");
        }
        byte[] b = new byte[this.getByteSize()];
        this.getBytes(b, 0);
        return this.___fac.createStructWrapper(b, 0);
    }
}

