/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.heapoff.structs.structtypes;

import de.ruedigermoeller.heapoff.structs.FSTArrayElementSizeCalculator;
import de.ruedigermoeller.heapoff.structs.FSTStruct;
import de.ruedigermoeller.heapoff.structs.NoAssist;
import de.ruedigermoeller.heapoff.structs.unsafeimpl.FSTStructFactory;
import java.lang.reflect.Field;
import java.util.Map;

public class StructMap<K extends FSTStruct, V extends FSTStruct>
extends FSTStruct
implements FSTArrayElementSizeCalculator {
    transient FSTStruct keyTemplate;
    transient FSTStruct valueTemplate;
    protected transient FSTStruct pointer;
    protected FSTStruct[] keys;
    protected FSTStruct[] vals;
    protected int size;

    public StructMap(FSTStruct keyTemplate, FSTStruct valueTemplate, int numElems) {
        this.init(keyTemplate, valueTemplate, numElems);
    }

    @NoAssist
    protected void init(FSTStruct keyTemplate, FSTStruct valueTemplate, int numElems) {
        numElems = Math.max(3, numElems);
        this.keys = new FSTStruct[numElems * 2];
        this.vals = new FSTStruct[numElems * 2];
        this.keyTemplate = keyTemplate;
        this.valueTemplate = valueTemplate;
    }

    public StructMap(FSTStruct keyTemplate, FSTStruct valueTemplate, Map<K, V> elems) {
        this(keyTemplate, valueTemplate, elems.size());
        for (Map.Entry<K, V> next : elems.entrySet()) {
            this.put((FSTStruct)next.getKey(), (FSTStruct)next.getValue());
        }
    }

    protected int keysStructIndex() {
        return -1;
    }

    protected int valsStructIndex() {
        return -1;
    }

    protected int locateIndex(Object key) {
        if (this.size >= this.getCapacity() - 1) {
            throw new RuntimeException("Map is full");
        }
        if (this.pointer != null || this.isOffHeap()) {
            long arrbase = this.___offset + (long)this.keysStructIndex();
            int kvlen = unsafe.getInt(this.___bytes, arrbase + 4L);
            int kelemsiz = unsafe.getInt(this.___bytes, arrbase + 8L);
            if (this.pointer == null) {
                this.pointer = this.___fac.createStructPointer(this.___bytes, 0, unsafe.getInt(this.___bytes, arrbase + 12L));
            }
            int pos = (key.hashCode() & Integer.MAX_VALUE) % kvlen;
            this.pointer.___offset = this.___offset + (long)unsafe.getInt(this.___bytes, arrbase) + (long)(pos * kelemsiz);
            while (this.pointer.getInt() > 0 && !key.equals(this.pointer)) {
                this.pointer.next(kelemsiz);
                if (++pos < kvlen) continue;
                pos = 0;
                this.pointer.___offset = this.___offset + (long)unsafe.getInt(this.___bytes, arrbase);
            }
            return pos;
        }
        int kvlen = this.keysLen();
        int pos = (key.hashCode() & Integer.MAX_VALUE) % kvlen;
        Object o = this.keys(pos);
        while (o != null && !key.equals(o)) {
            if (++pos >= kvlen) {
                pos = 0;
            }
            o = this.keys(pos);
        }
        return pos;
    }

    public int size() {
        return this.size;
    }

    public V get(Object key) {
        int pos = this.locateIndex(key);
        Object res = this.keys(pos) != null ? this.vals(pos) : null;
        return (V)((FSTStruct)res);
    }

    public V put(K key, V value) {
        if (key == null) {
            throw new RuntimeException("Illegal Argument key is null");
        }
        if (value == null) {
            throw new RuntimeException("Illegal Argument value is null");
        }
        Object tmp = null;
        if (key != null) {
            int pos = this.locateIndex(key);
            if (this.keys(pos) == null) {
                ++this.size;
            }
            tmp = this.vals(pos);
            this.setKeyValue(pos, key, value);
        }
        return (V)((FSTStruct)tmp);
    }

    protected void setKeyValue(int i, K key, V value) {
        this.keys(i, (FSTStruct)key);
        this.vals(i, (FSTStruct)value);
    }

    public int getCapacity() {
        return this.keysLen();
    }

    public Object keys(int i) {
        return this.keys[i];
    }

    public Object vals(int i) {
        return this.vals[i];
    }

    public void keys(int i, FSTStruct v) {
        this.keys[i] = v;
    }

    public void vals(int i, FSTStruct v) {
        this.vals[i] = v;
    }

    public int keysLen() {
        return this.keys.length;
    }

    public int valsLen() {
        return this.vals.length;
    }

    @Override
    public int getElementSize(Field arrayRef, FSTStructFactory fac) {
        if (this.keyTemplate != null && "keys".equals(arrayRef.getName())) {
            return FSTStructFactory.align(fac.calcStructSize(this.keyTemplate), FSTStructFactory.SIZE_ALIGN);
        }
        if (this.valueTemplate != null && "vals".equals(arrayRef.getName())) {
            return FSTStructFactory.align(fac.calcStructSize(this.valueTemplate), FSTStructFactory.SIZE_ALIGN);
        }
        return -1;
    }

    @Override
    public Class<? extends FSTStruct> getElementType(Field arrayRef, FSTStructFactory fac) {
        if (this.keyTemplate != null && "keys".equals(arrayRef.getName())) {
            return this.keyTemplate.getClass();
        }
        if (this.valueTemplate != null && "vals".equals(arrayRef.getName())) {
            return this.valueTemplate.getClass();
        }
        return null;
    }
}

