/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.heapoff.structs;

import de.ruedigermoeller.heapoff.structs.FSTStruct;
import de.ruedigermoeller.heapoff.structs.structtypes.StructArray;
import de.ruedigermoeller.heapoff.structs.structtypes.StructMap;
import de.ruedigermoeller.heapoff.structs.unsafeimpl.FSTStructFactory;

public class FSTStructAllocator {
    protected int chunkSize;
    protected byte[] chunk;
    protected int chunkIndex;

    protected FSTStructAllocator() {
    }

    public static FSTStruct createStructPointer(byte[] b, int index) {
        return FSTStructFactory.getInstance().getStructPointerByOffset(b, FSTStruct.bufoff + (long)index).detach();
    }

    public static <T extends FSTStruct> T toStruct(T onHeapTemplate) {
        return FSTStructFactory.getInstance().toStruct(onHeapTemplate);
    }

    public static FSTStruct getVolatileStructPointer(byte[] b, int index) {
        return FSTStructFactory.getInstance().getStructPointerByOffset(b, FSTStruct.bufoff + (long)index);
    }

    public static <C extends FSTStruct> C newPointer(Class<C> clazz) {
        try {
            return (C)((FSTStruct)FSTStructFactory.getInstance().getProxyClass(clazz).newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public FSTStructAllocator(int chunkSizeBytes) {
        this.chunkSize = chunkSizeBytes;
    }

    public <X extends FSTStruct> StructArray<X> newArray(int size, X templ) {
        StructArray<X> aTemplate = new StructArray<X>(size, templ);
        int siz = this.getFactory().calcStructSize(aTemplate);
        try {
            if (siz < this.chunkSize) {
                return this.newStruct(aTemplate);
            }
            return this.getFactory().toStruct(aTemplate);
        }
        catch (Throwable e) {
            System.out.println("tried to allocate " + siz + " bytes. StructArray of " + size + " " + templ.getClass().getName());
            throw new RuntimeException(e);
        }
    }

    public <K extends FSTStruct, V extends FSTStruct> StructMap<K, V> newMap(int size, K keyTemplate, V valueTemplate) {
        return this.newStruct(new StructMap(keyTemplate, valueTemplate, size));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends FSTStruct> S newStruct(S aTemplate) {
        aTemplate = this.getFactory().toStruct(aTemplate);
        if (aTemplate.getByteSize() >= this.chunkSize) {
            return (S)aTemplate.createCopy();
        }
        int byteSize = aTemplate.getByteSize();
        FSTStructAllocator fSTStructAllocator = this;
        synchronized (fSTStructAllocator) {
            if (this.chunk == null || this.chunkIndex + byteSize > this.chunk.length) {
                this.chunk = new byte[this.chunkSize];
                this.chunkIndex = 0;
            }
            FSTStruct.unsafe.copyMemory(aTemplate.___bytes, aTemplate.___offset, this.chunk, FSTStruct.bufoff + (long)this.chunkIndex, byteSize);
            FSTStruct res = this.getFactory().createStructWrapper(this.chunk, this.chunkIndex);
            this.chunkIndex += byteSize;
            return (S)res;
        }
    }

    protected FSTStructFactory getFactory() {
        return FSTStructFactory.getInstance();
    }
}

