/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.util;

import java.io.ByteArrayInputStream;

public class MyBAInput
extends ByteArrayInputStream {
    public MyBAInput(byte[] buf) {
        super(buf);
    }

    public MyBAInput(byte[] buf, int offset, int length) {
        super(buf, offset, length);
    }

    public byte[] getBuf() {
        return this.buf;
    }

    public void setBuf(byte[] b) {
        this.buf = b;
        this.pos = 0;
        this.mark = 0;
        this.count = b.length;
    }

    public void setBuf(byte[] b, int start) {
        this.buf = b;
        this.pos = start;
        this.mark = 0;
        this.count = b.length;
    }

    public void setPos(int p) {
        this.pos = p;
    }

    @Override
    public int read() {
        return this.buf[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    public final short readShort() {
        int ch1 = this.buf[this.pos++] + 256 & 0xFF;
        int ch2 = this.buf[this.pos++] + 256 & 0xFF;
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public final int readInt() {
        int ch1 = this.buf[this.pos++] + 256 & 0xFF;
        int ch2 = this.buf[this.pos++] + 256 & 0xFF;
        int ch3 = this.buf[this.pos++] + 256 & 0xFF;
        int ch4 = this.buf[this.pos++] + 256 & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public final long readLong() {
        return ((long)this.buf[this.pos++] << 56) + ((long)(this.buf[this.pos++] & 0xFF) << 48) + ((long)(this.buf[this.pos++] & 0xFF) << 40) + ((long)(this.buf[this.pos++] & 0xFF) << 32) + ((long)(this.buf[this.pos++] & 0xFF) << 24) + (long)((this.buf[this.pos++] & 0xFF) << 16) + (long)((this.buf[this.pos++] & 0xFF) << 8) + (long)((this.buf[this.pos++] & 0xFF) << 0);
    }
}

