/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.transport;

import de.ruedigermoeller.fastcast.transport.FCSocketConf;
import de.ruedigermoeller.fastcast.transport.Transport;
import de.ruedigermoeller.fastcast.util.FCLog;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;

public class FCMulticastSocketTransport
implements Transport {
    FCSocketConf conf;
    MulticastSocket socket;
    NetworkInterface iface;
    InetSocketAddress address;

    public FCMulticastSocketTransport(FCSocketConf conf) {
        System.setProperty("java.net.preferIPv4Stack", "true");
        this.conf = conf;
    }

    @Override
    public void join() throws IOException {
        if (this.address == null) {
            this.address = new InetSocketAddress(InetAddress.getByName(this.conf.mcastAdr), this.conf.port);
        }
        if (this.iface == null && this.conf.getIfacAdr() != null) {
            this.iface = NetworkInterface.getByName(this.conf.getIfacAdr());
            if (this.iface == null) {
                this.iface = NetworkInterface.getByInetAddress(Inet4Address.getByName(this.conf.getIfacAdr()));
            }
            if (this.iface == null) {
                FCLog.log("Could not find a network interface named '" + this.conf.getIfacAdr() + "'");
            }
        }
        this.socket = new MulticastSocket(this.conf.port);
        if (this.iface != null) {
            this.socket.setNetworkInterface(this.iface);
        }
        this.socket.setReceiveBufferSize(this.conf.receiveBufferSize);
        this.socket.setSendBufferSize(this.conf.sendBufferSize);
        this.socket.setTrafficClass(this.conf.trafficClass);
        this.socket.setLoopbackMode(!this.conf.loopBack);
        this.socket.setTimeToLive(this.conf.ttl);
        this.socket.joinGroup(InetAddress.getByName(this.conf.mcastAdr));
        FCLog.log("Connecting to interface " + this.conf.getIfacAdr() + " on address " + this.conf.mcastAdr + " " + this.conf.port);
    }

    @Override
    public FCSocketConf getConf() {
        return this.conf;
    }

    @Override
    public boolean receive(DatagramPacket pack) throws IOException {
        this.socket.receive(pack);
        return true;
    }

    @Override
    public void send(DatagramPacket pack) throws IOException {
        pack.setSocketAddress(this.address);
        this.socket.send(pack);
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public NetworkInterface getInterface() {
        return this.iface;
    }
}

