/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.remoting;

import de.ruedigermoeller.fastcast.config.FCClusterConfig;
import de.ruedigermoeller.fastcast.config.FCLocalClusterConf;
import de.ruedigermoeller.fastcast.config.FCTopicConf;
import de.ruedigermoeller.fastcast.control.FCTransportDispatcher;
import de.ruedigermoeller.fastcast.packeting.ControlPacket;
import de.ruedigermoeller.fastcast.packeting.DataPacket;
import de.ruedigermoeller.fastcast.packeting.MsgReceiver;
import de.ruedigermoeller.fastcast.packeting.Packet;
import de.ruedigermoeller.fastcast.packeting.PacketSendBuffer;
import de.ruedigermoeller.fastcast.packeting.RetransEntry;
import de.ruedigermoeller.fastcast.packeting.RetransPacket;
import de.ruedigermoeller.fastcast.packeting.TopicEntry;
import de.ruedigermoeller.fastcast.packeting.TopicStats;
import de.ruedigermoeller.fastcast.remoting.FCBinaryMessageListener;
import de.ruedigermoeller.fastcast.remoting.FCBinaryTopicService;
import de.ruedigermoeller.fastcast.remoting.FCFutureResultHandler;
import de.ruedigermoeller.fastcast.remoting.FCInvoker;
import de.ruedigermoeller.fastcast.remoting.FCProxyFactory;
import de.ruedigermoeller.fastcast.remoting.FCReceiveContext;
import de.ruedigermoeller.fastcast.remoting.FCRemoteServiceProxy;
import de.ruedigermoeller.fastcast.remoting.FCRemoting;
import de.ruedigermoeller.fastcast.remoting.FCRemotingListener;
import de.ruedigermoeller.fastcast.remoting.FCSendContext;
import de.ruedigermoeller.fastcast.remoting.FCTopicService;
import de.ruedigermoeller.fastcast.service.FCMembership;
import de.ruedigermoeller.fastcast.transport.FCMulticastChannelTransport;
import de.ruedigermoeller.fastcast.transport.FCMulticastSocketTransport;
import de.ruedigermoeller.fastcast.transport.FCSocketConf;
import de.ruedigermoeller.fastcast.transport.SharedMemTransport;
import de.ruedigermoeller.fastcast.transport.Transport;
import de.ruedigermoeller.fastcast.util.FCLog;
import de.ruedigermoeller.fastcast.util.FCUtils;
import de.ruedigermoeller.heapoff.bytez.Bytez;
import de.ruedigermoeller.heapoff.bytez.onheap.HeapBytez;
import de.ruedigermoeller.heapoff.structs.unsafeimpl.FSTStructFactory;
import de.ruedigermoeller.serialization.FSTConfiguration;
import de.ruedigermoeller.serialization.FSTObjectInput;
import de.ruedigermoeller.serialization.FSTObjectOutput;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class FastCast
implements FSTObjectInput.ConditionalCallback,
FCRemoting {
    static final int BINARY = 55;
    static final int FAST_CALL = 66;
    static final int REMOTE_CALL = 77;
    static final int CALL_RESULT = 88;
    public static final int HEARTBEAT = 99;
    private final FCProxyFactory proxyFactory = new FCProxyFactory();
    protected FCClusterConfig config;
    protected static FSTConfiguration conf;
    static FastCast fc;
    protected HashMap<String, Transport> transports = new HashMap();
    protected HashMap<String, FCTransportDispatcher> dispatcher = new HashMap();
    protected HashMap<String, FCTopicConf> channelConf = new HashMap();
    protected HashMap<String, TopicEntry> topics = new HashMap();
    String nodeId;
    FCRemotingListener listener;
    ThreadLocal<FSTObjectOutput> out = new ThreadLocal();
    ThreadLocal<FSTObjectInput> in = new ThreadLocal();
    ThreadLocal<ReceiverThreadContext> recCtx = new ThreadLocal<ReceiverThreadContext>(){

        @Override
        protected ReceiverThreadContext initialValue() {
            return new ReceiverThreadContext();
        }
    };
    FCMembership memberShipRemote;
    FCMembership memberShipLocal;

    public static FSTConfiguration getSerializationConfig() {
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FCRemoting getRemoting() {
        Class<FCRemoting> clazz = FCRemoting.class;
        synchronized (FCRemoting.class) {
            if (fc != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return fc;
            }
            fc = new FastCast();
            FCLog.get().internal_clusterListenerLog("____ ____ ____ ___ ____ ____ ____ ___\n|--- |--| ====  |  |___ |--| ====  |  \n> v2");
            // ** MonitorExit[var0] (shouldn't be in output)
            return fc;
        }
    }

    @Override
    public void joinCluster(String configFile, String nodeId, String clusterName) throws IOException {
        FCClusterConfig conf = FCClusterConfig.read(configFile);
        String over = new File(configFile).getAbsoluteFile().getParentFile().getParent() + File.separator + "local" + File.separator + new File(configFile).getName();
        if (!new File(over).exists()) {
            over = "." + File.separator + "local" + File.separator + configFile;
        }
        if (new File(over).exists()) {
            FCLocalClusterConf local = FCLocalClusterConf.read(over);
            conf.overrideBy(local);
        }
        this.joinCluster(conf, nodeId, clusterName);
    }

    @Override
    public FCRemotingListener getRemotingListener() {
        return this.listener;
    }

    @Override
    public void setRemotingListener(FCRemotingListener listener) {
        this.listener = listener;
    }

    @Override
    public void joinCluster(FCClusterConfig conf, String nodeId, String clusterName) {
        if (clusterName != null && clusterName.length() > 0) {
            conf.setClusterName(clusterName);
        }
        this.start(conf, nodeId);
    }

    public void start(FCClusterConfig config, String nodeName) {
        this.config = config;
        this.setNodeId(nodeName);
        FCLog.get().setLogLevel(config.getLogLevel());
        this.initTransports(config.getTransports(), nodeName);
        FCTopicConf[] topicsList = config.getTopics();
        this.initTopics(topicsList);
    }

    public void setNodeId(String nodeName) {
        if (this.nodeId != null) {
            throw new RuntimeException("Node Id can only be set ponce per process");
        }
        this.nodeId = FCUtils.createNodeId(nodeName);
    }

    public FCRemoteServiceProxy getServiceProxy(String topic) {
        TopicEntry topicEntry = this.topics.get(topic);
        if (topicEntry == null) {
            return null;
        }
        return topicEntry.getServiceProxy();
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public FCTopicService getService(String topic) {
        TopicEntry topicEntry = this.topics.get(topic);
        if (topicEntry == null) {
            return null;
        }
        return topicEntry.getService();
    }

    public Transport getTransport(String name) {
        Transport transport = this.transports.get(name);
        if (transport == null) {
            FCLog.log("could not find transport '" + name + "'. Falling back to transport 'default'");
            return this.transports.get("default");
        }
        return transport;
    }

    TopicEntry getTopic(String name) {
        return this.topics.get(name);
    }

    @Override
    public TopicStats getStats(String name) {
        TopicEntry topic = this.getTopic(name);
        if (topic != null) {
            return topic.getStats();
        }
        return null;
    }

    @Override
    public List<String> getActiveTopics() {
        ArrayList<String> res = new ArrayList<String>();
        for (TopicEntry next : this.topics.values()) {
            if (!next.isListenCalls() && next.getSender() == null) continue;
            res.add(next.getConf().getName());
        }
        Collections.sort(res);
        return res;
    }

    @Override
    public FCTopicConf getTopicConfiguration(String name) {
        return this.getTopic(name).getConf();
    }

    @Override
    public void startReceiving(String topicName, FCBinaryMessageListener binaryListener) {
        this.startReceiving(topicName, new FCBinaryTopicService(binaryListener));
    }

    @Override
    public void startReceiving(String topicName, FCTopicService service) {
        TopicEntry topic = this.getTopic(topicName);
        topic.setService(service);
        topic.getConf().setServiceClass(service.getClass().getName());
        this.startReceiving(topicName);
    }

    @Override
    public void startReceiving(String topicName) {
        TopicEntry topic = this.getTopic(topicName);
        try {
            if (topic.getService() == null) {
                topic.setService((FCTopicService)Class.forName(topic.getServiceClazz()).newInstance());
            }
            this.initServiceClz(topic, topic.getServiceClazz());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (topic.hasRemoteResultCalls() && !topic.getChannelDispatcher().hasSender(topic)) {
            this.startSending(topicName);
        }
        topic.getService().initializeBeforeListening(this, this.nodeId, topic.getConf().getName(), topic.getTopic());
        if (FCMembership.class.getName().equals(topic.getServiceClazz())) {
            this.memberShipLocal = (FCMembership)this.getService(topic.getName());
        }
        topic.getService().init();
        if (topic.getChannelDispatcher().hasReceiver(topic)) {
            topic.setListenCalls(true);
        } else {
            topic.getChannelDispatcher().startListening(topic);
            topic.setListenCalls(true);
        }
    }

    @Override
    public void start(String topicName) {
        this.startSending(topicName);
        this.startReceiving(topicName);
    }

    @Override
    public FCRemoteServiceProxy startSending(String topic, Class<? extends FCTopicService> fcBinaryTopicServiceClass) throws Exception {
        TopicEntry te = this.getTopic(topic);
        te.getConf().setServiceClass(fcBinaryTopicServiceClass.getName());
        this.installService(te);
        this.startSending(topic);
        return te.getServiceProxy();
    }

    @Override
    public FCRemoteServiceProxy startSending(String topicName) {
        TopicEntry topic = this.getTopic(topicName);
        FCTransportDispatcher dispatcher = topic.getChannelDispatcher();
        dispatcher.installSender(topic);
        dispatcher.putHeartbeat(topic.getSender());
        if (topic.hasRemoteResultCalls() && !dispatcher.hasReceiver(topic)) {
            topic.setListenCalls(false);
            topic.getChannelDispatcher().startListening(topic);
        }
        if (FCMembership.class.getName().equals(topic.getServiceClazz())) {
            this.memberShipRemote = (FCMembership)((Object)topic.getServiceProxy());
        }
        return topic.getServiceProxy();
    }

    @Override
    public void stopReceiving(String topicName) {
        TopicEntry topic = this.getTopic(topicName);
        topic.getChannelDispatcher().stopListening(topic);
    }

    @Override
    public FCRemoteServiceProxy getRemoteService(String topic) {
        TopicEntry topicEntry = this.topics.get(topic);
        if (topicEntry == null) {
            return null;
        }
        return topicEntry.getServiceProxy();
    }

    public boolean hasRemoteResult(Object[] args) {
        return args != null && args.length > 0 && args[args.length - 1] instanceof FCFutureResultHandler;
    }

    public FSTObjectOutput prepareFastCall(int methodIndex, int args) throws IOException {
        FSTObjectOutput fstObjectOutput = this.out.get();
        if (fstObjectOutput == null) {
            fstObjectOutput = new FSTObjectOutput(conf);
            this.out.set(fstObjectOutput);
        }
        fstObjectOutput.resetForReUse(null);
        fstObjectOutput.writeFByte(66);
        fstObjectOutput.writeFByte(methodIndex);
        byte[] flowFilter = FCSendContext.get().getFlowHeader();
        if (flowFilter != null) {
            fstObjectOutput.writeFByteArr(flowFilter);
        }
        if (FCSendContext.get().getReceiver() == null) {
            fstObjectOutput.writeFByte(0);
        } else {
            fstObjectOutput.writeFByte(1);
            fstObjectOutput.writeStringUTFSpeed(FCSendContext.get().getReceiver());
        }
        fstObjectOutput.writeFByte(args);
        return fstObjectOutput;
    }

    public void finishFastCall(PacketSendBuffer sender, FSTObjectOutput fstObjectOutput) {
        byte[] buffer = fstObjectOutput.getBuffer();
        int written = fstObjectOutput.getWritten();
        this.finishFastCallImpl(sender, (Bytez)new HeapBytez(buffer), written);
    }

    private void finishFastCallImpl(PacketSendBuffer sender, Bytez buffer, int written) {
        sender.putMessage(-1, buffer, 0, written, false);
        FCSendContext.get().reset();
    }

    public void sendBinaryContent(final TopicEntry topicEntry, PacketSendBuffer sender, final Bytez bytes, final int offset, final int length, boolean loopback) throws IOException {
        if (loopback) {
            topicEntry.getMethodExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    FastCast.this.prepareReceiveContext(FastCast.this.nodeId, topicEntry);
                    topicEntry.getService().receiveBinary(bytes, offset, length);
                }
            });
        }
        sender.putMessage(55, bytes, offset, length, false);
        FCSendContext.get().reset();
    }

    public void callRemoteMethod(final TopicEntry topicEntry, PacketSendBuffer sender, final int methodIndex, final Object[] args, boolean loopback, boolean unreliable) throws IOException {
        FSTObjectOutput fstObjectOutput = this.out.get();
        if (fstObjectOutput == null) {
            fstObjectOutput = new FSTObjectOutput(conf);
            this.out.set(fstObjectOutput);
        }
        fstObjectOutput.resetForReUse(null);
        if (this.hasRemoteResult(args)) {
            FCFutureResultHandler inner = (FCFutureResultHandler)args[args.length - 1];
            long cbid = topicEntry.getCbMap().assignCallbackId(inner);
            inner.setCbid(cbid);
            inner.setTopicEntry(topicEntry);
            args[args.length - 1] = cbid;
        }
        String rec = FCSendContext.get().getReceiver();
        fstObjectOutput.writeFByte(77);
        fstObjectOutput.writeFByte(methodIndex);
        byte[] flowFilter = FCSendContext.get().getFlowHeader();
        if (flowFilter != null) {
            fstObjectOutput.writeFByteArr(flowFilter);
        }
        if (rec == null) {
            fstObjectOutput.writeFByte(0);
        } else {
            fstObjectOutput.writeFByte(1);
            fstObjectOutput.writeStringUTFSpeed(rec);
        }
        fstObjectOutput.writeFByte(args.length);
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            fstObjectOutput.writeObject(arg);
        }
        byte[] buffer = fstObjectOutput.getBuffer();
        if (loopback) {
            topicEntry.getMethodExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    FastCast.this.prepareReceiveContext(FastCast.this.nodeId, topicEntry);
                    final Object lastArg = args[args.length - 1];
                    if (args.length > 1 && lastArg instanceof FCFutureResultHandler) {
                        args[args.length - 1] = new FCFutureResultHandler(){
                            volatile boolean done = false;

                            @Override
                            public void done() {
                                this.done = true;
                            }

                            public void resultReceived(Object obj, String sender) {
                                throw new RuntimeException("invoked at result receiver side. Not invokable here");
                            }

                            public void sendResult(Object obj) {
                                if (!this.done) {
                                    ((FCFutureResultHandler)lastArg).resultReceived(obj, FastCast.this.nodeId);
                                }
                            }
                        };
                    }
                    Method method = topicEntry.getMethods()[methodIndex];
                    try {
                        method.invoke((Object)topicEntry.getService(), args);
                    }
                    catch (IllegalAccessException e) {
                        FCLog.log(e);
                    }
                    catch (InvocationTargetException e) {
                        FCLog.log(e);
                    }
                }
            });
        }
        sender.putMessage(-1, (Bytez)new HeapBytez(buffer, 0L, (long)fstObjectOutput.getWritten()), 0, fstObjectOutput.getWritten(), false);
        FCSendContext.get().reset();
    }

    public FCTransportDispatcher getTransportDispatcher(String transName) {
        FCTransportDispatcher res = this.dispatcher.get(transName);
        if (res == null) {
            Transport transport = this.getTransport(transName);
            res = new FCTransportDispatcher(transport, this.config.getClusterName(), this.nodeId);
            this.dispatcher.put(transName, res);
        }
        return res;
    }

    protected void initTopics(FCTopicConf[] channelConfs) {
        FCTopicConf channelConf;
        int i;
        for (i = 0; i < channelConfs.length; ++i) {
            channelConf = channelConfs[i];
            this.initTopic(channelConf);
        }
        for (i = 0; i < channelConfs.length; ++i) {
            channelConf = channelConfs[i];
            if (!channelConf.isAutoStart()) continue;
            this.startSending(channelConf.getName());
            this.startReceiving(channelConf.getName());
        }
    }

    private void initTopic(FCTopicConf channelConf) {
        this.channelConf.put(channelConf.getName(), channelConf);
        FCTransportDispatcher dispatcher = this.getTransportDispatcher(channelConf.getTransport());
        channelConf.getSendPauseMicros();
        TopicEntry topicEntry = new TopicEntry(channelConf);
        topicEntry.setChannelDispatcher(dispatcher);
        try {
            this.installService(topicEntry);
        }
        catch (Exception e) {
            FCLog.log(e);
        }
        this.topics.put(channelConf.getName(), topicEntry);
    }

    protected void installService(TopicEntry topic) throws Exception {
        String serviceClazz = topic.getConf().getServiceClass();
        if (topic.getMsgReceiver() == null) {
            topic.setMsgReceiver(this.createMsgReceiver(topic));
        }
        if (serviceClazz == null) {
            return;
        }
        this.initServiceClz(topic, serviceClazz);
    }

    private void initServiceClz(TopicEntry topic, String serviceClazz) throws Exception {
        Class<?> clz = Class.forName(serviceClazz);
        if (this.getServiceProxy(topic.getConf().getName()) == null) {
            topic.setServiceProxy((FCRemoteServiceProxy)this.proxyFactory.createProxy(clz, topic, this));
        }
        if (topic.getMethods() == null) {
            topic.setMethods(this.proxyFactory.getSortedPublicMethods(clz));
        }
    }

    private MsgReceiver createMsgReceiver(final TopicEntry topic) {
        return new MsgReceiver(){

            @Override
            public void messageReceived(String sender, long sequence, Bytez bz, int off, int len) {
                ReceiverThreadContext ct = FastCast.this.recCtx.get();
                boolean listenMethods = topic.isListenCalls();
                try {
                    if (listenMethods && len > 0 && bz.get((long)off) == 55) {
                        topic.getService().receiveBinary(bz, off + 1, len - 1);
                        return;
                    }
                    FastCast.this.prepareReceiveContext(sender, topic);
                    byte code = bz.get((long)off);
                    if (listenMethods && (code == 77 || code == 66)) {
                        boolean hasRemoteResult;
                        String rec;
                        byte methodIndex;
                        FCTopicService callTarget = topic.getService();
                        int flowHeader = callTarget.readAndFilter(methodIndex = bz.get((long)(off + 1)), bz, off + 2);
                        if (flowHeader < 0) {
                            return;
                        }
                        byte[] b = bz.toBytes(off, len);
                        FSTObjectInput fstObjectInput = FastCast.this.getNewFstObjectInput(b, 0, len);
                        for (int i = 0; i < flowHeader + 2; ++i) {
                            fstObjectInput.readFByte();
                        }
                        byte isRec = fstObjectInput.readFByte();
                        if (isRec == 1 && !(rec = fstObjectInput.readStringUTFSpeed()).equals(FastCast.this.getNodeId())) {
                            return;
                        }
                        Object[] args = ct.zeroArgs;
                        int numArgs = fstObjectInput.readFByte();
                        Method m = topic.getMethods()[methodIndex];
                        Class[] argTypes = topic.getMethodArgs()[methodIndex];
                        boolean bl = hasRemoteResult = argTypes != null && argTypes.length > 0 && argTypes[argTypes.length - 1] == FCFutureResultHandler.class;
                        if (numArgs > 0) {
                            boolean invoked;
                            if (!hasRemoteResult) {
                                switch (numArgs) {
                                    case 1: {
                                        args = ct.oneArgs;
                                        break;
                                    }
                                    case 2: {
                                        args = ct.twoArgs;
                                        break;
                                    }
                                    case 3: {
                                        args = ct.threeArgs;
                                        break;
                                    }
                                    case 4: {
                                        args = ct.fourArgs;
                                        break;
                                    }
                                    default: {
                                        args = new Object[numArgs];
                                        break;
                                    }
                                }
                            } else {
                                args = new Object[numArgs];
                            }
                            if (invoked = callTarget.invoke(methodIndex, m, fstObjectInput, argTypes)) {
                                return;
                            }
                            FCInvoker fcInvoker = topic.getMethodInvoker()[methodIndex];
                            if (fcInvoker == null) {
                                FCInvoker fCInvoker = FastCast.this.proxyFactory.getMethod(topic.getServiceClazz(), methodIndex);
                                topic.getMethodInvoker()[methodIndex] = fCInvoker;
                                fcInvoker = fCInvoker;
                            }
                            if (fcInvoker != null) {
                                fcInvoker.invoke(callTarget, fstObjectInput);
                                return;
                            }
                            switch (code) {
                                case 77: {
                                    for (int i = 0; i < numArgs; ++i) {
                                        args[i] = fstObjectInput.readObject();
                                    }
                                    break;
                                }
                                case 66: {
                                    FastCast.this.decodeFastCall(fstObjectInput, argTypes, args);
                                }
                            }
                        }
                        if (hasRemoteResult) {
                            Long cbId = (Long)args[args.length - 1];
                            args[args.length - 1] = FastCast.this.createRemoteResultDispatcher(sender, cbId, topic);
                        }
                        try {
                            m.invoke((Object)callTarget, args);
                        }
                        catch (Exception e) {
                            FCLog.log(e);
                        }
                    } else if (code == 88) {
                        byte[] b = bz.toBytes(off + 1, len - 1);
                        FSTObjectInput fstObjectInput = FastCast.this.getNewFstObjectInput(b, 0, len);
                        String receiver = fstObjectInput.readStringUTFSpeed();
                        if (FastCast.this.nodeId.equals(receiver)) {
                            long cbid = fstObjectInput.readFLong();
                            Object result = fstObjectInput.readObject();
                            FCFutureResultHandler fcFutureResultHandler = topic.getCbMap().get(cbid);
                            if (fcFutureResultHandler != null) {
                                fcFutureResultHandler.resultReceived(result, sender);
                            }
                        }
                    } else if (listenMethods && code == 99) {
                        long now = System.currentTimeMillis();
                        topic.registerHeartBeat(sender, now);
                        if (now - ct.lastSenderCleanUp > topic.getConf().getSenderTimeoutMillis()) {
                            List<String> timedOutSenders = topic.getTimedOutSenders(now, 30000L);
                            topic.removeSenders(timedOutSenders);
                            topic.getChannelDispatcher().cleanup(timedOutSenders, topic.getTopic());
                            ct.lastSenderCleanUp = now;
                        }
                    } else if (listenMethods) {
                        FCLog.get().severe("unknown code " + code, new Exception("stack trace"));
                    }
                }
                catch (Exception e) {
                    FCLog.log(e);
                }
            }
        };
    }

    private FSTObjectInput getNewFstObjectInput(byte[] b, int off, int len) throws IOException {
        FSTObjectInput fstObjectInput = this.in.get();
        if (fstObjectInput == null) {
            fstObjectInput = new FSTObjectInput(conf);
            this.in.set(fstObjectInput);
            fstObjectInput.setConditionalCallback((FSTObjectInput.ConditionalCallback)this);
        }
        fstObjectInput.resetForReuseUseArray(b, off, len);
        return fstObjectInput;
    }

    private void prepareReceiveContext(String sender, TopicEntry topic) {
        FCReceiveContext fcReceiveContext = FCReceiveContext.get();
        fcReceiveContext.sender = sender;
        fcReceiveContext.entry = topic;
    }

    private FCFutureResultHandler createRemoteResultDispatcher(final String sender, final Long cbId, final TopicEntry topic) {
        FCFutureResultHandler res = new FCFutureResultHandler(){

            public void sendResult(final Object obj) {
                topic.getReplys().execute(new Runnable(){

                    @Override
                    public void run() {
                        while (!topic.hadHeartbeat(sender)) {
                            Thread.yield();
                        }
                        FSTObjectOutput fstOut = FastCast.this.out.get();
                        if (fstOut == null) {
                            fstOut = new FSTObjectOutput(conf);
                            FastCast.this.out.set(fstOut);
                        }
                        fstOut.resetForReUse(null);
                        try {
                            fstOut.writeFByte(88);
                            fstOut.writeStringUTFSpeed(sender);
                            fstOut.writeFLong(cbId.longValue());
                            fstOut.writeObject(obj);
                        }
                        catch (IOException e) {
                            FCLog.log(e);
                        }
                        byte[] buffer = fstOut.getBuffer();
                        if (topic.getSender() == null) {
                            throw new RuntimeException("need to call startSending on topic '" + topic.getConf().getName() + "' in order to process method results. Topic:" + topic.getConf().getName());
                        }
                        topic.getSender().putMessage(-1, (Bytez)new HeapBytez(buffer, 0L, (long)fstOut.getWritten()), 0, fstOut.getWritten(), false);
                    }
                });
            }

            public void resultReceived(Object obj, String sender2) {
                throw new RuntimeException("invoked at result receiver side. Not invokable here");
            }
        };
        res.setCbid(cbId);
        res.setTopicEntry(topic);
        return res;
    }

    @Override
    public FCMembership getMemberShipRemoteProxy() {
        return this.memberShipRemote;
    }

    @Override
    public FCMembership getMemberShipLocal() {
        return this.memberShipLocal;
    }

    private void decodeFastCall(FSTObjectInput fstObjectInput, Class[] argTypes, Object[] resultingArgs) throws IOException {
        for (int i = 0; i < argTypes.length; ++i) {
            Class argType = argTypes[i];
            if (argType == Boolean.TYPE) {
                resultingArgs[i] = fstObjectInput.readBoolean();
                continue;
            }
            if (argType == Byte.TYPE) {
                resultingArgs[i] = fstObjectInput.readFByte();
                continue;
            }
            if (argType == Short.TYPE) {
                resultingArgs[i] = fstObjectInput.readFShort();
                continue;
            }
            if (argType == Character.TYPE) {
                resultingArgs[i] = Character.valueOf(fstObjectInput.readFChar());
                continue;
            }
            if (argType == Integer.TYPE) {
                resultingArgs[i] = fstObjectInput.readFInt();
                continue;
            }
            if (argType == Long.TYPE) {
                resultingArgs[i] = fstObjectInput.readFLong();
                continue;
            }
            if (argType == Float.TYPE) {
                resultingArgs[i] = Float.valueOf(fstObjectInput.readFFloat());
                continue;
            }
            if (argType == Double.TYPE) {
                resultingArgs[i] = fstObjectInput.readFDouble();
                continue;
            }
            if (argType != String.class) continue;
            resultingArgs[i] = fstObjectInput.readStringUTFSpeed();
        }
    }

    public boolean shouldSkip(Object o, int i, Field field) {
        return true;
    }

    protected void initTransports(FCSocketConf[] tconfs, String nodeName) {
        FCLog.log("connecting transports as '" + nodeName + "' in cluster:'" + this.config.getClusterName() + "'");
        for (int i = 0; i < tconfs.length; ++i) {
            FCSocketConf tconf = tconfs[i];
            this.createTransport(tconf);
        }
    }

    void createTransport(FCSocketConf tconf) {
        block7: {
            if (this.nodeId == null) {
                throw new RuntimeException("define nodeId first");
            }
            if (this.transports.get(tconf.getName()) != null) {
                throw new ConfigurationAlreadyDefinedException("transport " + tconf.getName() + " already initialized ");
            }
            try {
                FCLog.log("Connecting transport " + tconf.getName());
                if (FCSocketConf.MCAST_NIO_SOCKET.equals(tconf.getTransportType())) {
                    FCMulticastChannelTransport tr = new FCMulticastChannelTransport(tconf);
                    tr.join();
                    this.transports.put(tconf.getName(), tr);
                    break block7;
                }
                if (FCSocketConf.MCAST_SOCKET.equals(tconf.getTransportType())) {
                    FCMulticastSocketTransport tr = new FCMulticastSocketTransport(tconf);
                    tr.join();
                    this.transports.put(tconf.getName(), tr);
                    break block7;
                }
                if (FCSocketConf.MCAST_IPC.equals(tconf.getTransportType())) {
                    SharedMemTransport tr = new SharedMemTransport(tconf);
                    tr.join();
                    this.transports.put(tconf.getName(), tr);
                    break block7;
                }
                throw new RuntimeException("unknown transport " + tconf.getTransportType());
            }
            catch (IOException e) {
                FCLog.log(e);
            }
        }
    }

    static {
        System.setProperty("fst.unsafe", "true");
        conf = FSTConfiguration.createDefaultConfiguration();
        conf.setPreferSpeed(true);
        FSTStructFactory.getInstance().registerSystemClz((byte)127, new Class[]{Packet.class, DataPacket.class, RetransPacket.class, RetransEntry.class, ControlPacket.class});
    }

    public static class ConfigurationAlreadyDefinedException
    extends RuntimeException {
        public ConfigurationAlreadyDefinedException(String message) {
            super(message);
        }
    }

    static class ReceiverThreadContext {
        long lastSenderCleanUp = System.currentTimeMillis();
        Object[] zeroArgs = new Object[0];
        Object[] oneArgs = new Object[1];
        Object[] twoArgs = new Object[2];
        Object[] threeArgs = new Object[3];
        Object[] fourArgs = new Object[4];

        ReceiverThreadContext() {
        }
    }
}

