/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.remoting;

import de.ruedigermoeller.fastcast.remoting.FCFutureResultHandler;
import de.ruedigermoeller.fastcast.util.FCLog;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class FCCallbackMap {
    int linesize = 1000;
    long timeout = 5000L;
    int maxOpen;
    AtomicLong curId = new AtomicLong(1L);
    AtomicInteger currentOpen = new AtomicInteger(0);
    LinkedList<CBLine> lines;
    ArrayList<CBLine> cache = new ArrayList();
    int dequeCapacity;
    ConcurrentHashMap<Long, FCFutureResultHandler> extendedTimeouts0 = new ConcurrentHashMap();
    ConcurrentHashMap<Long, FCFutureResultHandler> extendedTimeouts1 = new ConcurrentHashMap();
    long lastFlip = System.currentTimeMillis();

    public FCCallbackMap(int size, int timeOut) {
        this.timeout = timeOut;
        this.maxOpen = size;
        this.linesize = this.maxOpen / 10;
        this.dequeCapacity = size / this.linesize + 2;
        this.lines = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long assignCallbackId(FCFutureResultHandler res) {
        while (this.currentOpen.get() > this.maxOpen) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                FCLog.log(e);
            }
        }
        long id = this.curId.incrementAndGet();
        CBLine curLine = null;
        LinkedList<CBLine> linkedList = this.lines;
        synchronized (linkedList) {
            if (this.lines.size() == 0) {
                this.lines.addFirst(this.newLine(System.currentTimeMillis() + this.timeout, this.linesize, this.curId.get()));
            }
            if (!(curLine = this.lines.getFirst()).fits(id)) {
                this.roll();
                curLine = this.lines.getFirst();
            }
            try {
                curLine.assignCallback(id, res);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                FCLog.get().warn(e);
                return this.assignCallbackId(res);
            }
        }
        this.currentOpen.addAndGet(1);
        return id;
    }

    CBLine newLine(long tim, int linesize, long offset) {
        if (this.cache.size() == 0) {
            return new CBLine(System.currentTimeMillis(), linesize, this.curId.get());
        }
        CBLine newLine = this.cache.remove(this.cache.size() - 1);
        newLine.rollTime = tim;
        newLine.cbIdOffset = offset;
        return newLine;
    }

    void roll() {
        long now;
        this.lines.getFirst().rollTime = now = System.currentTimeMillis();
        this.lines.addFirst(this.newLine(now + this.timeout, this.linesize, this.curId.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FCFutureResultHandler get(long id) {
        if (this.extendedTimeouts0.size() > 0 || this.extendedTimeouts1.size() > 0) {
            Long lid = id;
            FCFutureResultHandler res = this.extendedTimeouts0.get(lid);
            if (res == null) {
                res = this.extendedTimeouts1.get(lid);
            }
            if (res != null) {
                return res;
            }
        }
        LinkedList<CBLine> linkedList = this.lines;
        synchronized (linkedList) {
            if (this.lines.size() == 0) {
                return null;
            }
            for (CBLine line : this.lines) {
                if (!line.fits(id)) continue;
                return line.get(id);
            }
        }
        return null;
    }

    public void freeCallbackId(long id) {
        if (this.extendedTimeouts0.size() > 0 || this.extendedTimeouts1.size() > 0) {
            Long lid = id;
            this.extendedTimeouts0.remove(lid);
            this.extendedTimeouts1.remove(lid);
        }
        this.freeRegularCallbackId(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeRegularCallbackId(long id) {
        LinkedList<CBLine> linkedList = this.lines;
        synchronized (linkedList) {
            if (this.lines.size() == 0) {
                return;
            }
            for (CBLine line : this.lines) {
                if (!line.fits(id)) continue;
                line.clear(id);
                this.currentOpen.addAndGet(-1);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(long nowMillis) {
        if (nowMillis - this.lastFlip > this.timeout) {
            this.flip();
            this.lastFlip = nowMillis;
        }
        LinkedList<CBLine> linkedList = this.lines;
        synchronized (linkedList) {
            while (this.lines.size() > 0 && nowMillis - this.lines.getLast().rollTime > this.timeout) {
                CBLine cbLine = this.lines.removeLast();
                FCFutureResultHandler[] results = cbLine.results;
                for (int i = 0; i < results.length; ++i) {
                    FCFutureResultHandler result = results[i];
                    if (result == null) continue;
                    result.timeoutReached();
                    this.currentOpen.addAndGet(-1);
                    results[i] = null;
                }
                this.cache.add(cbLine);
            }
        }
    }

    private void flip() {
        ConcurrentHashMap<Long, FCFutureResultHandler> tmp = this.extendedTimeouts1;
        this.extendedTimeouts1 = this.extendedTimeouts0;
        for (Map.Entry<Long, FCFutureResultHandler> next : tmp.entrySet()) {
            if (this.extendedTimeouts1.containsKey(next.getKey())) continue;
            next.getValue().timeoutReached();
        }
        tmp.clear();
        this.extendedTimeouts0 = tmp;
    }

    public void extendTimeout(long cbid) {
        FCFutureResultHandler value = this.get(cbid);
        if (value == null) {
            throw new RuntimeException("callback already timed out. override FCFutureResultHandler.timedOut to detect this");
        }
        this.extendedTimeouts0.put(cbid, value);
        this.freeRegularCallbackId(cbid);
    }

    static class CBLine {
        FCFutureResultHandler[] results;
        long cbIdOffset;
        long rollTime;

        CBLine(long time, int lineSize, long offset) {
            this.results = new FCFutureResultHandler[lineSize];
            this.cbIdOffset = offset;
            this.rollTime = time;
        }

        boolean fits(long id) {
            return id >= this.cbIdOffset && id - this.cbIdOffset < (long)this.results.length;
        }

        void assignCallback(long id, FCFutureResultHandler res) {
            this.results[(int)(id - this.cbIdOffset)] = res;
        }

        public FCFutureResultHandler get(long id) {
            return this.results[(int)(id - this.cbIdOffset)];
        }

        public void clear(long id) {
            this.results[(int)(id - this.cbIdOffset)] = null;
        }
    }
}

