/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.packeting;

import de.ruedigermoeller.fastcast.util.FCLog;
import java.nio.ByteBuffer;

public class OffHeapHistory {
    static long CHUNK_SIZE = 10000000L;
    ByteBuffer[] buff;
    int entrySize;
    int numEntries;
    int numEntriesPerBuff;
    Thread previous = null;

    public static OffHeapHistory createDirectHistory(long sizeBytes, int dgramSize) {
        OffHeapHistory res = new OffHeapHistory();
        res.init(dgramSize, sizeBytes);
        return res;
    }

    void init(int dgramSiz, long sizeBytes) {
        this.entrySize = dgramSiz + 12;
        while (this.entrySize % 8 != 0) {
            ++this.entrySize;
        }
        this.numEntriesPerBuff = (int)(CHUNK_SIZE / (long)this.entrySize);
        int numChunks = (int)(sizeBytes / ((long)this.numEntriesPerBuff * (long)dgramSiz)) + 1;
        this.numEntries = numChunks * this.numEntriesPerBuff;
        this.buff = new ByteBuffer[numChunks];
        FCLog.log("allocating " + (long)numChunks * CHUNK_SIZE / 1000L / 1000L + "MByte of directmemory");
        for (int i = 0; i < this.buff.length; ++i) {
            this.buff[i] = ByteBuffer.allocateDirect((int)CHUNK_SIZE);
        }
    }

    public void putPacket(long sequence, byte[] packet, int packOff, int packLen) {
        this.checkThreads();
        int bufNo = (int)(sequence / (long)this.numEntriesPerBuff) % this.buff.length;
        int bufIdx = (int)(sequence % (long)this.numEntriesPerBuff);
        ByteBuffer buffer = this.buff[bufNo];
        buffer.position(bufIdx % this.numEntries * this.entrySize);
        buffer.putLong(sequence);
        buffer.putInt(packLen);
        buffer.put(packet, packOff, packLen);
    }

    private void checkThreads() {
    }

    public int getPacket(long sequence, byte[] dest, int off) {
        this.checkThreads();
        int bufNo = (int)(sequence / (long)this.numEntriesPerBuff) % this.buff.length;
        int bufIdx = (int)(sequence % (long)this.numEntriesPerBuff);
        ByteBuffer buffer = this.buff[bufNo];
        buffer.position(bufIdx % this.numEntries * this.entrySize);
        long readSeq = buffer.getLong();
        if (sequence == readSeq) {
            int len = buffer.getInt();
            buffer.get(dest, off, len);
            return len;
        }
        return -1;
    }

    public boolean hasSequence(long sequence) {
        this.checkThreads();
        if (this.previous == null) {
            this.previous = Thread.currentThread();
        }
        int bufNo = (int)(sequence / (long)this.numEntriesPerBuff) % this.buff.length;
        int bufIdx = (int)(sequence % (long)this.numEntriesPerBuff);
        ByteBuffer buffer = this.buff[bufNo];
        buffer.position(bufIdx % this.numEntries * this.entrySize);
        long readSeq = buffer.getLong();
        return sequence == readSeq;
    }
}

