/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.gui;

import java.util.ArrayList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.NumberAxisBuilder;
import javafx.scene.chart.StackedAreaChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.scene.shape.Rectangle;

public class TopicChart
extends BorderPane {
    NumberAxis xAxis;
    NumberAxis yAxis;
    ArrayList<XYChart.Data> retrans;
    ArrayList<XYChart.Data> regular;
    private String nodeId;
    Button close;
    private boolean running = true;

    public void init(boolean send, boolean stacked, String nodeId, String title, String xa, String ya) {
        try {
            int i;
            this.nodeId = nodeId;
            int seconds = 300;
            this.xAxis = ((NumberAxisBuilder)((NumberAxisBuilder)((NumberAxisBuilder)NumberAxisBuilder.create().label(xa)).lowerBound(1.0)).upperBound((double)(seconds - 1))).tickUnit(10.0).build();
            this.yAxis = ((NumberAxisBuilder)((NumberAxisBuilder)((NumberAxisBuilder)NumberAxisBuilder.create().label(ya)).lowerBound(0.0)).upperBound(100000.0)).tickUnit(100.0).build();
            this.retrans = new ArrayList();
            for (i = 0; i < seconds; ++i) {
                XYChart.Data d = new XYChart.Data((Object)i, (Object)0);
                d.setNode((Node)new Rectangle(0.0, 0.0, 0.0, 0.0));
                this.retrans.add(d);
            }
            this.regular = new ArrayList();
            for (i = 0; i < seconds; ++i) {
                XYChart.Data e = new XYChart.Data((Object)i, (Object)0);
                e.setNode((Node)new Rectangle(0.0, 0.0, 0.0, 0.0));
                this.regular.add(e);
            }
            ObservableList areaChartData = FXCollections.observableArrayList((Object[])new XYChart.Series[]{new XYChart.Series("Data (dgrams/sec)", FXCollections.observableArrayList(this.regular)), new XYChart.Series("Retransmission (dgrams/sec)", FXCollections.observableArrayList(this.retrans))});
            String border = "";
            if (stacked) {
                StackedAreaChart chart = new StackedAreaChart((Axis)this.xAxis, (Axis)this.yAxis, areaChartData);
                chart.setAnimated(false);
                chart.setLegendVisible(false);
                chart.setTitle(title);
                this.setCenter((Node)chart);
                if (send) {
                    Node lookup = chart.lookup(".chart");
                    lookup.setStyle("-fx-background-color:  #c0d0c0; " + border);
                } else {
                    Node lookup = chart.lookup(".chart");
                    lookup.setStyle("-fx-background-color:  #ccdccc; " + border);
                }
            } else {
                LineChart chart = new LineChart((Axis)this.xAxis, (Axis)this.yAxis, areaChartData);
                chart.setAnimated(false);
                chart.setLegendVisible(false);
                chart.setTitle(title);
                this.setCenter((Node)chart);
                if (send) {
                    Node lookup = chart.lookup(".chart");
                    lookup.setStyle("-fx-background-color:  #c0d0c0; " + border);
                } else {
                    Node lookup = chart.lookup(".chart");
                    lookup.setStyle("-fx-background-color:  #ccdccc; " + border);
                }
            }
            this.close = new Button("X");
            this.close.setStyle("-fx-background-color: " + (send ? "#c0d0c0" : "#ccdccc") + "; " + "-fx-background-radius: 0; " + "-fx-background-insets: 0;");
            this.setRight((Node)this.close);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void shiftAndAddValues(double ret, double reg) {
        this.shiftAndAdd(this.retrans, ret);
        this.shiftAndAdd(this.regular, reg);
    }

    void shiftAndAdd(List<XYChart.Data> l, double value) {
        for (int i = l.size() - 2; i >= 0; --i) {
            l.get(i + 1).setYValue(l.get(i).getYValue());
        }
        l.get(0).setYValue((Object)value);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }
}

