/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.control;

import de.ruedigermoeller.fastcast.control.FlowControl;
import de.ruedigermoeller.fastcast.packeting.TopicStats;

public class StupidFlowControl
implements FlowControl {
    int statCount = 0;
    TopicStats fiveIntervals;
    TopicStats thirtyIntervals;

    @Override
    public int adjustSendPause(int currentSendPause, TopicStats oneInterval) {
        ++this.statCount;
        if (this.fiveIntervals == null) {
            this.fiveIntervals = new TopicStats(oneInterval.getDgramSize());
        }
        if (this.thirtyIntervals == null) {
            this.thirtyIntervals = new TopicStats(oneInterval.getDgramSize());
        }
        oneInterval.addTo(this.fiveIntervals, 5);
        oneInterval.addTo(this.thirtyIntervals, 30);
        double retransPerc = oneInterval.getRetransVSDataPacketPercentage();
        double retrans5Perc = this.fiveIntervals.getRetransVSDataPacketPercentage();
        if (retransPerc > 1.0) {
            if (retrans5Perc > 0.5) {
                return currentSendPause * 3 / 2;
            }
            return currentSendPause * 7 / 6;
        }
        if (retransPerc > 0.5) {
            if (retrans5Perc > 0.3) {
                return currentSendPause * 7 / 6;
            }
            return currentSendPause * 13 / 12;
        }
        if (retransPerc > 0.2) {
            if (retrans5Perc > 0.1) {
                return currentSendPause * 13 / 12;
            }
            return currentSendPause * 25 / 24;
        }
        if (retransPerc < 0.1) {
            currentSendPause = currentSendPause * 17 / 18;
        }
        if (retrans5Perc < 0.1) {
            return Math.min(currentSendPause * 17 / 18, currentSendPause - 1);
        }
        return currentSendPause;
    }

    public int getStatCount() {
        return this.statCount;
    }

    public TopicStats getFiveIntervals() {
        return this.fiveIntervals;
    }

    public TopicStats getThirtyIntervals() {
        return this.thirtyIntervals;
    }
}

