/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.config;

import de.ruedigermoeller.fastcast.config.FCLocalClusterConf;
import de.ruedigermoeller.fastcast.config.FCTopicConf;
import de.ruedigermoeller.fastcast.remoting.FCEmptyService;
import de.ruedigermoeller.fastcast.transport.FCSocketConf;
import de.ruedigermoeller.fastcast.util.FCLog;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class FCClusterConfig {
    String clusterName = "def";
    HashMap<String, String> interfaces = new HashMap();
    FCSocketConf[] transports = new FCSocketConf[]{new FCSocketConf("default"), new FCSocketConf("control")};
    FCTopicConf[] topics = new FCTopicConf[]{new FCTopicConf("defaulttopic", "default", 0, FCEmptyService.class.getName()), new FCTopicConf("controlchannel", "default", 0, FCEmptyService.class.getName())};
    int logLevel = 2;

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void defineInterface(String symbolic, String realNameOrIp) {
        this.interfaces.put(symbolic, realNameOrIp);
    }

    public HashMap<String, String> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(HashMap<String, String> interfaces) {
        this.interfaces = interfaces;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public FCSocketConf[] getTransports() {
        for (int i = 0; i < this.transports.length; ++i) {
            FCSocketConf transport = this.transports[i];
            if (this.interfaces.get(transport.getIfacAdr()) == null) continue;
            transport.setIfacAdr(this.interfaces.get(transport.getIfacAdr()));
        }
        return this.transports;
    }

    public void setTransports(FCSocketConf[] transports) {
        this.transports = transports;
    }

    public FCTopicConf[] getTopics() {
        return this.topics;
    }

    public void setTopics(FCTopicConf[] topics) {
        this.topics = topics;
    }

    public void write(String finam) throws IOException {
        DumperOptions opt = new DumperOptions();
        opt.setPrettyFlow(true);
        Representer representer = new Representer();
        Yaml yaml = new Yaml(representer, opt);
        FileWriter wri = new FileWriter(finam);
        wri.write(yaml.dumpAsMap((Object)this));
        wri.close();
    }

    public static void write(String finam, FCClusterConfig data) throws IOException {
        DumperOptions opt = new DumperOptions();
        opt.setPrettyFlow(true);
        Representer representer = new Representer();
        representer.addClassTag(FCTopicConf.class, new Tag("!topic"));
        representer.addClassTag(FCSocketConf.class, new Tag("!socket"));
        Yaml yaml = new Yaml(representer, opt);
        System.out.println(yaml.dumpAsMap((Object)data));
    }

    public static FCClusterConfig read(InputStream in) throws IOException {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(){

            protected Class<?> getClassForNode(Node node) {
                String name = node.getTag().getValue();
                if ("!topic".equals(name)) {
                    return FCTopicConf.class;
                }
                if ("!socket".equals(name)) {
                    return FCSocketConf.class;
                }
                return super.getClassForNode(node);
            }
        });
        FCClusterConfig conf = (FCClusterConfig)yaml.loadAs(in, FCClusterConfig.class);
        in.close();
        return conf;
    }

    public void overrideTransBy(FCLocalClusterConf c) {
        int i;
        if (c == null) {
            return;
        }
        HashMap[] overTrans = c.getTransports();
        if (overTrans == null) {
            return;
        }
        HashMap<String, HashMap> patched = new HashMap<String, HashMap>();
        for (i = 0; i < overTrans.length; ++i) {
            HashMap hashMap = overTrans[i];
            String id = (String)hashMap.get("name");
            if (id == null) {
                throw new RuntimeException("missing attribute name on localconfig transport definition");
            }
            patched.put(id, hashMap);
        }
        for (i = 0; i < this.transports.length; ++i) {
            FCSocketConf transport = this.transports[i];
            HashMap oo = (HashMap)patched.get(transport.getName());
            if (oo == null) continue;
            Field[] fields = transport.getClass().getDeclaredFields();
            for (int j = 0; j < fields.length; ++j) {
                Field field = fields[j];
                Object val = oo.get(field.getName());
                if (val == null) continue;
                field.setAccessible(true);
                try {
                    field.set(transport, val);
                    FCLog.log("override " + val + " field " + field.getName() + " trans " + transport.getName());
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public FCClusterConfig overrideBy(String configFile) {
        try {
            String localover;
            if (new File("shared" + File.separator + configFile).exists()) {
                configFile = "shared" + File.separator + configFile;
            }
            if (new File(configFile).exists()) {
                FCLocalClusterConf local = null;
                local = FCLocalClusterConf.read(configFile);
                FCLog.log("overriding config with " + new File(configFile).getAbsolutePath());
                this.overrideBy(local);
            }
            if (!new File(localover = new File(configFile).getAbsoluteFile().getParentFile().getParent() + File.separator + "local" + File.separator + new File(configFile).getName()).exists()) {
                localover = "." + File.separator + "local" + File.separator + configFile;
            }
            if (new File(localover).exists()) {
                FCLocalClusterConf local = FCLocalClusterConf.read(localover);
                FCLog.log("overriding config with local " + new File(localover).getAbsolutePath());
                this.overrideBy(local);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public void overrideBy(FCLocalClusterConf over) {
        this.overrideIfaceBy(over);
        this.overrideTransBy(over);
        this.overrideTopicBy(over);
    }

    void overrideIfaceBy(FCLocalClusterConf c) {
        if (c == null) {
            return;
        }
        HashMap<String, String> hm = c.getInterfaces();
        for (Map.Entry<String, String> next : hm.entrySet()) {
            this.interfaces.put(next.getKey(), next.getValue());
        }
    }

    void overrideTopicBy(FCLocalClusterConf c) {
        int i;
        if (c == null) {
            return;
        }
        HashMap[] overTopic = c.getTopics();
        if (overTopic == null) {
            return;
        }
        HashMap<String, HashMap> patched = new HashMap<String, HashMap>();
        for (i = 0; i < overTopic.length; ++i) {
            HashMap hashMap = overTopic[i];
            String id = (String)hashMap.get("name");
            if (id == null) {
                throw new RuntimeException("missing attribute name on localconfig transport definition");
            }
            patched.put(id, hashMap);
        }
        for (i = 0; i < this.topics.length; ++i) {
            FCTopicConf topic = this.topics[i];
            HashMap oo = (HashMap)patched.get(topic.getName());
            if (oo == null) continue;
            if (oo.get("rateByDGrams") != null) {
                String s = (String)oo.get("rateByDGrams");
                String[] split = s.split("-");
                if (split.length != 2) {
                    throw new RuntimeException("illegal format in rateByDGrams directive. Use e.g. 10000-5");
                }
                int maxDatagramsPerSecond = Integer.parseInt(split[0]);
                int maxGCPauseSeconds = Integer.parseInt(split[1]);
                FCLog.log("set rate by DGrams:" + maxDatagramsPerSecond + " " + maxGCPauseSeconds);
                topic.setDGramRate(maxDatagramsPerSecond);
                topic.setNumPacketHistory(Math.max(maxDatagramsPerSecond * maxGCPauseSeconds, 500));
                topic.setReceiveBufferPackets(maxDatagramsPerSecond);
            }
            Field[] fields = topic.getClass().getDeclaredFields();
            for (int j = 0; j < fields.length; ++j) {
                Field field = fields[j];
                Object val = oo.get(field.getName());
                if (val == null) continue;
                field.setAccessible(true);
                try {
                    field.set(topic, val);
                    FCLog.log("override " + val + " field " + field.getName() + " topic " + topic.getName());
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static FCClusterConfig read(String finam) throws IOException {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(){

            protected Class<?> getClassForNode(Node node) {
                String name = node.getTag().getValue();
                if ("!topic".equals(name)) {
                    return FCTopicConf.class;
                }
                if ("!socket".equals(name)) {
                    return FCSocketConf.class;
                }
                return super.getClassForNode(node);
            }
        });
        if (!new File(finam).exists()) {
            finam = "shared" + File.separator + finam;
        }
        FileReader reader = new FileReader(finam);
        FCClusterConfig conf = (FCClusterConfig)yaml.loadAs((Reader)reader, FCClusterConfig.class);
        reader.close();
        return conf;
    }

    public static void main(String[] arg) throws IOException {
        FCClusterConfig conf = new FCClusterConfig();
        conf.interfaces.put("lo", "127.0.0.1");
        FCClusterConfig.write("/local/moelrue/work/fst/fastcast/build/control/fccontrol.yaml", conf);
    }
}

