/*
 * Decompiled with CFR 0.152.
 */
package de.rototor.pdfbox.graphics2d;

import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DFontTextDrawer;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2DFontTextDrawerDefaultFonts;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Paint;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.util.Matrix;

public class PdfBoxGraphics2DFontTextDrawer
implements IPdfBoxGraphics2DFontTextDrawer,
Closeable {
    private final List<FontEntry> fontFiles = new ArrayList<FontEntry>();
    private final List<File> tempFiles = new ArrayList<File>();
    private final Map<String, PDFont> fontMap = new HashMap<String, PDFont>();
    private PDFont fallbackFontUnknownEncodings;

    @Override
    public void close() {
        for (File tempFile : this.tempFiles) {
            tempFile.delete();
        }
        this.tempFiles.clear();
        this.fontFiles.clear();
        this.fontMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFont(String fontName, InputStream fontStream) throws IOException {
        File fontFile = File.createTempFile("pdfboxgfx2dfont", ".ttf");
        FileOutputStream out = new FileOutputStream(fontFile);
        try {
            IOUtils.copy((InputStream)fontStream, (OutputStream)out);
        }
        finally {
            out.close();
        }
        fontFile.deleteOnExit();
        this.tempFiles.add(fontFile);
        this.registerFont(fontName, fontFile);
    }

    public void registerFont(String fontName, File fontFile) {
        FontEntry entry = new FontEntry();
        entry.overrideName = fontName;
        entry.file = fontFile;
        this.fontFiles.add(entry);
    }

    public void registerFont(File fontFile) {
        this.registerFont(null, fontFile);
    }

    public void registerFont(InputStream fontStream) throws IOException {
        this.registerFont(null, fontStream);
    }

    public void registerFont(String name, PDFont font) {
        this.fontMap.put(name, font);
    }

    protected boolean hasDynamicFontMapping() {
        return this.getClass() != PdfBoxGraphics2DFontTextDrawer.class;
    }

    @Override
    public boolean canDrawText(AttributedCharacterIterator iterator, IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) throws IOException, FontFormatException {
        if (this.fontMap.size() == 0 && this.fontFiles.size() == 0 && !this.hasDynamicFontMapping()) {
            return false;
        }
        boolean run = true;
        StringBuilder sb = new StringBuilder();
        while (run) {
            int codePoint;
            Font attributeFont = (Font)iterator.getAttribute(TextAttribute.FONT);
            if (attributeFont == null) {
                attributeFont = env.getFont();
            }
            if (this.mapFont(attributeFont, env) == null) {
                return false;
            }
            if (iterator.getAttribute(TextAttribute.BACKGROUND) != null) {
                return false;
            }
            boolean isStrikeThrough = TextAttribute.STRIKETHROUGH_ON.equals(iterator.getAttribute(TextAttribute.STRIKETHROUGH));
            boolean isUnderline = TextAttribute.UNDERLINE_ON.equals(iterator.getAttribute(TextAttribute.UNDERLINE));
            boolean isLigatures = TextAttribute.LIGATURES_ON.equals(iterator.getAttribute(TextAttribute.LIGATURES));
            if (isStrikeThrough || isUnderline || isLigatures) {
                return false;
            }
            run = this.iterateRun(iterator, sb);
            String s = sb.toString();
            int l = s.length();
            for (int i = 0; i < l; i += Character.charCount(codePoint)) {
                codePoint = s.codePointAt(i);
                switch (Character.getDirectionality(codePoint)) {
                    case 0: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 16: 
                    case 17: 
                    case 18: {
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
                if (attributeFont.canDisplay(codePoint)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void drawText(AttributedCharacterIterator iterator, IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) throws IOException, FontFormatException {
        PDPageContentStream contentStream = env.getContentStream();
        contentStream.beginText();
        Matrix textMatrix = new Matrix();
        textMatrix.scale(1.0f, -1.0f);
        contentStream.setTextMatrix(textMatrix);
        StringBuilder sb = new StringBuilder();
        boolean run = true;
        while (run) {
            Number fontSize;
            Font attributeFont = (Font)iterator.getAttribute(TextAttribute.FONT);
            if (attributeFont == null) {
                attributeFont = env.getFont();
            }
            if ((fontSize = (Number)iterator.getAttribute(TextAttribute.SIZE)) != null) {
                attributeFont = attributeFont.deriveFont(fontSize.floatValue());
            }
            PDFont font = this.applyFont(attributeFont, env);
            Paint paint = (Paint)iterator.getAttribute(TextAttribute.FOREGROUND);
            if (paint == null) {
                paint = env.getPaint();
            }
            env.applyPaint(paint);
            boolean isStrikeThrough = TextAttribute.STRIKETHROUGH_ON.equals(iterator.getAttribute(TextAttribute.STRIKETHROUGH));
            boolean isUnderline = TextAttribute.UNDERLINE_ON.equals(iterator.getAttribute(TextAttribute.UNDERLINE));
            boolean isLigatures = TextAttribute.LIGATURES_ON.equals(iterator.getAttribute(TextAttribute.LIGATURES));
            run = this.iterateRun(iterator, sb);
            String text = sb.toString();
            try {
                this.showTextOnStream(env, contentStream, attributeFont, font, isStrikeThrough, isUnderline, isLigatures, text);
            }
            catch (IllegalArgumentException e) {
                if (font instanceof PDType1Font && !font.isEmbedded()) {
                    try {
                        if (this.fallbackFontUnknownEncodings == null) {
                            this.fallbackFontUnknownEncodings = this.findFallbackFont(env);
                        }
                        if (this.fallbackFontUnknownEncodings != null) {
                            env.getContentStream().setFont(this.fallbackFontUnknownEncodings, attributeFont.getSize2D());
                            this.showTextOnStream(env, contentStream, attributeFont, this.fallbackFontUnknownEncodings, isStrikeThrough, isUnderline, isLigatures, text);
                            e = null;
                        }
                    }
                    catch (IllegalArgumentException ignored) {
                        e = ignored;
                    }
                }
                if (e == null) continue;
                System.err.println("PDFBoxGraphics: Can not map text " + text + " with font " + attributeFont.getFontName() + ": " + e.getMessage());
            }
        }
        contentStream.endText();
    }

    private PDFont findFallbackFont(IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) throws IOException {
        String javaHome = System.getProperty("java.home", ".");
        String javaFontDir = javaHome + "/lib/fonts";
        String windir = System.getenv("WINDIR");
        if (windir == null) {
            windir = javaFontDir;
        }
        File[] paths = new File[]{new File(new File(windir), "fonts"), new File(System.getProperty("user.dir", ".")), new File("/Library/Fonts"), new File("/usr/share/fonts/truetype"), new File(javaFontDir)};
        File foundFontFile = null;
        for (String fontFileName : new String[]{"LucidaSansRegular.ttf", "arial.ttf", "Arial.ttf"}) {
            for (File path : paths) {
                File arialFile = new File(path, fontFileName);
                if (!arialFile.exists()) continue;
                foundFontFile = arialFile;
                break;
            }
            if (foundFontFile != null) break;
        }
        return PDType0Font.load((PDDocument)env.getDocument(), foundFontFile);
    }

    private void showTextOnStream(IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env, PDPageContentStream contentStream, Font attributeFont, PDFont font, boolean isStrikeThrough, boolean isUnderline, boolean isLigatures, String text) throws IOException {
        if (isStrikeThrough || isUnderline) {
            float stringWidth = font.getStringWidth(text);
            LineMetrics lineMetrics = attributeFont.getLineMetrics(text, env.getFontRenderContext());
        }
        if (isLigatures) {
            // empty if block
        }
        contentStream.showText(text);
    }

    private PDFont applyFont(Font font, IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) throws IOException, FontFormatException {
        PDFont fontToUse = this.mapFont(font, env);
        if (fontToUse == null) {
            fontToUse = PdfBoxGraphics2DFontTextDrawerDefaultFonts.chooseMatchingHelvetica(font);
        }
        env.getContentStream().setFont(fontToUse, font.getSize2D());
        return fontToUse;
    }

    protected PDFont mapFont(Font font, final IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) throws IOException, FontFormatException {
        for (final FontEntry fontEntry : this.fontFiles) {
            if (fontEntry.overrideName == null) {
                Font javaFont = Font.createFont(0, fontEntry.file);
                fontEntry.overrideName = javaFont.getFontName();
            }
            if (fontEntry.file.getName().toLowerCase(Locale.US).endsWith(".ttc")) {
                TrueTypeCollection collection = new TrueTypeCollection(fontEntry.file);
                collection.processAllFonts(new TrueTypeCollection.TrueTypeFontProcessor(){

                    public void process(TrueTypeFont ttf) throws IOException {
                        PDType0Font pdFont = PDType0Font.load((PDDocument)env.getDocument(), (TrueTypeFont)ttf, (boolean)true);
                        PdfBoxGraphics2DFontTextDrawer.this.fontMap.put(fontEntry.overrideName, pdFont);
                        PdfBoxGraphics2DFontTextDrawer.this.fontMap.put(pdFont.getName(), pdFont);
                    }
                });
                continue;
            }
            PDType0Font pdFont = PDType0Font.load((PDDocument)env.getDocument(), (File)fontEntry.file);
            this.fontMap.put(fontEntry.overrideName, (PDFont)pdFont);
        }
        this.fontFiles.clear();
        return this.fontMap.get(font.getFontName());
    }

    private boolean iterateRun(AttributedCharacterIterator iterator, StringBuilder sb) {
        sb.setLength(0);
        int charCount = iterator.getRunLimit() - iterator.getRunStart();
        while (charCount-- >= 0) {
            char c = iterator.current();
            iterator.next();
            if (c == '\uffff') {
                return false;
            }
            sb.append(c);
        }
        return true;
    }

    private static class FontEntry {
        String overrideName;
        File file;

        private FontEntry() {
        }
    }
}

