/*
 * Decompiled with CFR 0.152.
 */
package de.retest.util;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class StringSimilarity {
    public static double textSimilarity(String text0, String text1) {
        if (text0 == null || text1 == null) {
            return StringSimilarity.simpleSimilarity(text0, text1);
        }
        if (text0.equals(text1)) {
            return 1.0;
        }
        double fuzzyDistance = StringUtils.getFuzzyDistance((CharSequence)text0, (CharSequence)text1, (Locale)Locale.GERMAN);
        if (fuzzyDistance == 0.0) {
            return 0.0;
        }
        double maxLength = Math.max(text0.length(), text1.length());
        double similarity = fuzzyDistance / (maxLength * 4.0);
        assert (similarity >= 0.0 && similarity <= 1.0) : "text0 is: '" + text0 + "' - text1 is: '" + text1 + "', result is:" + similarity;
        return similarity;
    }

    public static double pathSimilarity(String path0, String path1) {
        if (path0 == null || path1 == null) {
            return StringSimilarity.simpleSimilarity(path0, path1);
        }
        if (path0.equals(path1)) {
            return 1.0;
        }
        if (path0.isEmpty() || path1.isEmpty()) {
            return 0.0;
        }
        int commonPrefixLength = StringUtils.getCommonPrefix((String[])new String[]{path0, path1}).length();
        int commonSuffixLength = StringSimilarity.getCommonSuffixStartingAt(path0, path1, commonPrefixLength);
        int minLength = Math.min(path0.length(), path1.length());
        int maxLength = Math.max(path0.length(), path1.length());
        int difference = Math.abs(minLength - (commonPrefixLength + commonSuffixLength)) + maxLength - minLength;
        double similarity = (double)(maxLength - difference) / (double)maxLength;
        similarity *= similarity;
        assert (similarity >= 0.0 && similarity <= 1.0) : "path0 is: '" + path0 + "' - path1 is: '" + path1 + "', result is:" + similarity;
        return similarity;
    }

    private static int getCommonSuffixStartingAt(String path0, String path1, int start) {
        int commonSuffixLength = 0;
        int idxP0 = path0.length() - 1;
        for (int idxP1 = path1.length() - 1; idxP0 >= start && idxP1 >= start; --idxP0, --idxP1) {
            char c1;
            char c0 = path0.charAt(idxP0);
            if (c0 == (c1 = path1.charAt(idxP1))) {
                ++commonSuffixLength;
                continue;
            }
            return commonSuffixLength;
        }
        return commonSuffixLength;
    }

    public static double simpleSimilarity(String s0, String s1) {
        if (StringUtils.equals((CharSequence)s0, (CharSequence)s1)) {
            return 1.0;
        }
        return 0.0;
    }
}

