/*
 * Decompiled with CFR 0.152.
 */
package de.retest.util;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.Charset;

public class ChecksumCalculator {
    public static final int LENGTH_OF_SHA256 = 64;
    private static ChecksumCalculator instance;
    private final HashFunction sha256 = Hashing.sha256();
    private final HashFunction md5 = Hashing.md5();

    public static ChecksumCalculator getInstance() {
        if (instance == null) {
            instance = new ChecksumCalculator();
        }
        return instance;
    }

    public String sha256(String input) {
        return this.sha256.hashString((CharSequence)input, Charset.defaultCharset()).toString();
    }

    public String sha256(byte[] input) {
        return this.sha256.hashBytes(input).toString();
    }

    public String md5(String input) {
        return this.md5.hashString((CharSequence)input, Charset.defaultCharset()).toString();
    }

    public String md5(byte[] input) {
        return this.md5.hashBytes(input).toString();
    }
}

