/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.selenium.css;

import de.retest.recheck.ui.descriptors.Element;
import de.retest.web.selenium.css.PredicateFactory;
import de.retest.web.selenium.css.Selector;
import de.retest.web.selenium.css.Transformer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class RegexTransformer
implements Transformer {
    private static final String REMAINING_GROUP = "remaining";
    private static final String REMAINING = "(?<remaining>.*)$";
    private static final String START_OF_LINE = "^";
    private final Pattern cssPattern;
    private final PredicateFactory factory;

    private RegexTransformer(String pattern, PredicateFactory factory) {
        this.cssPattern = Pattern.compile(START_OF_LINE + pattern + REMAINING);
        this.factory = factory;
    }

    static Transformer of(String pattern, PredicateFactory factory) {
        return new RegexTransformer(pattern, factory);
    }

    @Override
    public Selector transform(String selector) {
        Matcher matcher = this.cssPattern.matcher(selector);
        if (matcher.find()) {
            return this.newSelector(matcher);
        }
        return Selector.unsupported(selector);
    }

    private Selector newSelector(Matcher matcher) {
        String cssAttribute = matcher.group(1);
        String remainingSelector = matcher.group(REMAINING_GROUP).trim();
        Predicate<Element> predicate = this.factory.create(cssAttribute);
        return Selector.supported(remainingSelector, predicate);
    }
}

