/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.selenium.css;

import de.retest.recheck.ui.descriptors.Element;
import java.util.Arrays;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Has {
    private static final String TYPE = "type";
    private static final Pattern attribute = Has.attributePattern("");
    private static final Pattern attributeContaining = Has.attributePattern("~");
    private static final Pattern attributeStarting = Has.attributePattern("\\|");
    private static final Pattern attributeBeginning = Has.attributePattern("\\^");
    private static final Pattern attributeEnding = Has.attributePattern("\\$");
    private static final Pattern attributeContainsSubstring = Has.attributePattern("\\*");

    private static Pattern attributePattern(String selectingChar) {
        String allowedCharacters = "[^" + selectingChar + "=]+";
        return Pattern.compile("(" + allowedCharacters + ")(" + selectingChar + "=(" + allowedCharacters + "))?");
    }

    private Has() {
    }

    public static Predicate<Element> attribute(String selector) {
        return Has.hasAttribute(selector, attribute, String::equals);
    }

    private static Predicate<Element> hasAttribute(String selector, Pattern pattern, BiPredicate<String, String> predicate) {
        Matcher matcher = pattern.matcher(selector);
        if (matcher.matches()) {
            String attribute = matcher.group(1);
            String attributeValue = Has.fixAttributeValue(matcher.group(3));
            return Has.hasAttributeValue(attribute, attributeValue, predicate);
        }
        return e -> false;
    }

    private static Predicate<Element> hasAttributeValue(String attribute, String attributeValue, BiPredicate<String, String> toPredicate) {
        return element -> element.getAttributeValue(attribute) != null && toPredicate.test(element.getAttributeValue(attribute).toString(), attributeValue);
    }

    private static String fixAttributeValue(String result) {
        if (result == null) {
            return "true";
        }
        return Has.clearQuotes(result);
    }

    private static String clearQuotes(String result) {
        if (result.matches("^'.*'$|^\".*\"$")) {
            return result.substring(1, result.length() - 1);
        }
        return result;
    }

    public static Predicate<Element> attributeContaining(String selector) {
        return Has.hasAttribute(selector, attributeContaining, Has::containsWord);
    }

    public static boolean containsWord(String value, String selector) {
        return Arrays.stream(value.split(" ")).anyMatch(selector::equals);
    }

    public static Predicate<Element> attributeStarting(String selector) {
        return Has.hasAttribute(selector, attributeStarting, Has::startsWithWord);
    }

    public static boolean startsWithWord(String value, String selector) {
        return value.equals(selector) || value.startsWith(selector + "-");
    }

    public static Predicate<Element> attributeBeginning(String selector) {
        return Has.hasAttribute(selector, attributeBeginning, String::startsWith);
    }

    public static Predicate<Element> attributeEnding(String selector) {
        return Has.hasAttribute(selector, attributeEnding, String::endsWith);
    }

    public static Predicate<Element> attributeContainingSubstring(String selector) {
        return Has.hasAttribute(selector, attributeContainsSubstring, String::contains);
    }

    public static Predicate<Element> cssPseudoClass(String pseudoClass) {
        return element -> Has.hasPseudoClass(element, pseudoClass);
    }

    private static boolean hasPseudoClass(Element element, String pseudoClass) {
        return "true".equals(element.getAttributeValue(pseudoClass));
    }

    public static Predicate<Element> linkText(String linkText) {
        return element -> "a".equalsIgnoreCase(element.getIdentifyingAttributes().getType()) && linkText.equals(element.getAttributes().get("text")) || linkText.equals(element.getIdentifyingAttributes().get("text"));
    }

    public static Predicate<Element> partialLinkText(String linkText) {
        return element -> "a".equalsIgnoreCase(element.getIdentifyingAttributes().getType()) && element.getAttributeValue("text").toString().contains(linkText);
    }

    public static Predicate<Element> cssClass(String cssClass) {
        return element -> element.getIdentifyingAttributes().get("class") != null && element.getIdentifyingAttributes().get("class").toString().contains(cssClass);
    }

    public static Predicate<Element> cssName(String name) {
        return element -> name.equals(element.getIdentifyingAttributes().get("name"));
    }

    public static Predicate<Element> cssTag(String tag) {
        return element -> tag.equals(element.getIdentifyingAttributes().get(TYPE));
    }

    public static Predicate<Element> cssId(String id) {
        return element -> id.equals(element.getIdentifyingAttributes().get("id"));
    }
}

