/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.selenium;

import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.WrapsElement;

class WrappingWebElement
implements WebElement,
WrapsDriver,
WrapsElement {
    private final WebDriver driver;
    private final WebElement element;

    public static WebElement wrap(WebDriver driver, WebElement element) {
        return new WrappingWebElement(driver, element);
    }

    public WebDriver getWrappedDriver() {
        return this.driver;
    }

    public WebElement getWrappedElement() {
        return this.element;
    }

    public void click() {
        this.element.click();
    }

    public void submit() {
        this.element.submit();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.element.sendKeys(keysToSend);
    }

    public void clear() {
        this.element.clear();
    }

    public String getTagName() {
        return this.element.getTagName();
    }

    public String getAttribute(String name) {
        return this.element.getAttribute(name);
    }

    public boolean isSelected() {
        return this.element.isSelected();
    }

    public boolean isEnabled() {
        return this.element.isEnabled();
    }

    public String getText() {
        return this.element.getText();
    }

    public List<WebElement> findElements(By by) {
        return this.element.findElements(by).stream().map(element -> new WrappingWebElement(this.driver, (WebElement)element)).collect(Collectors.toList());
    }

    public WebElement findElement(By by) {
        return new WrappingWebElement(this.driver, this.element.findElement(by));
    }

    public boolean isDisplayed() {
        return this.element.isDisplayed();
    }

    public Point getLocation() {
        return this.element.getLocation();
    }

    public Dimension getSize() {
        return this.element.getSize();
    }

    public Rectangle getRect() {
        return this.element.getRect();
    }

    public String getCssValue(String propertyName) {
        return this.element.getCssValue(propertyName);
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        return (X)this.element.getScreenshotAs(target);
    }

    public String toString() {
        return this.element.toString();
    }

    public WrappingWebElement(WebDriver driver, WebElement element) {
        this.driver = driver;
        this.element = element;
    }
}

