/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.selenium;

import de.retest.recheck.TestCaseFinder;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.diff.ElementIdentificationWarning;
import de.retest.web.selenium.By;
import de.retest.web.selenium.ByWhisperer;
import de.retest.web.selenium.QualifiedElementWarning;
import de.retest.web.selenium.UnbreakableDriver;
import de.retest.web.selenium.css.DefaultSelectors;
import de.retest.web.selenium.css.Has;
import de.retest.web.selenium.css.PredicateBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHealer {
    private static final String PATH = "path";
    private static final String TYPE = "type";
    private static final Logger logger = LoggerFactory.getLogger(TestHealer.class);
    private static final String ELEMENT_NOT_FOUND_MESSAGE = "It appears that even the Golden Master has no element";
    private final UnbreakableDriver wrapped;
    private final RootElement lastExpectedState;
    private final RootElement lastActualState;
    private final Consumer<QualifiedElementWarning> warningConsumer;

    private TestHealer(UnbreakableDriver wrapped) {
        this.wrapped = wrapped;
        this.lastExpectedState = wrapped.getLastExpectedState();
        if (this.lastExpectedState == null) {
            throw new IllegalStateException("No last expected state to find old element in!");
        }
        this.lastActualState = wrapped.getLastActualState();
        this.warningConsumer = wrapped.getWarningConsumer();
    }

    public static WebElement findElement(org.openqa.selenium.By by, UnbreakableDriver wrapped) {
        return new TestHealer(wrapped).findElement(by);
    }

    private WebElement findElement(org.openqa.selenium.By by) {
        if (by instanceof By.ById) {
            return this.findElementById((By.ById)by);
        }
        if (by instanceof By.ByClassName) {
            return this.findElementByClassName((By.ByClassName)by);
        }
        if (by instanceof By.ByName) {
            return this.findElementByName((By.ByName)by);
        }
        if (by instanceof By.ByLinkText) {
            return this.findElementByLinkText((By.ByLinkText)by);
        }
        if (by instanceof By.ByCssSelector) {
            return this.findElementByCssSelector((By.ByCssSelector)by);
        }
        if (by instanceof By.ByXPath) {
            return this.findElementByXPath((By.ByXPath)by);
        }
        if (by instanceof By.ByTagName) {
            return this.findElementByTagName((By.ByTagName)by);
        }
        if (by instanceof By.ByPartialLinkText) {
            return this.findElementByPartialLinkText((By.ByPartialLinkText)by);
        }
        throw new UnsupportedOperationException("Healing tests with " + by.getClass().getSimpleName() + " not yet implemented");
    }

    private WebElement findElementById(By.ById by) {
        String id = ByWhisperer.retrieveId(by);
        Element actualElement = By.findElement(this.lastExpectedState, this.lastActualState, Has.cssId(id));
        if (actualElement == null) {
            logger.warn("{} with id '{}'.", (Object)ELEMENT_NOT_FOUND_MESSAGE, (Object)id);
            return null;
        }
        this.writeWarnLogForChangedIdentifier("id", id, actualElement.getIdentifyingAttributes().get("id"), "id", actualElement);
        return this.wrapped.findElement(org.openqa.selenium.By.xpath((String)actualElement.getIdentifyingAttributes().getPath()));
    }

    private WebElement findElementByClassName(By.ByClassName by) {
        String className = ByWhisperer.retrieveCssClassName(by);
        Element actualElement = By.findElement(this.lastExpectedState, this.lastActualState, Has.cssClass(className));
        if (actualElement == null) {
            logger.warn("{} with CSS class '{}'.", (Object)ELEMENT_NOT_FOUND_MESSAGE, (Object)className);
            return null;
        }
        this.writeWarnLogForChangedIdentifier("class", className, actualElement.getIdentifyingAttributes().get("class"), "className", actualElement);
        return this.wrapped.findElement(org.openqa.selenium.By.xpath((String)actualElement.getIdentifyingAttributes().getPath()));
    }

    private WebElement findElementByName(By.ByName by) {
        String name = ByWhisperer.retrieveName(by);
        Element actualElement = By.findElement(this.lastExpectedState, this.lastActualState, Has.cssName(name));
        if (actualElement == null) {
            logger.warn("{} with name '{}'.", (Object)ELEMENT_NOT_FOUND_MESSAGE, (Object)name);
            return null;
        }
        this.writeWarnLogForChangedIdentifier("name", name, actualElement.getIdentifyingAttributes().get("name"), "name", actualElement);
        return this.wrapped.findElement(org.openqa.selenium.By.xpath((String)actualElement.getIdentifyingAttributes().getPath()));
    }

    private WebElement findElementByLinkText(By.ByLinkText by) {
        String linkText = ByWhisperer.retrieveLinkText(by);
        Element actualElement = By.findElement(this.lastExpectedState, this.lastActualState, Has.linkText(linkText));
        if (actualElement == null) {
            logger.warn("{} with link text '{}'.", (Object)ELEMENT_NOT_FOUND_MESSAGE, (Object)linkText);
            return null;
        }
        if ("true".equals(actualElement.getAttributeValue("pseudo"))) {
            logger.warn("{} with link text '{}' is a pseudo element", (Object)ELEMENT_NOT_FOUND_MESSAGE, (Object)linkText);
            return null;
        }
        this.writeWarnLogForChangedIdentifier("text", linkText, actualElement.getIdentifyingAttributes().get("text"), "linkText", actualElement);
        return this.wrapped.findElement(org.openqa.selenium.By.xpath((String)actualElement.getIdentifyingAttributes().getPath()));
    }

    private WebElement findElementByPartialLinkText(By.ByPartialLinkText by) {
        String partialLinkText = ByWhisperer.retrievePartialLinkText(by);
        Element actualElement = By.findElement(this.lastExpectedState, this.lastActualState, Has.partialLinkText(partialLinkText));
        if (actualElement == null) {
            logger.warn("{} with link text '{}'.", (Object)ELEMENT_NOT_FOUND_MESSAGE, (Object)partialLinkText);
            return null;
        }
        this.writeWarnLogForChangedIdentifier("partial link text", partialLinkText, actualElement.getIdentifyingAttributes().get("text"), "partialLinkText", actualElement);
        return this.wrapped.findElement(org.openqa.selenium.By.xpath((String)actualElement.getIdentifyingAttributes().getPath()));
    }

    private WebElement findElementByCssSelector(By.ByCssSelector by) {
        String origSelector = ByWhisperer.retrieveCssSelector(by);
        Optional<Predicate<Element>> predicate = new PredicateBuilder(DefaultSelectors.all(), origSelector).build();
        return predicate.map(p -> this.toWebElement(origSelector, (Predicate<Element>)p)).orElse(null);
    }

    private WebElement toWebElement(String origSelector, Predicate<Element> predicate) {
        Element actualElement = By.findElement(this.lastExpectedState, this.lastActualState, predicate);
        if (actualElement == null) {
            logger.warn("{} with CSS selector '{}'.", (Object)ELEMENT_NOT_FOUND_MESSAGE, (Object)origSelector);
            return null;
        }
        this.writeWarnLogForChangedIdentifier("class", origSelector, actualElement.getIdentifyingAttributes().get("class"), "cssSelector", actualElement);
        return this.wrapped.findElement(org.openqa.selenium.By.xpath((String)actualElement.getIdentifyingAttributes().getPath()));
    }

    protected static boolean isNotYetSupportedXPathExpression(String xpathExpression) {
        return xpathExpression.matches(".*[<>:+\\s\"|'@\\*].*");
    }

    private WebElement findElementByXPath(By.ByXPath byXPath) {
        String xpathExpression = ByWhisperer.retrieveXPath(byXPath);
        if (TestHealer.isNotYetSupportedXPathExpression(xpathExpression)) {
            logger.warn("Unbreakable tests are not implemented for all XPath selectors. Please report your chosen selector ('{}') at https://github.com/retest/recheck-web/issues.", (Object)xpathExpression);
            return null;
        }
        Predicate<Element> predicate = element -> true;
        if (xpathExpression.startsWith("//")) {
            predicate = predicate.and(element -> element.getIdentifyingAttributes().getPath().toLowerCase().contains(xpathExpression.substring(1).toLowerCase()));
        } else if (xpathExpression.startsWith("/")) {
            predicate = predicate.and(element -> element.getIdentifyingAttributes().getPath().toLowerCase().startsWith(xpathExpression.substring(1).toLowerCase()));
        }
        Element actualElement = By.findElement(this.lastExpectedState, this.lastActualState, predicate);
        if (actualElement == null) {
            logger.warn("{} with XPath '{}'.", (Object)ELEMENT_NOT_FOUND_MESSAGE, (Object)xpathExpression);
            return null;
        }
        this.writeWarnLogForChangedIdentifier(PATH, xpathExpression, actualElement.getIdentifyingAttributes().get(PATH), "xpath", actualElement);
        return this.wrapped.findElement(org.openqa.selenium.By.xpath((String)actualElement.getIdentifyingAttributes().getPath()));
    }

    private WebElement findElementByTagName(By.ByTagName by) {
        String tag = ByWhisperer.retrieveTag(by);
        Element actualElement = By.findElement(this.lastExpectedState, this.lastActualState, Has.cssTag(tag));
        if (actualElement == null) {
            logger.warn("{} with tag '{}'.", (Object)ELEMENT_NOT_FOUND_MESSAGE, (Object)tag);
            return null;
        }
        this.writeWarnLogForChangedIdentifier(TYPE, tag, actualElement.getIdentifyingAttributes().get(TYPE), TYPE, actualElement);
        return this.wrapped.findElement(org.openqa.selenium.By.xpath((String)actualElement.getIdentifyingAttributes().getPath()));
    }

    private void writeWarnLogForChangedIdentifier(String elementIdentifier, Object oldValue, Object newValue, String byMethodName, Element actualElement) {
        logger.warn("*************** recheck warning ***************");
        logger.warn("The {} used for element identification changed from '{}' to '{}'.", new Object[]{this.makeHumanReadable(elementIdentifier), oldValue, newValue});
        logger.warn("retest identified the element based on the persisted Golden Master.");
        String test = "";
        String callSiteFileName = "";
        Integer callSiteLineNumber = -1;
        try {
            StackTraceElement callSite = TestCaseFinder.getInstance().findTestCaseMethodInStack().getStackTraceElement();
            test = callSite.getClassName();
            callSiteFileName = callSite.getFileName();
            callSiteLineNumber = callSite.getLineNumber();
        }
        catch (Exception e) {
            logger.warn("Exception retrieving call site of findBy call.");
        }
        logger.warn("If you apply these changes to the Golden Master {}, your test {} will break.", (Object)"", (Object)test);
        if (newValue != null) {
            logger.warn("Use `By.{}(\"{}\")` or `By.retestId(\"{}\")` to update your test {}:{}.", new Object[]{byMethodName, newValue, actualElement.getRetestId(), callSiteFileName, callSiteLineNumber});
        } else {
            logger.warn("Use `By.retestId(\"{}\")` to update your test {}:{}.", new Object[]{actualElement.getRetestId(), callSiteFileName, callSiteLineNumber});
        }
        if (this.warningConsumer != null) {
            this.warningConsumer.accept(new QualifiedElementWarning(actualElement.getRetestId(), elementIdentifier, new ElementIdentificationWarning(callSiteFileName, callSiteLineNumber, byMethodName, test)));
        }
    }

    private String makeHumanReadable(String elementIdentifier) {
        if (elementIdentifier.equals(TYPE)) {
            return "HTML tag attribute";
        }
        if (elementIdentifier.equals("text")) {
            return "link text";
        }
        return "HTML " + elementIdentifier + " attribute";
    }
}

