/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.selenium;

import de.retest.web.selenium.AutocheckingRecheckDriver;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.interactions.Coordinates;
import org.openqa.selenium.interactions.Locatable;
import org.openqa.selenium.internal.WrapsElement;

public class AutocheckingWebElement
implements WebElement,
WrapsDriver,
WrapsElement,
Locatable {
    private final WebElement wrappedElement;
    private final AutocheckingRecheckDriver driver;

    public static AutocheckingWebElement of(WebElement wrappedElement, AutocheckingRecheckDriver driver) {
        if (wrappedElement instanceof AutocheckingWebElement) {
            return (AutocheckingWebElement)wrappedElement;
        }
        return new AutocheckingWebElement(wrappedElement, driver);
    }

    public static AutocheckingWebElement of(WebElement wrappedElement, AutocheckingRecheckDriver driver, final String representation) {
        if (wrappedElement instanceof AutocheckingWebElement) {
            return (AutocheckingWebElement)wrappedElement;
        }
        return new AutocheckingWebElement(wrappedElement, driver){

            @Override
            public String toString() {
                return representation;
            }
        };
    }

    public WebElement skipCheck() {
        return this.wrappedElement;
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        return (X)this.wrappedElement.getScreenshotAs(target);
    }

    public void click() {
        this.wrappedElement.click();
        this.driver.check("click", this.wrappedElement, new Object[0]);
    }

    public void submit() {
        this.wrappedElement.submit();
        this.driver.check("submit", this.wrappedElement, new Object[0]);
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.wrappedElement.sendKeys(keysToSend);
        this.driver.check("enter", this.wrappedElement, keysToSend);
    }

    public void clear() {
        this.wrappedElement.clear();
        this.driver.check("clear", this.wrappedElement, new Object[0]);
    }

    public String getTagName() {
        return this.wrappedElement.getTagName();
    }

    public String getAttribute(String name) {
        return this.wrappedElement.getAttribute(name);
    }

    public boolean isSelected() {
        return this.wrappedElement.isSelected();
    }

    public boolean isEnabled() {
        return this.wrappedElement.isEnabled();
    }

    public String getText() {
        return this.wrappedElement.getText();
    }

    public List<WebElement> findElements(By by) {
        return this.wrappedElement.findElements(by).stream().map(element -> AutocheckingWebElement.of(element, this.driver)).collect(Collectors.toList());
    }

    public WebElement findElement(By by) {
        return AutocheckingWebElement.of(this.wrappedElement.findElement(by), this.driver);
    }

    public boolean isDisplayed() {
        return this.wrappedElement.isDisplayed();
    }

    public Point getLocation() {
        return this.wrappedElement.getLocation();
    }

    public Dimension getSize() {
        return this.wrappedElement.getSize();
    }

    public Rectangle getRect() {
        return this.wrappedElement.getRect();
    }

    public String getCssValue(String propertyName) {
        return this.wrappedElement.getCssValue(propertyName);
    }

    public WebDriver getWrappedDriver() {
        return this.driver;
    }

    public WebElement getWrappedElement() {
        return this.wrappedElement;
    }

    public String toString() {
        return this.wrappedElement.toString();
    }

    public Coordinates getCoordinates() {
        if (this.wrappedElement instanceof Locatable) {
            return ((Locatable)this.wrappedElement).getCoordinates();
        }
        throw new IllegalStateException(String.format("Element is not instance of %s.", Locatable.class.getSimpleName()));
    }

    private AutocheckingWebElement(WebElement wrappedElement, AutocheckingRecheckDriver driver) {
        this.wrappedElement = wrappedElement;
        this.driver = driver;
    }
}

