/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.meta.element;

import de.retest.recheck.meta.MetadataProvider;
import de.retest.web.meta.driver.WebDriverMetadataProvider;
import de.retest.web.util.SeleniumWrapperUtil;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebElementMetadataProvider {
    private static final Logger log = LoggerFactory.getLogger(WebElementMetadataProvider.class);

    public static MetadataProvider of(WebElement element) {
        return WebElementMetadataProvider.extractDriverMetadataProvider(element);
    }

    private static MetadataProvider extractDriverMetadataProvider(WebElement element) {
        if (SeleniumWrapperUtil.isWrapper(SeleniumWrapperUtil.WrapperOf.DRIVER, element)) {
            WebDriver wrapped = SeleniumWrapperUtil.getWrapped(SeleniumWrapperUtil.WrapperOf.DRIVER, element);
            return WebDriverMetadataProvider.of(wrapped);
        }
        if (SeleniumWrapperUtil.isWrapper(SeleniumWrapperUtil.WrapperOf.ELEMENT, element)) {
            WebElement wrapped = SeleniumWrapperUtil.getWrapped(SeleniumWrapperUtil.WrapperOf.ELEMENT, element);
            return WebElementMetadataProvider.extractDriverMetadataProvider(wrapped);
        }
        log.debug("Cannot retrieve driver from element {}. Element must be of '{}'. Returning empty metadata.", (Object)element, RemoteWebElement.class);
        return MetadataProvider.empty();
    }
}

