/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.meta.driver.capabilities;

import de.retest.recheck.meta.MetadataProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;

public final class PlatformMetadataProvider
implements MetadataProvider {
    private final Capabilities capabilities;

    public Map<String, String> retrieve() {
        HashMap<String, String> map = new HashMap<String, String>();
        Platform platform = this.retrievePlatformSilently();
        if (platform != null) {
            map.put("os.name", platform.toString());
            Object version = this.capabilities.getCapability("platformVersion");
            map.put("os.version", Objects.toString(version, ""));
            map.put("os.arch", "");
        }
        return map;
    }

    private Platform retrievePlatformSilently() {
        try {
            return this.capabilities.getPlatform();
        }
        catch (IllegalArgumentException | WebDriverException e) {
            return null;
        }
    }

    PlatformMetadataProvider(Capabilities capabilities) {
        this.capabilities = capabilities;
    }
}

