/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.meta.driver;

import de.retest.recheck.meta.MetadataProvider;
import de.retest.recheck.meta.MultiMetadataProvider;
import de.retest.web.meta.driver.capabilities.CapabilityMetadataProvider;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;

public final class WebDriverMetadataProvider
implements MetadataProvider {
    private final WebDriver driver;

    public static MetadataProvider of(WebDriver driver) {
        return MultiMetadataProvider.of((MetadataProvider[])new MetadataProvider[]{CapabilityMetadataProvider.of(driver), new WebDriverMetadataProvider(driver)});
    }

    public Map<String, String> retrieve() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("driver.type", this.driver.getClass().getSimpleName());
        map.put("url", this.driver.getCurrentUrl());
        Dimension size = this.driver.manage().window().getSize();
        map.put("window.width", String.valueOf(size.getWidth()));
        map.put("window.height", String.valueOf(size.getHeight()));
        return map;
    }

    WebDriverMetadataProvider(WebDriver driver) {
        this.driver = driver;
    }
}

