/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.mapping;

import de.retest.web.ConversionException;
import de.retest.web.screenshot.ScreenshotProviders;
import java.awt.Rectangle;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebData {
    private static final Logger logger = LoggerFactory.getLogger(WebData.class);
    private final Map<String, Object> wrappedData;
    private final int scale;

    public WebData(Map<String, Object> wrappedData) {
        this(wrappedData, ScreenshotProviders.SCALE);
    }

    public WebData(Map<String, Object> wrappedData, int scale) {
        this.wrappedData = wrappedData;
        this.scale = scale;
    }

    public String getAsString(String key) {
        Object result = this.wrappedData.get(key);
        if (result == null) {
            return null;
        }
        String value = String.valueOf(result);
        return key.equals("text") ? value : WebData.normalize(value);
    }

    public Set<String> getKeys() {
        return this.wrappedData.keySet();
    }

    protected static String normalize(String value) {
        if (value == null) {
            return value;
        }
        String result = value;
        if (result.startsWith("\"") && result.endsWith("\"")) {
            result = result.substring(1, result.length() - 1);
        }
        return result.trim();
    }

    public Rectangle getAbsoluteOutline() {
        if (this.wrappedData.get("absolute-x") == null || this.wrappedData.get("absolute-y") == null || this.wrappedData.get("absolute-width") == null || this.wrappedData.get("absolute-height") == null) {
            return null;
        }
        try {
            int x = this.getAsInt("absolute-x");
            int y = this.getAsInt("absolute-y");
            int width = this.getAsInt("absolute-width");
            int height = this.getAsInt("absolute-height");
            return new Rectangle(x, y, width, height);
        }
        catch (Exception e) {
            logger.error("Exception retrieving outline: ", (Throwable)e);
            return null;
        }
    }

    public Rectangle getOutline() {
        if (this.wrappedData.get("x") == null || this.wrappedData.get("y") == null || this.wrappedData.get("width") == null || this.wrappedData.get("height") == null) {
            return null;
        }
        try {
            int x = this.getAsInt("x") / this.scale;
            int y = this.getAsInt("y") / this.scale;
            int width = this.getAsInt("width") / this.scale;
            int height = this.getAsInt("height") / this.scale;
            return new Rectangle(x, y, width, height);
        }
        catch (Exception e) {
            logger.error("Exception retrieving outline: ", (Throwable)e);
            return null;
        }
    }

    public int getAsInt(String key) {
        Object value = this.wrappedData.get(key);
        try {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
            if (value instanceof Double) {
                return Math.toIntExact(Math.round((Double)value));
            }
            if (value instanceof Long) {
                return Math.toIntExact((Long)value);
            }
        }
        catch (Exception e) {
            throw new ConversionException("Converting " + value + " of type " + value.getClass() + " to int caused an exception!", e);
        }
        throw new ConversionException("Don't know how to convert " + value + " of " + (value != null ? value.getClass() : "null") + " to int!");
    }

    public boolean isShown() {
        Boolean shown = (Boolean)this.wrappedData.get("shown");
        if (shown != null && !shown.booleanValue()) {
            return false;
        }
        Rectangle outline = this.getOutline();
        return outline != null;
    }

    public boolean isPseudo() {
        Boolean pseudo = (Boolean)this.wrappedData.get("pseudo");
        return pseudo != null && pseudo != false;
    }

    public String getTag() {
        return this.getAsString("tagName");
    }

    public String getText() {
        return this.getAsString("text");
    }
}

