/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web;

import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.Path;
import de.retest.recheck.ui.descriptors.Attributes;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.descriptors.MutableAttributes;
import de.retest.recheck.ui.descriptors.OutlineAttribute;
import de.retest.recheck.ui.descriptors.PathAttribute;
import de.retest.recheck.ui.descriptors.StringAttribute;
import de.retest.recheck.ui.descriptors.SuffixAttribute;
import de.retest.recheck.ui.descriptors.idproviders.RetestIdProvider;
import de.retest.web.AttributesUtil;
import de.retest.web.mapping.WebData;
import de.retest.web.util.TextAttributeUtil;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class WebElementPeer {
    protected final List<WebElementPeer> children = new ArrayList<WebElementPeer>();
    protected final RetestIdProvider retestIdProvider;
    protected final WebData webData;
    private final String path;
    private final DefaultValueFinder defaultValueFinder;

    public WebElementPeer(RetestIdProvider retestIdProvider, WebData webData, String path, DefaultValueFinder defaultValueFinder) {
        this.retestIdProvider = retestIdProvider;
        this.webData = webData;
        this.path = path;
        this.defaultValueFinder = defaultValueFinder;
    }

    public void addChild(WebElementPeer child) {
        this.children.add(child);
    }

    public Element toElement(Element parent) {
        if (this.webData == null) {
            return null;
        }
        IdentifyingAttributes identifyingAttributes = this.retrieveIdentifyingAttributes();
        MutableAttributes stateAttributes = this.retrieveStateAttributes(identifyingAttributes);
        String retestId = this.retestIdProvider.getRetestId(identifyingAttributes);
        Element element = Element.create((String)retestId, (Element)parent, (IdentifyingAttributes)identifyingAttributes, (Attributes)stateAttributes.immutable());
        element.addChildren(this.convertChildren(element));
        return element;
    }

    protected IdentifyingAttributes retrieveIdentifyingAttributes() {
        String text;
        Rectangle outline;
        ArrayList<Object> identifyingAttributes = new ArrayList<Object>();
        Rectangle absoluteOutline = this.webData.getAbsoluteOutline();
        if (absoluteOutline != null) {
            identifyingAttributes.add(OutlineAttribute.createAbsolute((Rectangle)absoluteOutline));
        }
        if ((outline = this.webData.getOutline()) != null) {
            identifyingAttributes.add(OutlineAttribute.create((Rectangle)outline));
        }
        if (StringUtils.isNotBlank((CharSequence)(text = this.webData.getText()))) {
            identifyingAttributes.add(TextAttributeUtil.createTextAttribute(this.path, text));
        }
        List<String> htmlAttributes = Arrays.asList("class", "id", "name");
        for (String key : htmlAttributes) {
            String value = this.webData.getAsString(key);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            identifyingAttributes.add(new StringAttribute(key, value));
        }
        identifyingAttributes.add(new StringAttribute("type", this.webData.getTag()));
        identifyingAttributes.add(new PathAttribute(Path.fromString((String)this.path)));
        identifyingAttributes.add(new SuffixAttribute(this.extractSuffix().intValue()));
        return new IdentifyingAttributes(identifyingAttributes);
    }

    private Integer extractSuffix() {
        String suffix = this.path.substring(this.path.lastIndexOf(91) + 1, this.path.lastIndexOf(93));
        return Integer.valueOf(suffix);
    }

    protected MutableAttributes retrieveStateAttributes(IdentifyingAttributes identifyingAttributes) {
        MutableAttributes state = new MutableAttributes();
        this.webData.getKeys().stream().filter(Objects::nonNull).filter(key -> !AttributesUtil.isIdentifyingAttribute(key) && !this.defaultValueFinder.isDefaultValue(identifyingAttributes, key, (Serializable)((Object)this.webData.getAsString((String)key)))).forEach(key -> state.put(key, this.webData.getAsString((String)key)));
        return state;
    }

    protected List<Element> convertChildren(Element parent) {
        return this.children.stream().map(webElementPeer -> webElementPeer.toElement(parent)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String toString() {
        return this.path;
    }

    public List<WebElementPeer> getChildren() {
        return this.children;
    }
}

