/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web;

import de.retest.recheck.RecheckOptions;
import de.retest.recheck.persistence.NamingStrategy;
import de.retest.recheck.persistence.ProjectLayout;
import de.retest.recheck.ui.descriptors.idproviders.RetestIdProvider;
import de.retest.web.screenshot.ScreenshotProvider;
import de.retest.web.screenshot.ScreenshotProviders;
import de.retest.web.selenium.AutocheckingCheckNamingStrategy;
import de.retest.web.selenium.CounterCheckNamingStrategy;

public class RecheckWebOptions
extends RecheckOptions {
    private final AutocheckingCheckNamingStrategy checkNamingStrategy;
    private final ScreenshotProvider screenshotProvider;
    private final long autocheckingDelayMillis;

    protected RecheckWebOptions(RecheckOptions superOptions, AutocheckingCheckNamingStrategy checkNamingStrategy, ScreenshotProvider screenshotProvider, long autocheckingDelayMillis) {
        super(superOptions);
        this.checkNamingStrategy = checkNamingStrategy;
        this.screenshotProvider = screenshotProvider;
        this.autocheckingDelayMillis = autocheckingDelayMillis;
    }

    public static RecheckWebOptionsBuilder builder() {
        return new RecheckWebOptionsBuilder();
    }

    public AutocheckingCheckNamingStrategy getCheckNamingStrategy() {
        return this.checkNamingStrategy;
    }

    public ScreenshotProvider getScreenshotProvider() {
        return this.screenshotProvider;
    }

    public long getAutocheckingDelayMillis() {
        return this.autocheckingDelayMillis;
    }

    public static class RecheckWebOptionsBuilder
    extends RecheckOptions.RecheckOptionsBuilder {
        private AutocheckingCheckNamingStrategy checkNamingStrategy = new CounterCheckNamingStrategy();
        private ScreenshotProvider screenshotProvider = null;
        private long autocheckingDelayMillis = 0L;

        public RecheckWebOptionsBuilder checkNamingStrategy(AutocheckingCheckNamingStrategy checkNamingStrategy) {
            this.checkNamingStrategy = checkNamingStrategy;
            return this;
        }

        public RecheckWebOptionsBuilder screenshotProvider(ScreenshotProvider screenshotProvider) {
            this.screenshotProvider = screenshotProvider;
            return this;
        }

        public RecheckWebOptionsBuilder disableScreenshots() {
            return this.screenshotProvider(ScreenshotProviders.NONE);
        }

        public RecheckWebOptionsBuilder enableScreenshots() {
            return this.screenshotProvider(ScreenshotProviders.DEFAULT);
        }

        public RecheckWebOptionsBuilder setAutocheckingDelayMillis(long autocheckingDelayMillis) {
            this.autocheckingDelayMillis = autocheckingDelayMillis;
            return this;
        }

        public RecheckWebOptionsBuilder namingStrategy(NamingStrategy namingStrategy) {
            super.namingStrategy(namingStrategy);
            return this;
        }

        public RecheckWebOptionsBuilder projectLayout(ProjectLayout projectLayout) {
            super.projectLayout(projectLayout);
            return this;
        }

        public RecheckWebOptionsBuilder suiteName(String suiteName) {
            super.suiteName(suiteName);
            return this;
        }

        public RecheckWebOptionsBuilder enableReportUpload() {
            super.enableReportUpload();
            return this;
        }

        public RecheckWebOptionsBuilder disableReportUpload() {
            super.disableReportUpload();
            return this;
        }

        public RecheckWebOptionsBuilder setIgnore(String filterName) {
            super.setIgnore(filterName);
            return this;
        }

        public RecheckWebOptionsBuilder ignoreNothing() {
            super.ignoreNothing();
            return this;
        }

        public RecheckWebOptionsBuilder addIgnore(String filterName) {
            super.addIgnore(filterName);
            return this;
        }

        public RecheckWebOptionsBuilder retestIdProvider(RetestIdProvider retestIdProvider) {
            super.retestIdProvider(retestIdProvider);
            return this;
        }

        public RecheckWebOptions build() {
            return new RecheckWebOptions(super.build(), this.checkNamingStrategy, this.screenshotProvider, this.autocheckingDelayMillis);
        }
    }
}

