/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web;

import de.retest.recheck.RecheckAdapter;
import de.retest.recheck.RecheckImpl;
import de.retest.recheck.RecheckOptions;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.descriptors.SutState;
import de.retest.web.selenium.ImplicitDriverWrapper;
import de.retest.web.selenium.UnbreakableDriver;
import de.retest.web.util.SeleniumWrapperUtil;
import java.io.File;

public class RecheckWebImpl
extends RecheckImpl {
    private UnbreakableDriver driver;

    public RecheckWebImpl() {
    }

    public RecheckWebImpl(RecheckOptions opts) {
        super(opts);
    }

    public void check(Object driver, RecheckAdapter seleniumAdapter, String currentStep) {
        this.driver = this.retrieveUnbreakableDriver(driver);
        super.check(driver, seleniumAdapter, currentStep);
    }

    public void check(Object driver, String currentStep) {
        this.driver = this.retrieveUnbreakableDriver(driver);
        super.check(driver, currentStep);
    }

    private UnbreakableDriver retrieveUnbreakableDriver(Object driver) {
        if (driver instanceof ImplicitDriverWrapper) {
            return this.retrieveUnbreakableDriver(((ImplicitDriverWrapper)driver).getWrappedDriver());
        }
        if (driver instanceof UnbreakableDriver) {
            return (UnbreakableDriver)driver;
        }
        if (SeleniumWrapperUtil.isWrapper(SeleniumWrapperUtil.WrapperOf.DRIVER, driver)) {
            return this.retrieveUnbreakableDriver(SeleniumWrapperUtil.getWrapped(SeleniumWrapperUtil.WrapperOf.DRIVER, driver));
        }
        return null;
    }

    public SutState loadExpected(File file) {
        SutState result = super.loadExpected(file);
        if (this.driver == null) {
            throw new IllegalStateException("Must first call a check-method with an UnbreakableDriver before being able to load a Golden Master (needed for unbreakable tests)!");
        }
        if (result != null) {
            this.driver.setLastExpectedState((RootElement)result.getRootElements().get(0));
        }
        return result;
    }

    UnbreakableDriver getDriver() {
        return this.driver;
    }
}

