/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web;

import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class DefaultWebValueFinder
implements DefaultValueFinder {
    public static final String DEFAULTS_FILE_PATH = "/defaults.yaml";
    private static final Set<String> commonDefaults = new HashSet<String>(Arrays.asList("0px", "0px 0px", "auto", "normal", "rgb(0, 0, 0)", "none"));
    private final Map<String, Map<String, String>> defaultValues;

    public DefaultWebValueFinder() {
        try (InputStream url = this.getClass().getResourceAsStream(DEFAULTS_FILE_PATH);){
            this.defaultValues = this.readAttributesConfigFromFile(url);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot read defaults file '/defaults.yaml'.", e);
        }
    }

    private Map<String, Map<String, String>> readAttributesConfigFromFile(InputStream in) throws IOException {
        HashMap<String, Map<String, String>> defaultValues = new HashMap<String, Map<String, String>>();
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(), new Representer(), new DumperOptions(), new LoaderOptions(), new Resolver(){

            public Tag resolve(NodeId kind, String value, boolean implicit) {
                if (kind == NodeId.scalar && implicit) {
                    return Tag.STR;
                }
                return super.resolve(kind, value, implicit);
            }
        });
        Map loaded = (Map)yaml.load(in);
        for (Map.Entry entry : loaded.entrySet()) {
            HashMap defaults = new HashMap();
            ArrayList value = (ArrayList)entry.getValue();
            for (LinkedHashMap linkedHashMap : value) {
                defaults.putAll(linkedHashMap);
            }
            defaultValues.put((String)entry.getKey(), defaults);
        }
        return defaultValues;
    }

    public boolean isDefaultValue(IdentifyingAttributes identifyingAttributes, String attributeKey, Serializable attributeValue) {
        String attributeValueString = attributeValue != null ? attributeValue.toString() : null;
        String defaultValueString = this.getDefaultValue(identifyingAttributes.getType(), attributeKey);
        if (defaultValueString != null) {
            return defaultValueString.equalsIgnoreCase(attributeValueString);
        }
        if (attributeValueString == null || attributeValueString.trim().isEmpty()) {
            return true;
        }
        return commonDefaults.contains(attributeValueString);
    }

    public String getDefaultValue(String tag, String attribute) {
        String defaultValue;
        Map<String, String> defaults = this.defaultValues.get(tag.toLowerCase());
        if (defaults != null && (defaultValue = defaults.get(attribute.toLowerCase())) != null) {
            return defaultValue;
        }
        return this.defaultValues.get("all").get(attribute.toLowerCase());
    }
}

