/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.CompareResult;
import de.redsix.pdfcompare.DiffImage;
import de.redsix.pdfcompare.Exclusions;
import de.redsix.pdfcompare.ResultCollector;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfComparator<T extends CompareResult> {
    private static final Logger LOG = LoggerFactory.getLogger(PdfComparator.class);
    private static final int DPI = 300;
    private static final int EXTRA_RGB = new Color(0, 160, 0).getRGB();
    private static final int MISSING_RGB = new Color(220, 0, 0).getRGB();
    public static final int MARKER_WIDTH = 20;
    private final Exclusions exclusions = new Exclusions();
    private InputStreamSupplier expectedStreamSupplier;
    private InputStreamSupplier actualStreamSupplier;
    private Executor executor;
    private final T compareResult;

    private PdfComparator(T compareResult) {
        Objects.requireNonNull(compareResult, "compareResult is null");
        this.compareResult = compareResult;
    }

    public PdfComparator(String expectedPdfFilename, String actualPdfFilename) throws IOException {
        this(expectedPdfFilename, actualPdfFilename, new CompareResult());
    }

    public PdfComparator(String expectedPdfFilename, String actualPdfFilename, T compareResult) throws IOException {
        this(compareResult);
        Objects.requireNonNull(expectedPdfFilename, "expectedPdfFilename is null");
        Objects.requireNonNull(actualPdfFilename, "actualPdfFilename is null");
        if (!expectedPdfFilename.equals(actualPdfFilename)) {
            this.expectedStreamSupplier = () -> Files.newInputStream(Paths.get(expectedPdfFilename, new String[0]), new OpenOption[0]);
            this.actualStreamSupplier = () -> Files.newInputStream(Paths.get(actualPdfFilename, new String[0]), new OpenOption[0]);
        }
    }

    public PdfComparator(Path expectedPath, Path actualPath) throws IOException {
        this(expectedPath, actualPath, new CompareResult());
    }

    public PdfComparator(Path expectedPath, Path actualPath, T compareResult) throws IOException {
        this(compareResult);
        Objects.requireNonNull(expectedPath, "expectedPath is null");
        Objects.requireNonNull(actualPath, "actualPath is null");
        if (!expectedPath.equals(actualPath)) {
            this.expectedStreamSupplier = () -> Files.newInputStream(expectedPath, new OpenOption[0]);
            this.actualStreamSupplier = () -> Files.newInputStream(actualPath, new OpenOption[0]);
        }
    }

    public PdfComparator(File expectedFile, File actualFile) throws IOException {
        this(expectedFile, actualFile, new CompareResult());
    }

    public PdfComparator(File expectedFile, File actualFile, T compareResult) throws IOException {
        this(compareResult);
        Objects.requireNonNull(expectedFile, "expectedFile is null");
        Objects.requireNonNull(actualFile, "actualFile is null");
        if (!expectedFile.equals(actualFile)) {
            this.expectedStreamSupplier = () -> new FileInputStream(expectedFile);
            this.actualStreamSupplier = () -> new FileInputStream(actualFile);
        }
    }

    public PdfComparator(InputStream expectedPdfIS, InputStream actualPdfIS) {
        this(expectedPdfIS, actualPdfIS, new CompareResult());
    }

    public PdfComparator(InputStream expectedPdfIS, InputStream actualPdfIS, T compareResult) {
        this(compareResult);
        Objects.requireNonNull(expectedPdfIS, "expectedPdfIS is null");
        Objects.requireNonNull(actualPdfIS, "actualPdfIS is null");
        if (!expectedPdfIS.equals(actualPdfIS)) {
            this.expectedStreamSupplier = () -> expectedPdfIS;
            this.actualStreamSupplier = () -> actualPdfIS;
        }
    }

    public PdfComparator<T> withIgnore(String ignoreFilename) {
        Objects.requireNonNull(ignoreFilename, "ignoreFilename is null");
        this.exclusions.readExclusions(ignoreFilename);
        return this;
    }

    public PdfComparator<T> withIgnore(File ignoreFile) {
        Objects.requireNonNull(ignoreFile, "ignoreFile is null");
        this.exclusions.readExclusions(ignoreFile);
        return this;
    }

    public PdfComparator<T> withIgnore(Path ignorePath) {
        Objects.requireNonNull(ignorePath, "ignorePath is null");
        this.exclusions.readExclusions(ignorePath);
        return this;
    }

    public PdfComparator<T> withIgnore(InputStream ignoreIS) {
        Objects.requireNonNull(ignoreIS, "ignoreIS is null");
        this.exclusions.readExclusions(ignoreIS);
        return this;
    }

    public PdfComparator<T> withExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T compare() throws IOException {
        try {
            if (this.expectedStreamSupplier == null && this.actualStreamSupplier == null) {
                T t = this.compareResult;
                return t;
            }
            ExecutorService executorService = null;
            if (this.executor == null) {
                executorService = Executors.newSingleThreadExecutor();
                this.executor = executorService;
            }
            AtomicInteger jobs = new AtomicInteger();
            try (InputStream expectedStream = this.expectedStreamSupplier.get();){
                try (InputStream actualStream = this.actualStreamSupplier.get();
                     PDDocument expectedDocument = PDDocument.load((InputStream)expectedStream);){
                    PDFRenderer expectedPdfRenderer = new PDFRenderer(expectedDocument);
                    try (PDDocument actualDocument = PDDocument.load((InputStream)actualStream);){
                        PDFRenderer actualPdfRenderer = new PDFRenderer(actualDocument);
                        int minPageCount = Math.min(expectedDocument.getNumberOfPages(), actualDocument.getNumberOfPages());
                        for (int pageIndex = 0; pageIndex < minPageCount; ++pageIndex) {
                            BufferedImage expectedImage = this.renderPageAsImage(expectedPdfRenderer, pageIndex);
                            BufferedImage actualImage = this.renderPageAsImage(actualPdfRenderer, pageIndex);
                            this.compare(jobs, expectedImage, actualImage, pageIndex);
                        }
                        if (expectedDocument.getNumberOfPages() > minPageCount) {
                            this.addExtraPages(expectedDocument, expectedPdfRenderer, minPageCount, MISSING_RGB, true);
                        } else if (actualDocument.getNumberOfPages() > minPageCount) {
                            this.addExtraPages(actualDocument, actualPdfRenderer, minPageCount, EXTRA_RGB, false);
                        }
                    }
                }
                catch (NoSuchFileException ex) {
                    this.addSingleDocumentToResult(expectedStream, MISSING_RGB);
                }
            }
            catch (NoSuchFileException ex) {
                try (InputStream actualStream = this.actualStreamSupplier.get();){
                    this.addSingleDocumentToResult(actualStream, EXTRA_RGB);
                }
                catch (NoSuchFileException innerEx) {
                    LOG.warn("No files found to compare. Tried Expected: '{}' and Actual: '{}'", (Object)ex.getFile(), (Object)innerEx.getFile());
                    ((CompareResult)this.compareResult).noPagesFound();
                }
            }
            if (executorService != null) {
                executorService.shutdown();
                this.executor = null;
            }
            AtomicInteger atomicInteger = jobs;
            synchronized (atomicInteger) {
                while (jobs.get() > 0) {
                    try {
                        jobs.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        finally {
            this.compareResult.done();
        }
        return this.compareResult;
    }

    private void addSingleDocumentToResult(InputStream expectedPdfIS, int markerColor) throws IOException {
        try (PDDocument expectedDocument = PDDocument.load((InputStream)expectedPdfIS);){
            PDFRenderer expectedPdfRenderer = new PDFRenderer(expectedDocument);
            this.addExtraPages(expectedDocument, expectedPdfRenderer, 0, markerColor, true);
        }
    }

    private void addExtraPages(PDDocument document, PDFRenderer pdfRenderer, int minPageCount, int color, boolean expected) throws IOException {
        for (int pageIndex = minPageCount; pageIndex < document.getNumberOfPages(); ++pageIndex) {
            int i;
            BufferedImage image = this.renderPageAsImage(pdfRenderer, pageIndex);
            DataBuffer dataBuffer = image.getRaster().getDataBuffer();
            for (i = 0; i < image.getWidth() * 20; ++i) {
                dataBuffer.setElem(i, color);
            }
            for (i = 0; i < image.getHeight(); ++i) {
                for (int j = 0; j < 20; ++j) {
                    dataBuffer.setElem(i * image.getWidth() + j, color);
                }
            }
            if (expected) {
                ((CompareResult)this.compareResult).addPage(true, false, pageIndex, image, PdfComparator.blank(image), image);
                continue;
            }
            ((CompareResult)this.compareResult).addPage(true, false, pageIndex, PdfComparator.blank(image), image, image);
        }
    }

    private static BufferedImage blank(BufferedImage image) {
        return new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
    }

    private BufferedImage renderPageAsImage(PDFRenderer expectedPdfRenderer, int pageIndex) throws IOException {
        return expectedPdfRenderer.renderImageWithDPI(pageIndex, 300.0f);
    }

    private void compare(AtomicInteger jobs, BufferedImage expectedImage, BufferedImage actualImage, int pageIndex) {
        DiffImage diffImage = new DiffImage(expectedImage, actualImage, pageIndex, this.exclusions, (ResultCollector)this.compareResult);
        jobs.incrementAndGet();
        this.executor.execute(() -> {
            try {
                diffImage.diffImages();
            }
            catch (Exception e) {
                LOG.error("Exception while diffing Images", (Throwable)e);
            }
            finally {
                AtomicInteger atomicInteger = jobs;
                synchronized (atomicInteger) {
                    int i = jobs.decrementAndGet();
                    if (i == 0) {
                        jobs.notify();
                    }
                }
            }
        });
    }

    public T getResult() {
        return this.compareResult;
    }

    @FunctionalInterface
    private static interface InputStreamSupplier {
        public InputStream get() throws IOException;
    }
}

