/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.PageArea;
import java.util.Objects;

public class PageDiffCalculator {
    private final int totalPixels;
    private final double allowedDiffInPercent;
    private int diffsFound = 0;
    private int diffsFoundInExclusion = 0;
    private PageArea diffArea;

    public PageDiffCalculator(int totalPixels, double allowedDiffInPercent) {
        this.totalPixels = totalPixels;
        this.allowedDiffInPercent = allowedDiffInPercent;
    }

    public PageDiffCalculator(PageArea diffArea) {
        this.totalPixels = 0;
        this.allowedDiffInPercent = 0.0;
        this.diffsFound = 1;
        this.diffArea = diffArea;
    }

    public void diffFound() {
        ++this.diffsFound;
    }

    public void diffFoundInExclusion() {
        ++this.diffsFoundInExclusion;
    }

    public boolean differencesFound() {
        double allowedDiffInPixels = this.totalPixels == 0 ? 0.0 : (double)this.totalPixels * this.allowedDiffInPercent / 100.0;
        return (double)this.diffsFound > allowedDiffInPixels;
    }

    public boolean differencesFoundInExclusion() {
        return this.diffsFoundInExclusion > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PageDiffCalculator)) {
            return false;
        }
        PageDiffCalculator that = (PageDiffCalculator)o;
        return this.diffsFound == that.diffsFound && this.diffsFoundInExclusion == that.diffsFoundInExclusion;
    }

    public int hashCode() {
        return Objects.hash(this.diffsFound, this.diffsFoundInExclusion);
    }

    public void addDiffArea(PageArea diffArea) {
        this.diffArea = diffArea;
    }

    public PageArea getDiffArea() {
        return this.diffArea;
    }
}

