/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare.env;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import de.redsix.pdfcompare.env.Environment;
import java.awt.Color;
import java.io.File;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public class ConfigFileEnvironment
implements Environment {
    private static final ConfigParseOptions CONFIG_PARSE_OPTIONS = ConfigParseOptions.defaults();
    private final Config config;

    public ConfigFileEnvironment(Path path) {
        Objects.requireNonNull(path, "path is null");
        this.config = ConfigFactory.parseFile((File)path.toFile(), (ConfigParseOptions)CONFIG_PARSE_OPTIONS);
    }

    public ConfigFileEnvironment(File file) {
        Objects.requireNonNull(file, "file is null");
        this.config = ConfigFactory.parseFile((File)file, (ConfigParseOptions)CONFIG_PARSE_OPTIONS);
    }

    public ConfigFileEnvironment(Reader reader) {
        Objects.requireNonNull(reader, "reader is null");
        this.config = ConfigFactory.parseReader((Reader)reader, (ConfigParseOptions)CONFIG_PARSE_OPTIONS);
    }

    public ConfigFileEnvironment(Config config) {
        Objects.requireNonNull(config, "config is null");
        this.config = config;
    }

    @Override
    public Path getTempDirectory() {
        if (this.config.hasPath("tempDir")) {
            return Paths.get(this.config.getString("tempDir"), new String[0]);
        }
        return Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    @Override
    public int getNrOfImagesToCache() {
        return this.config.getInt("imageCacheSizeCount");
    }

    @Override
    public int getMergeCacheSize() {
        return this.getMB("mergeCacheSizeMB");
    }

    @Override
    public int getSwapCacheSize() {
        return this.getMB("swapCacheSizeMB");
    }

    @Override
    public int getDocumentCacheSize() {
        return this.getMB("documentCacheSizeMB") / 2;
    }

    @Override
    public int getMaxImageSize() {
        return this.config.getInt("maxImageSizeInCache");
    }

    @Override
    public int getOverallTimeout() {
        return this.config.getInt("overallTimeoutInMinutes");
    }

    @Override
    public boolean useParallelProcessing() {
        return this.config.getBoolean("parallelProcessing");
    }

    @Override
    public double getAllowedDiffInPercent() {
        if (this.config.hasPath("allowedDifferenceInPercentPerPage")) {
            return this.config.getDouble("allowedDifferenceInPercentPerPage");
        }
        return 0.0;
    }

    @Override
    public Color getExpectedColor() {
        if (this.config.hasPath("expectedColor")) {
            return Color.decode("#" + this.config.getString("expectedColor"));
        }
        return new Color(0, 180, 0);
    }

    @Override
    public Color getActualColor() {
        if (this.config.hasPath("actualColor")) {
            return Color.decode("#" + this.config.getString("actualColor"));
        }
        return new Color(210, 0, 0);
    }

    private int getMB(String path) {
        return this.config.getInt(path) * 1024 * 1024;
    }
}

