/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.Exclusions;
import de.redsix.pdfcompare.ImageTools;
import de.redsix.pdfcompare.ImageWithDimension;
import de.redsix.pdfcompare.PageDiffCalculator;
import de.redsix.pdfcompare.PageExclusions;
import de.redsix.pdfcompare.ResultCollector;
import de.redsix.pdfcompare.env.Environment;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffImage {
    private static final Logger LOG = LoggerFactory.getLogger(DiffImage.class);
    static final int MARKER_RGB = DiffImage.color(230, 0, 230);
    private final ImageWithDimension expectedImage;
    private final ImageWithDimension actualImage;
    private final int page;
    private final Environment environment;
    private final Exclusions exclusions;
    private DataBuffer expectedBuffer;
    private DataBuffer actualBuffer;
    private int expectedImageWidth;
    private int expectedImageHeight;
    private int actualImageWidth;
    private int actualImageHeight;
    private int resultImageWidth;
    private int resultImageHeight;
    private BufferedImage resultImage;
    private int diffAreaX1;
    private int diffAreaY1;
    private int diffAreaX2;
    private int diffAreaY2;
    private final ResultCollector compareResult;
    private PageDiffCalculator diffCalculator;

    public DiffImage(ImageWithDimension expectedImage, ImageWithDimension actualImage, int page, Environment environment, Exclusions exclusions, ResultCollector compareResult) {
        this.expectedImage = expectedImage;
        this.actualImage = actualImage;
        this.page = page;
        this.environment = environment;
        this.exclusions = exclusions;
        this.compareResult = compareResult;
    }

    public BufferedImage getImage() {
        return this.resultImage;
    }

    public void diffImages() {
        BufferedImage expectBuffImage = this.expectedImage.bufferedImage;
        BufferedImage actualBuffImage = this.actualImage.bufferedImage;
        this.expectedBuffer = expectBuffImage.getRaster().getDataBuffer();
        this.actualBuffer = actualBuffImage.getRaster().getDataBuffer();
        this.expectedImageWidth = expectBuffImage.getWidth();
        this.expectedImageHeight = expectBuffImage.getHeight();
        this.actualImageWidth = actualBuffImage.getWidth();
        this.actualImageHeight = actualBuffImage.getHeight();
        this.resultImageWidth = Math.max(this.expectedImageWidth, this.actualImageWidth);
        this.resultImageHeight = Math.max(this.expectedImageHeight, this.actualImageHeight);
        this.resultImage = new BufferedImage(this.resultImageWidth, this.resultImageHeight, actualBuffImage.getType());
        DataBuffer resultBuffer = this.resultImage.getRaster().getDataBuffer();
        this.diffCalculator = new PageDiffCalculator(this.resultImageWidth * this.resultImageHeight, this.environment.getAllowedDiffInPercent());
        PageExclusions pageExclusions = this.exclusions.forPage(this.page + 1);
        for (int y = 0; y < this.resultImageHeight; ++y) {
            int expectedLineOffset = y * this.expectedImageWidth;
            int actualLineOffset = y * this.actualImageWidth;
            int resultLineOffset = y * this.resultImageWidth;
            for (int x = 0; x < this.resultImageWidth; ++x) {
                int expectedElement = this.getExpectedElement(x, y, expectedLineOffset);
                int actualElement = this.getActualElement(x, y, actualLineOffset);
                int element = this.getElement(expectedElement, actualElement);
                if (pageExclusions.contains(x, y)) {
                    element = ImageTools.fadeExclusion(element);
                    if (expectedElement != actualElement) {
                        this.diffCalculator.diffFoundInExclusion();
                    }
                } else if (expectedElement != actualElement) {
                    this.extendDiffArea(x, y);
                    this.diffCalculator.diffFound();
                    LOG.trace("Difference found on page: {} at x: {}, y: {}", new Object[]{this.page + 1, x, y});
                    DiffImage.mark(resultBuffer, x, y, this.resultImageWidth, MARKER_RGB);
                }
                resultBuffer.setElem(x + resultLineOffset, element);
            }
        }
        if (this.diffCalculator.differencesFound()) {
            LOG.info("Differences found at { page: {}, x1: {}, y1: {}, x2: {}, y2: {} }", new Object[]{this.page + 1, this.diffAreaX1, this.diffAreaY1, this.diffAreaX2, this.diffAreaY2});
        }
        float maxWidth = Math.max(this.expectedImage.width, this.actualImage.width);
        float maxHeight = Math.max(this.expectedImage.height, this.actualImage.height);
        this.compareResult.addPage(this.diffCalculator, this.page, this.expectedImage, this.actualImage, new ImageWithDimension(this.resultImage, maxWidth, maxHeight));
    }

    private void extendDiffArea(int x, int y) {
        if (!this.diffCalculator.differencesFound()) {
            this.diffAreaX1 = x;
            this.diffAreaY1 = y;
        }
        this.diffAreaX1 = Math.min(this.diffAreaX1, x);
        this.diffAreaX2 = Math.max(this.diffAreaX2, x);
        this.diffAreaY1 = Math.min(this.diffAreaY1, y);
        this.diffAreaY2 = Math.max(this.diffAreaY2, y);
    }

    private int getElement(int expectedElement, int actualElement) {
        if (expectedElement != actualElement) {
            int actualDarkness;
            int expectedDarkness = DiffImage.calcCombinedIntensity(expectedElement);
            if (expectedDarkness > (actualDarkness = DiffImage.calcCombinedIntensity(actualElement))) {
                return DiffImage.color(DiffImage.levelIntensity(expectedDarkness, 210), 0, 0);
            }
            return DiffImage.color(0, DiffImage.levelIntensity(actualDarkness, 180), 0);
        }
        return ImageTools.fadeElement(expectedElement);
    }

    private int getExpectedElement(int x, int y, int expectedLineOffset) {
        if (x < this.expectedImageWidth && y < this.expectedImageHeight) {
            return this.expectedBuffer.getElem(x + expectedLineOffset);
        }
        return 0;
    }

    private int getActualElement(int x, int y, int actualLineOffset) {
        if (x < this.actualImageWidth && y < this.actualImageHeight) {
            return this.actualBuffer.getElem(x + actualLineOffset);
        }
        return 0;
    }

    private static int levelIntensity(int darkness, int maxIntensity) {
        return Math.min(maxIntensity, Math.max(50, darkness));
    }

    private static int calcCombinedIntensity(int element) {
        Color color = new Color(element);
        return Math.min(255, (color.getRed() + color.getGreen() + color.getRed()) / 3);
    }

    private static void mark(DataBuffer image, int x, int y, int imageWidth, int markerRGB) {
        int yOffset = y * imageWidth;
        for (int i = 0; i < 20; ++i) {
            image.setElem(x + i * imageWidth, markerRGB);
            image.setElem(i + yOffset, markerRGB);
        }
    }

    public static int color(int r, int g, int b) {
        return new Color(r, g, b).getRGB();
    }

    public String toString() {
        return "DiffImage{page=" + this.page + '}';
    }
}

