/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import de.redsix.pdfcompare.Exclusion;
import de.redsix.pdfcompare.PageExclusions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Exclusions {
    private static final float CM_TO_PIXEL = 118.11024f;
    private static final float MM_TO_PIXEL = 11.811024f;
    private static final float PT_TO_PIXEL = 4.1666665f;
    private static final Pattern NUMBER = Pattern.compile("([0-9.]+)(cm|mm|pt)");
    private static final ConfigParseOptions configParseOptions = ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF).setAllowMissing(true);
    private final Map<Integer, PageExclusions> exclusionsPerPage = new HashMap<Integer, PageExclusions>();
    private final PageExclusions exclusionsForAllPages = new PageExclusions();

    public Exclusions add(Exclusion exclusion) {
        if (exclusion.page < 0) {
            this.exclusionsForAllPages.add(exclusion);
        } else {
            this.exclusionsPerPage.computeIfAbsent(exclusion.page, k -> new PageExclusions(this.exclusionsForAllPages)).add(exclusion);
        }
        return this;
    }

    public PageExclusions forPage(int page) {
        return this.exclusionsPerPage.getOrDefault(page, this.exclusionsForAllPages);
    }

    public void readExclusions(String filename) {
        if (filename != null) {
            this.readExclusions(new File(filename));
        }
    }

    public void readExclusions(Path path) {
        if (path != null && Files.exists(path, new LinkOption[0])) {
            this.readExclusions(path.toFile());
        }
    }

    public void readExclusions(File file) {
        if (file != null && file.exists()) {
            Config config = ConfigFactory.parseFile((File)file, (ConfigParseOptions)configParseOptions);
            this.readFromConfig(config);
        }
    }

    public void readExclusions(InputStream inputStream) {
        if (inputStream != null) {
            try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                this.readExclusions(inputStreamReader);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void readExclusions(Reader reader) {
        if (reader != null) {
            Config config = ConfigFactory.parseReader((Reader)reader, (ConfigParseOptions)configParseOptions);
            this.readFromConfig(config);
        }
    }

    private void readFromConfig(Config load) {
        List exclusions = load.getObjectList("exclusions");
        exclusions.stream().map(co -> {
            Config c = co.toConfig();
            if (!(c.hasPath("x1") || c.hasPath("y1") || c.hasPath("x2") || c.hasPath("y2"))) {
                return new Exclusion(c.getInt("page"));
            }
            if (c.hasPath("page")) {
                return new Exclusion(c.getInt("page"), this.toPix(c, "x1"), this.toPix(c, "y1"), this.toPix(c, "x2"), this.toPix(c, "y2"));
            }
            return new Exclusion(this.toPix(c, "x1"), this.toPix(c, "y1"), this.toPix(c, "x2"), this.toPix(c, "y2"));
        }).forEach((? super T e) -> this.add((Exclusion)e));
    }

    private int toPix(Config c, String key) {
        try {
            return c.getInt(key);
        }
        catch (ConfigException.WrongType e) {
            String valueStr = c.getString(key);
            Matcher matcher = NUMBER.matcher(valueStr);
            if (matcher.matches()) {
                float factor = 0.0f;
                if ("mm".equals(matcher.group(2))) {
                    factor = 11.811024f;
                } else if ("cm".equals(matcher.group(2))) {
                    factor = 118.11024f;
                } else if ("pt".equals(matcher.group(2))) {
                    factor = 4.1666665f;
                }
                return Math.round(factor * Float.parseFloat(matcher.group(1)));
            }
            throw new RuntimeException("Exclusion can't be read. String not parsable to a number: " + valueStr);
        }
    }

    public void forEach(Consumer<Exclusion> exclusionConsumer) {
        this.exclusionsForAllPages.forEach(exclusionConsumer);
        this.exclusionsPerPage.values().forEach((? super T pe) -> pe.forEach(exclusionConsumer));
    }
}

