/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import de.redsix.pdfcompare.Exclusion;
import de.redsix.pdfcompare.PageExclusions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Exclusions {
    static final ConfigParseOptions configParseOptions = ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF).setAllowMissing(true);
    private final Map<Integer, PageExclusions> exclusionsPerPage = new HashMap<Integer, PageExclusions>();

    public void add(Exclusion exclusion) {
        this.exclusionsPerPage.computeIfAbsent(exclusion.page, k -> new PageExclusions()).add(exclusion);
    }

    public boolean contains(int page, int x, int y) {
        PageExclusions exclusionsThisPage = this.exclusionsPerPage.get(page);
        if (exclusionsThisPage != null) {
            return exclusionsThisPage.contains(x, y);
        }
        return false;
    }

    public PageExclusions forPage(int page) {
        return this.exclusionsPerPage.getOrDefault(page, new PageExclusions());
    }

    public void readExclusions(String filename) {
        if (filename != null) {
            this.readExclusions(new File(filename));
        }
    }

    public void readExclusions(Path path) {
        if (path != null && Files.exists(path, new LinkOption[0])) {
            this.readExclusions(path.toFile());
        }
    }

    public void readExclusions(File file) {
        if (file != null && file.exists()) {
            Config config = ConfigFactory.parseFile((File)file, (ConfigParseOptions)configParseOptions);
            this.readFromConfig(config);
        }
    }

    public void readExclusions(InputStream inputStream) {
        if (inputStream != null) {
            try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                this.readExclusions(inputStreamReader);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void readExclusions(Reader reader) {
        if (reader != null) {
            Config config = ConfigFactory.parseReader((Reader)reader, (ConfigParseOptions)configParseOptions);
            this.readFromConfig(config);
        }
    }

    private void readFromConfig(Config load) {
        List exclusions = load.getObjectList("exclusions");
        exclusions.stream().map(co -> {
            Config c = co.toConfig();
            return new Exclusion(c.getInt("page"), c.getInt("x1"), c.getInt("y1"), c.getInt("x2"), c.getInt("y2"));
        }).forEach(e -> this.add((Exclusion)e));
    }
}

