/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

public class Exclusion {
    final int page;
    private final int x1;
    private final int y1;
    private final int x2;
    private final int y2;

    public Exclusion(int page) {
        this.page = page - 1;
        this.x1 = -1;
        this.y1 = -1;
        this.x2 = -1;
        this.y2 = -1;
    }

    public Exclusion(int x1, int y1, int x2, int y2) {
        this.checkCoordinates(x1, y1, x2, y2);
        this.page = -1;
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    private void checkCoordinates(int x1, int y1, int x2, int y2) {
        if (x1 < 0 || x2 < 0 || y1 < 0 || y2 < 0) {
            throw new IllegalArgumentException("Coordinates have to be greater than 0");
        }
        if (x1 > x2 || y1 > y2) {
            throw new IllegalArgumentException("x1 has to be smaller or equal to x2 and y1 has to be smaller or equal to y2");
        }
    }

    public Exclusion(int page, int x1, int y1, int x2, int y2) {
        this.checkCoordinates(x1, y1, x2, y2);
        if (page < 1) {
            throw new IllegalArgumentException("Page has to be greater or equal to 1");
        }
        this.page = page - 1;
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public boolean contains(int x, int y) {
        if (this.x1 == -1 && this.y1 == -1 && this.x2 == -1 && this.y2 == -1) {
            return true;
        }
        return x >= this.x1 && x <= this.x2 && y >= this.y1 && y <= this.y2;
    }
}

