/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.CompareResult;
import de.redsix.pdfcompare.Exclusions;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfComparator<T extends CompareResult> {
    private static final Logger LOG = LoggerFactory.getLogger(PdfComparator.class);
    private static final int DPI = 300;
    private static final int MARKER_RGB = Color.MAGENTA.getRGB();
    private static final int EXTRA_RGB = Color.GREEN.getRGB();
    private static final int MISSING_RGB = Color.RED.getRGB();
    private static final int MARKER_WIDTH = 20;
    private final Exclusions exclusions = new Exclusions();
    private final T compareResult;

    public PdfComparator() {
        this.compareResult = new CompareResult();
    }

    public PdfComparator(T compareResult) {
        this.compareResult = compareResult;
    }

    public T compare(String expectedPdfFilename, String actualPdfFilename) throws IOException {
        Objects.requireNonNull(expectedPdfFilename, "expectedPdfFilename is null");
        Objects.requireNonNull(actualPdfFilename, "actualPdfFilename is null");
        return this.compare(new File(expectedPdfFilename), new File(actualPdfFilename));
    }

    public T compare(String expectedPdfFilename, String actualPdfFilename, String ignoreFilename) throws IOException {
        Objects.requireNonNull(ignoreFilename, "ignoreFilename is null");
        this.exclusions.readExclusions(ignoreFilename);
        return this.compare(expectedPdfFilename, actualPdfFilename);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public T compare(Path expectedPath, Path actualPath) throws IOException {
        Objects.requireNonNull(expectedPath, "expectedPath is null");
        Objects.requireNonNull(actualPath, "actualPath is null");
        if (expectedPath.equals(actualPath)) {
            return this.compareResult;
        }
        try {
            Throwable throwable = null;
            try (InputStream expectedPdfIS = Files.newInputStream(expectedPath, new OpenOption[0]);){
                T t;
                Throwable throwable2;
                InputStream actualPdfIS;
                block44: {
                    block45: {
                        actualPdfIS = Files.newInputStream(actualPath, new OpenOption[0]);
                        throwable2 = null;
                        t = this.compare(expectedPdfIS, actualPdfIS);
                        if (actualPdfIS == null) break block44;
                        if (throwable2 == null) break block45;
                        try {
                            actualPdfIS.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block44;
                    }
                    actualPdfIS.close();
                }
                return t;
                catch (Throwable throwable4) {
                    try {
                        try {
                            try {
                                throwable2 = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (actualPdfIS != null) {
                                    if (throwable2 != null) {
                                        try {
                                            actualPdfIS.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable2.addSuppressed(throwable6);
                                        }
                                    } else {
                                        actualPdfIS.close();
                                    }
                                }
                                throw throwable5;
                            }
                        }
                        catch (NoSuchFileException ex) {
                            this.addSingleDocumentToResult(expectedPdfIS, MISSING_RGB);
                            throwable2 = (Throwable)this.compareResult;
                            return (T)throwable2;
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    catch (Throwable throwable8) {
                        throw throwable8;
                    }
                }
            }
        }
        catch (NoSuchFileException ex) {
            if (Files.exists(actualPath, new LinkOption[0])) {
                try (InputStream actualPdfIS = Files.newInputStream(actualPath, new OpenOption[0]);){
                    this.addSingleDocumentToResult(actualPdfIS, EXTRA_RGB);
                }
            }
            return this.compareResult;
        }
    }

    public T compare(Path expectedPath, Path actualPath, Path ignorePath) throws IOException {
        Objects.requireNonNull(ignorePath, "ignorePath is null");
        this.exclusions.readExclusions(ignorePath);
        return this.compare(expectedPath, actualPath);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public T compare(File expectedFile, File actualFile) throws IOException {
        Objects.requireNonNull(expectedFile, "expectedFile is null");
        Objects.requireNonNull(actualFile, "actualFile is null");
        if (expectedFile.equals(actualFile)) {
            return this.compareResult;
        }
        try {
            Throwable throwable = null;
            try (FileInputStream expectedPdfIS = new FileInputStream(expectedFile);){
                T t;
                Throwable throwable2;
                FileInputStream actualPdfIS;
                block44: {
                    block45: {
                        actualPdfIS = new FileInputStream(actualFile);
                        throwable2 = null;
                        t = this.compare(expectedPdfIS, actualPdfIS);
                        if (actualPdfIS == null) break block44;
                        if (throwable2 == null) break block45;
                        try {
                            ((InputStream)actualPdfIS).close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block44;
                    }
                    ((InputStream)actualPdfIS).close();
                }
                return t;
                catch (Throwable throwable4) {
                    try {
                        try {
                            try {
                                throwable2 = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (actualPdfIS != null) {
                                    if (throwable2 != null) {
                                        try {
                                            ((InputStream)actualPdfIS).close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable2.addSuppressed(throwable6);
                                        }
                                    } else {
                                        ((InputStream)actualPdfIS).close();
                                    }
                                }
                                throw throwable5;
                            }
                        }
                        catch (NoSuchFileException ex) {
                            this.addSingleDocumentToResult(expectedPdfIS, MISSING_RGB);
                            throwable2 = (Throwable)this.compareResult;
                            return (T)throwable2;
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    catch (Throwable throwable8) {
                        throw throwable8;
                    }
                }
            }
        }
        catch (NoSuchFileException ex) {
            if (actualFile.exists()) {
                try (FileInputStream actualPdfIS = new FileInputStream(actualFile);){
                    this.addSingleDocumentToResult(actualPdfIS, EXTRA_RGB);
                }
            }
            return this.compareResult;
        }
    }

    public T compare(File expectedFile, File actualFile, File ignoreFile) throws IOException {
        Objects.requireNonNull(ignoreFile, "ignoreFile is null");
        this.exclusions.readExclusions(ignoreFile);
        return this.compare(expectedFile, actualFile);
    }

    public T compare(InputStream expectedPdfIS, InputStream actualPdfIS, InputStream ignoreIS) throws IOException {
        Objects.requireNonNull(ignoreIS, "ignoreIS is null");
        this.exclusions.readExclusions(ignoreIS);
        return this.compare(expectedPdfIS, actualPdfIS);
    }

    private void addSingleDocumentToResult(InputStream expectedPdfIS, int markerColor) throws IOException {
        try (PDDocument expectedDocument = PDDocument.load((InputStream)expectedPdfIS);){
            PDFRenderer expectedPdfRenderer = new PDFRenderer(expectedDocument);
            this.addExtraPages(expectedDocument, expectedPdfRenderer, 0, markerColor, true);
        }
    }

    public T compare(InputStream expectedPdfIS, InputStream actualPdfIS) throws IOException {
        Objects.requireNonNull(expectedPdfIS, "expectedPdfIS is null");
        Objects.requireNonNull(actualPdfIS, "actualPdfIS is null");
        if (expectedPdfIS.equals(actualPdfIS)) {
            return this.compareResult;
        }
        try (PDDocument expectedDocument = PDDocument.load((InputStream)expectedPdfIS);){
            PDFRenderer expectedPdfRenderer = new PDFRenderer(expectedDocument);
            try (PDDocument actualDocument = PDDocument.load((InputStream)actualPdfIS);){
                PDFRenderer actualPdfRenderer = new PDFRenderer(actualDocument);
                int minPageCount = Math.min(expectedDocument.getNumberOfPages(), actualDocument.getNumberOfPages());
                for (int pageIndex = 0; pageIndex < minPageCount; ++pageIndex) {
                    BufferedImage expectedImage = this.renderPageAsImage(expectedPdfRenderer, pageIndex);
                    BufferedImage actualImage = this.renderPageAsImage(actualPdfRenderer, pageIndex);
                    this.compare(expectedImage, actualImage, pageIndex);
                }
                if (expectedDocument.getNumberOfPages() > minPageCount) {
                    this.addExtraPages(expectedDocument, expectedPdfRenderer, minPageCount, MISSING_RGB, true);
                } else if (actualDocument.getNumberOfPages() > minPageCount) {
                    this.addExtraPages(actualDocument, actualPdfRenderer, minPageCount, EXTRA_RGB, false);
                }
            }
        }
        return this.compareResult;
    }

    public static BufferedImage deepCopy(BufferedImage image) {
        return new BufferedImage(image.getColorModel(), image.copyData(null), image.getColorModel().isAlphaPremultiplied(), null);
    }

    private void addExtraPages(PDDocument document, PDFRenderer pdfRenderer, int minPageCount, int color, boolean expected) throws IOException {
        for (int pageIndex = minPageCount; pageIndex < document.getNumberOfPages(); ++pageIndex) {
            int i;
            BufferedImage image = this.renderPageAsImage(pdfRenderer, pageIndex);
            DataBuffer dataBuffer = image.getRaster().getDataBuffer();
            for (i = 0; i < image.getWidth() * 20; ++i) {
                dataBuffer.setElem(i, color);
            }
            for (i = 0; i < image.getHeight(); ++i) {
                for (int j = 0; j < 20; ++j) {
                    dataBuffer.setElem(i * image.getWidth() + j, color);
                }
            }
            if (expected) {
                ((CompareResult)this.compareResult).addPageThatsNotEqual(pageIndex, image, this.blank(image), image);
                continue;
            }
            ((CompareResult)this.compareResult).addPageThatsNotEqual(pageIndex, this.blank(image), image, image);
        }
    }

    private BufferedImage blank(BufferedImage image) {
        return new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
    }

    private BufferedImage renderPageAsImage(PDFRenderer expectedPdfRenderer, int pageIndex) throws IOException {
        return expectedPdfRenderer.renderImageWithDPI(pageIndex, 300.0f);
    }

    private void compare(BufferedImage expectedImage, BufferedImage actualImage, int pageIndex) {
        Optional<BufferedImage> diffImage = this.diffImages(pageIndex, expectedImage, actualImage);
        if (diffImage.isPresent()) {
            ((CompareResult)this.compareResult).addPageThatsNotEqual(pageIndex, expectedImage, actualImage, diffImage.get());
        } else {
            ((CompareResult)this.compareResult).addPageThatsEqual(pageIndex, expectedImage);
        }
    }

    private Optional<BufferedImage> diffImages(int page, BufferedImage expectedImage, BufferedImage actualImage) {
        DataBuffer expectedBuffer = expectedImage.getRaster().getDataBuffer();
        DataBuffer actualBuffer = actualImage.getRaster().getDataBuffer();
        int expectedImageWidth = expectedImage.getWidth();
        int expectedImageHeight = expectedImage.getHeight();
        int actualImageWidth = actualImage.getWidth();
        int actualImageHeight = actualImage.getHeight();
        int resultImageWidth = Math.max(expectedImageWidth, actualImageWidth);
        int resultImageHeight = Math.max(expectedImageHeight, actualImageHeight);
        BufferedImage resultImage = new BufferedImage(resultImageWidth, resultImageHeight, actualImage.getType());
        DataBuffer resultBuffer = resultImage.getRaster().getDataBuffer();
        int expectedElement = 0;
        int actualElement = 0;
        boolean diffFound = false;
        for (int y = 0; y < resultImageHeight; ++y) {
            int expectedLineOffset = y * expectedImageWidth;
            int actualLineOffset = y * actualImageWidth;
            int resultLineOffset = y * resultImageWidth;
            for (int x = 0; x < resultImageWidth; ++x) {
                if (this.exclusions.contains(page, x, y)) continue;
                if (x < expectedImageWidth && y < expectedImageHeight) {
                    expectedElement = expectedBuffer.getElem(x + expectedLineOffset);
                } else {
                    expectedElement = 0;
                    diffFound = true;
                }
                if (x < actualImageWidth && y < actualImageHeight) {
                    actualElement = actualBuffer.getElem(x + actualLineOffset);
                } else {
                    actualElement = 0;
                    diffFound = true;
                }
                if (expectedElement != actualElement) {
                    LOG.debug("Difference found at x: {}, y: {}", (Object)x, (Object)y);
                    diffFound = true;
                    int expectedDarkness = PdfComparator.calcDarkness(expectedElement);
                    int actualDarkness = PdfComparator.calcDarkness(actualElement);
                    int element = expectedDarkness > actualDarkness ? this.createElement(Math.max(50, Math.min(expectedDarkness / 3, 255)), 0, 0) : this.createElement(0, Math.max(50, Math.min(actualDarkness / 3, 255)), 0);
                    resultBuffer.setElem(x + resultLineOffset, element);
                    PdfComparator.mark(resultBuffer, x, y, resultImageWidth, MARKER_RGB);
                    continue;
                }
                resultBuffer.setElem(x + resultLineOffset, PdfComparator.fadeElement(expectedElement));
            }
        }
        if (diffFound) {
            return Optional.of(resultImage);
        }
        return Optional.empty();
    }

    private static int getRed(int element) {
        return element & 0xFF;
    }

    private static int getGreen(int element) {
        return element & 0xFF;
    }

    private static int getBlue(int element) {
        return element & 0xFF;
    }

    private int createElement(int red, int green, int blue) {
        return (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    private static void blankImage(BufferedImage resultImage) {
        Graphics2D graphics = resultImage.createGraphics();
        graphics.setPaint(Color.white);
        graphics.fillRect(0, 0, resultImage.getWidth(), resultImage.getHeight());
    }

    private static int fadeElement(int i) {
        return PdfComparator.fade(PdfComparator.getRed(i)) << 16 | PdfComparator.fade(PdfComparator.getGreen(i)) << 8 | PdfComparator.fade(PdfComparator.getBlue(i));
    }

    private static int fade(int i) {
        return i + (255 - i) * 4 / 5;
    }

    private static int calcDarkness(int element) {
        return PdfComparator.getRed(element) + PdfComparator.getGreen(element) + PdfComparator.getRed(element);
    }

    private static void mark(DataBuffer image, int x, int y, int imageWidth, int markerRGB) {
        int yOffset = y * imageWidth;
        for (int i = 0; i < 20; ++i) {
            image.setElem(x + i * imageWidth, markerRGB);
            image.setElem(i + yOffset, markerRGB);
        }
    }
}

