/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.CompareResult;
import de.redsix.pdfcompare.FileUtils;
import de.redsix.pdfcompare.ImageWithDimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;

public class CompareResultWithDiskStorage
extends CompareResult {
    private Path tempDir;
    private boolean hasImages = false;

    @Override
    protected void addImagesToDocument(PDDocument document) throws IOException {
        for (Path path : FileUtils.getPaths(this.getTempDir(), "image_*")) {
            BufferedImage bufferedImage = ImageIO.read(path.toFile());
            this.addPageToDocument(document, new ImageWithDimension(bufferedImage, bufferedImage.getWidth() / 300 * 72, bufferedImage.getHeight() / 300 * 72));
        }
        FileUtils.removeTempDir(this.getTempDir());
    }

    @Override
    public synchronized void addPage(boolean hasDifferences, boolean hasDifferenceInExclusion, int pageIndex, ImageWithDimension expectedImage, ImageWithDimension actualImage, ImageWithDimension diffImage) {
        Objects.requireNonNull(expectedImage, "expectedImage is null");
        Objects.requireNonNull(actualImage, "actualImage is null");
        Objects.requireNonNull(diffImage, "diffImage is null");
        this.hasImages = true;
        this.hasDifferenceInExclusion |= hasDifferenceInExclusion;
        if (hasDifferences) {
            this.isEqual = false;
        }
        this.storeImage(pageIndex, diffImage);
    }

    @Override
    protected boolean hasImages() {
        return this.hasImages;
    }

    private void storeImage(int pageIndex, ImageWithDimension diffImage) {
        try {
            Path tmpDir = this.getTempDir();
            ImageIO.write((RenderedImage)diffImage.bufferedImage, "PNG", tmpDir.resolve(String.format("image_%06d", pageIndex)).toFile());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write image to Temp Dir", e);
        }
    }

    private synchronized Path getTempDir() throws IOException {
        if (this.tempDir == null) {
            this.tempDir = FileUtils.createTempDir("PdfCompare");
        }
        return this.tempDir;
    }
}

