/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.ResultCollector;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class CompareResult
implements ResultCollector {
    protected final Map<Integer, BufferedImage> diffImages = new TreeMap<Integer, BufferedImage>();
    protected boolean isEqual = true;
    protected boolean hasDifferenceInExclusion = false;

    public boolean writeTo(String filename) {
        if (!this.hasImages()) {
            return this.isEqual;
        }
        try (PDDocument document = new PDDocument();){
            this.addImagesToDocument(document);
            document.save(filename + ".pdf");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.isEqual;
    }

    protected boolean hasImages() {
        return !this.diffImages.isEmpty();
    }

    protected void addImagesToDocument(PDDocument document) throws IOException {
        this.addImagesToDocument(document, this.diffImages);
    }

    protected void addImagesToDocument(PDDocument document, Map<Integer, BufferedImage> images) throws IOException {
        Iterator<Map.Entry<Integer, BufferedImage>> iterator = images.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, BufferedImage> entry = iterator.next();
            if (!this.keepImages()) {
                iterator.remove();
            }
            this.addPageToDocument(document, entry.getValue());
        }
    }

    protected void addPageToDocument(PDDocument document, BufferedImage image) throws IOException {
        PDPage page = new PDPage(new PDRectangle((float)image.getWidth(), (float)image.getHeight()));
        document.addPage(page);
        PDImageXObject imageXObject = LosslessFactory.createFromImage((PDDocument)document, (BufferedImage)image);
        try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
            contentStream.drawImage(imageXObject, 0.0f, 0.0f);
        }
    }

    protected boolean keepImages() {
        return false;
    }

    @Override
    public synchronized void addPage(boolean hasDifferences, boolean hasDifferenceInExclusion, int pageIndex, BufferedImage expectedImage, BufferedImage actualImage, BufferedImage diffImage) {
        Objects.requireNonNull(expectedImage, "expectedImage is null");
        Objects.requireNonNull(actualImage, "actualImage is null");
        Objects.requireNonNull(diffImage, "diffImage is null");
        this.hasDifferenceInExclusion |= hasDifferenceInExclusion;
        if (hasDifferences) {
            this.isEqual = false;
        }
        this.diffImages.put(pageIndex, diffImage);
    }

    @Override
    public void noPagesFound() {
        this.isEqual = false;
    }

    public boolean isEqual() {
        return this.isEqual;
    }

    public boolean isNotEqual() {
        return !this.isEqual;
    }

    public boolean hasDifferenceInExclusion() {
        return this.hasDifferenceInExclusion;
    }

    public synchronized int getNumberOfPages() {
        if (!this.hasImages()) {
            return 0;
        }
        return Collections.max(this.diffImages.keySet());
    }
}

