/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);
    private static Collection<Path> tempDirs = new ConcurrentLinkedQueue<Path>();
    private static volatile boolean shutdownRegistered;
    private static Path tempDirParent;

    public static void setTempDirParent(Path tempDirParentPath) {
        tempDirParent = tempDirParentPath;
    }

    private static synchronized void addShutdownHook() {
        if (!shutdownRegistered) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> FileUtils.removeTempDirs()));
            shutdownRegistered = true;
        }
    }

    private static void removeTempDirs() {
        tempDirs.forEach(FileUtils::removeTempDir);
    }

    public static Path createTempDir(String prefix) throws IOException {
        Path tempDir = tempDirParent != null ? Files.createTempDirectory(tempDirParent, prefix, new FileAttribute[0]) : Files.createTempDirectory(prefix, new FileAttribute[0]);
        tempDirs.add(tempDir);
        FileUtils.addShutdownHook();
        return tempDir;
    }

    public static void removeTempDir(Path tempDir) {
        tempDirs.remove(tempDir);
        if (Files.exists(tempDir, new LinkOption[0]) && Files.isDirectory(tempDir, new LinkOption[0])) {
            try {
                Files.walkFileTree(tempDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.deleteIfExists(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.deleteIfExists(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                LOG.warn("Error removing temporary directory: {}", (Object)tempDir, (Object)e);
            }
        }
    }

    public static List<Path> getPaths(Path dir, String glob) throws IOException {
        ArrayList<Path> paths = new ArrayList<Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dir, glob);){
            for (Path path : directoryStream) {
                paths.add(path);
            }
        }
        Collections.sort(paths);
        return paths;
    }
}

