/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.CompareResult;
import de.redsix.pdfcompare.DiffImage;
import de.redsix.pdfcompare.Exclusions;
import de.redsix.pdfcompare.ResultCollector;
import de.redsix.pdfcompare.Utilities;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfComparator<T extends CompareResult> {
    private static final Logger LOG = LoggerFactory.getLogger(PdfComparator.class);
    private static final int DPI = 300;
    private static final int EXTRA_RGB = new Color(0, 160, 0).getRGB();
    private static final int MISSING_RGB = new Color(220, 0, 0).getRGB();
    public static final int MARKER_WIDTH = 20;
    private final Exclusions exclusions = new Exclusions();
    private InputStreamSupplier expectedStreamSupplier;
    private InputStreamSupplier actualStreamSupplier;
    private ExecutorService drawExecutor = Executors.newSingleThreadExecutor();
    private ExecutorService parrallelDrawExecutor = Executors.newFixedThreadPool(2);
    private BlockingQueue<DiffImage> diffQueue = new LinkedBlockingQueue<DiffImage>(4);
    private ExecutorService diffExecutor = Executors.newSingleThreadExecutor();
    private final T compareResult;
    private boolean doneDrawing = false;

    private PdfComparator(T compareResult) {
        Objects.requireNonNull(compareResult, "compareResult is null");
        this.compareResult = compareResult;
    }

    public PdfComparator(String expectedPdfFilename, String actualPdfFilename) throws IOException {
        this(expectedPdfFilename, actualPdfFilename, new CompareResult());
    }

    public PdfComparator(String expectedPdfFilename, String actualPdfFilename, T compareResult) throws IOException {
        this(compareResult);
        Objects.requireNonNull(expectedPdfFilename, "expectedPdfFilename is null");
        Objects.requireNonNull(actualPdfFilename, "actualPdfFilename is null");
        if (!expectedPdfFilename.equals(actualPdfFilename)) {
            this.expectedStreamSupplier = () -> Files.newInputStream(Paths.get(expectedPdfFilename, new String[0]), new OpenOption[0]);
            this.actualStreamSupplier = () -> Files.newInputStream(Paths.get(actualPdfFilename, new String[0]), new OpenOption[0]);
        }
    }

    public PdfComparator(Path expectedPath, Path actualPath) throws IOException {
        this(expectedPath, actualPath, new CompareResult());
    }

    public PdfComparator(Path expectedPath, Path actualPath, T compareResult) throws IOException {
        this(compareResult);
        Objects.requireNonNull(expectedPath, "expectedPath is null");
        Objects.requireNonNull(actualPath, "actualPath is null");
        if (!expectedPath.equals(actualPath)) {
            this.expectedStreamSupplier = () -> Files.newInputStream(expectedPath, new OpenOption[0]);
            this.actualStreamSupplier = () -> Files.newInputStream(actualPath, new OpenOption[0]);
        }
    }

    public PdfComparator(File expectedFile, File actualFile) throws IOException {
        this(expectedFile, actualFile, new CompareResult());
    }

    public PdfComparator(File expectedFile, File actualFile, T compareResult) throws IOException {
        this(compareResult);
        Objects.requireNonNull(expectedFile, "expectedFile is null");
        Objects.requireNonNull(actualFile, "actualFile is null");
        if (!expectedFile.equals(actualFile)) {
            this.expectedStreamSupplier = () -> new FileInputStream(expectedFile);
            this.actualStreamSupplier = () -> new FileInputStream(actualFile);
        }
    }

    public PdfComparator(InputStream expectedPdfIS, InputStream actualPdfIS) {
        this(expectedPdfIS, actualPdfIS, new CompareResult());
    }

    public PdfComparator(InputStream expectedPdfIS, InputStream actualPdfIS, T compareResult) {
        this(compareResult);
        Objects.requireNonNull(expectedPdfIS, "expectedPdfIS is null");
        Objects.requireNonNull(actualPdfIS, "actualPdfIS is null");
        if (!expectedPdfIS.equals(actualPdfIS)) {
            this.expectedStreamSupplier = () -> expectedPdfIS;
            this.actualStreamSupplier = () -> actualPdfIS;
        }
    }

    public PdfComparator<T> withIgnore(String ignoreFilename) {
        Objects.requireNonNull(ignoreFilename, "ignoreFilename is null");
        this.exclusions.readExclusions(ignoreFilename);
        return this;
    }

    public PdfComparator<T> withIgnore(File ignoreFile) {
        Objects.requireNonNull(ignoreFile, "ignoreFile is null");
        this.exclusions.readExclusions(ignoreFile);
        return this;
    }

    public PdfComparator<T> withIgnore(Path ignorePath) {
        Objects.requireNonNull(ignorePath, "ignorePath is null");
        this.exclusions.readExclusions(ignorePath);
        return this;
    }

    public PdfComparator<T> withIgnore(InputStream ignoreIS) {
        Objects.requireNonNull(ignoreIS, "ignoreIS is null");
        this.exclusions.readExclusions(ignoreIS);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T compare() throws IOException {
        try {
            if (this.expectedStreamSupplier == null && this.actualStreamSupplier == null) {
                T t = this.compareResult;
                return t;
            }
            try (InputStream expectedStream = this.expectedStreamSupplier.get();){
                try (InputStream actualStream = this.actualStreamSupplier.get();
                     PDDocument expectedDocument = PDDocument.load((InputStream)expectedStream);){
                    PDFRenderer expectedPdfRenderer = new PDFRenderer(expectedDocument);
                    try (PDDocument actualDocument = PDDocument.load((InputStream)actualStream);){
                        PDFRenderer actualPdfRenderer = new PDFRenderer(actualDocument);
                        int minPageCount = Math.min(expectedDocument.getNumberOfPages(), actualDocument.getNumberOfPages());
                        this.startComparatorThread();
                        CountDownLatch latch = new CountDownLatch(minPageCount);
                        for (int pageIndex = 0; pageIndex < minPageCount; ++pageIndex) {
                            this.drawImage(latch, pageIndex, expectedPdfRenderer, actualPdfRenderer);
                        }
                        Utilities.await(latch, "FullCompare");
                        this.doneDrawing = true;
                        Utilities.shutdownAndAwaitTermination(this.drawExecutor, "Draw");
                        Utilities.shutdownAndAwaitTermination(this.parrallelDrawExecutor, "Parallel Draw");
                        Utilities.shutdownAndAwaitTermination(this.diffExecutor, "Diff");
                        if (expectedDocument.getNumberOfPages() > minPageCount) {
                            this.addExtraPages(expectedDocument, expectedPdfRenderer, minPageCount, MISSING_RGB, true);
                        } else if (actualDocument.getNumberOfPages() > minPageCount) {
                            this.addExtraPages(actualDocument, actualPdfRenderer, minPageCount, EXTRA_RGB, false);
                        }
                    }
                }
                catch (NoSuchFileException ex) {
                    this.addSingleDocumentToResult(expectedStream, MISSING_RGB);
                }
            }
            catch (NoSuchFileException ex) {
                try (InputStream actualStream = this.actualStreamSupplier.get();){
                    this.addSingleDocumentToResult(actualStream, EXTRA_RGB);
                }
                catch (NoSuchFileException innerEx) {
                    LOG.warn("No files found to compare. Tried Expected: '{}' and Actual: '{}'", (Object)ex.getFile(), (Object)innerEx.getFile());
                    ((CompareResult)this.compareResult).noPagesFound();
                }
            }
        }
        finally {
            this.compareResult.done();
        }
        return this.compareResult;
    }

    private void startComparatorThread() {
        this.diffExecutor.execute(() -> {
            boolean interrupted = false;
            while (!(interrupted || this.diffQueue.isEmpty() && this.doneDrawing)) {
                try {
                    DiffImage diffImage = this.diffQueue.poll(1L, TimeUnit.MINUTES);
                    LOG.trace("Diffing page {}", (Object)diffImage);
                    diffImage.diffImages();
                    LOG.trace("DONE Diffing page {}", (Object)diffImage);
                }
                catch (InterruptedException e) {
                    LOG.warn("Comparator queue was interrupted after one minute");
                    interrupted = true;
                }
                catch (Exception e) {
                    LOG.error("Exception while diffing Images", (Throwable)e);
                }
            }
        });
    }

    private void drawImage(CountDownLatch latch, int pageIndex, PDFRenderer expectedPdfRenderer, PDFRenderer actualPdfRenderer) {
        this.drawExecutor.execute(() -> {
            try {
                LOG.trace("Drawing page {}", (Object)pageIndex);
                Future<BufferedImage> expectedImageFuture = this.parrallelDrawExecutor.submit(() -> this.renderPageAsImage(expectedPdfRenderer, pageIndex));
                Future<BufferedImage> actualImageFuture = this.parrallelDrawExecutor.submit(() -> this.renderPageAsImage(actualPdfRenderer, pageIndex));
                BufferedImage expectedImage = expectedImageFuture.get(1L, TimeUnit.MINUTES);
                BufferedImage actualImage = actualImageFuture.get(1L, TimeUnit.MINUTES);
                DiffImage diffImage = new DiffImage(expectedImage, actualImage, pageIndex, this.exclusions, (ResultCollector)this.compareResult);
                boolean successful = false;
                do {
                    try {
                        LOG.trace("Enqueueing page {}.", (Object)pageIndex, (Object)this.diffQueue.size());
                        this.diffQueue.put(diffImage);
                        successful = true;
                    }
                    catch (InterruptedException e) {
                        LOG.warn("DiffQueue.put({}) was interrupted", (Object)diffImage);
                    }
                } while (!successful);
                LOG.trace("DONE drawing page {}", (Object)pageIndex);
            }
            catch (InterruptedException | TimeoutException e) {
                LOG.error("Waiting for Future was interrupted after one minute", (Throwable)e);
            }
            catch (ExecutionException e) {
                LOG.error("Error while rendering page {}", (Object)pageIndex, (Object)e);
            }
            finally {
                latch.countDown();
            }
        });
    }

    private void addSingleDocumentToResult(InputStream expectedPdfIS, int markerColor) throws IOException {
        try (PDDocument expectedDocument = PDDocument.load((InputStream)expectedPdfIS);){
            PDFRenderer expectedPdfRenderer = new PDFRenderer(expectedDocument);
            this.addExtraPages(expectedDocument, expectedPdfRenderer, 0, markerColor, true);
        }
    }

    private void addExtraPages(PDDocument document, PDFRenderer pdfRenderer, int minPageCount, int color, boolean expected) throws IOException {
        for (int pageIndex = minPageCount; pageIndex < document.getNumberOfPages(); ++pageIndex) {
            int i;
            BufferedImage image = this.renderPageAsImage(pdfRenderer, pageIndex);
            DataBuffer dataBuffer = image.getRaster().getDataBuffer();
            for (i = 0; i < image.getWidth() * 20; ++i) {
                dataBuffer.setElem(i, color);
            }
            for (i = 0; i < image.getHeight(); ++i) {
                for (int j = 0; j < 20; ++j) {
                    dataBuffer.setElem(i * image.getWidth() + j, color);
                }
            }
            if (expected) {
                ((CompareResult)this.compareResult).addPage(true, false, pageIndex, image, PdfComparator.blank(image), image);
                continue;
            }
            ((CompareResult)this.compareResult).addPage(true, false, pageIndex, PdfComparator.blank(image), image, image);
        }
    }

    private static BufferedImage blank(BufferedImage image) {
        return new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
    }

    private BufferedImage renderPageAsImage(PDFRenderer expectedPdfRenderer, int pageIndex) throws IOException {
        return expectedPdfRenderer.renderImageWithDPI(pageIndex, 300.0f);
    }

    public T getResult() {
        return this.compareResult;
    }

    @FunctionalInterface
    private static interface InputStreamSupplier {
        public InputStream get() throws IOException;
    }
}

