/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.CompareResult;
import de.redsix.pdfcompare.Exclusions;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PdfComparator {
    private static final int DPI = 300;
    private static final int MARKER_RGB = Color.MAGENTA.getRGB();
    private static final int EXTRA_RGB = Color.GREEN.getRGB();
    private static final int MISSING_RGB = Color.RED.getRGB();
    private static final int MARKER_WIDTH = 20;
    private Exclusions exclusions = new Exclusions();

    /*
     * Exception decompiling
     */
    public CompareResult compare(String expectedPdfFilename, String actualPdfFilename) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public CompareResult compare(Path expectedPath, Path actualPath) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public CompareResult compare(File expectedFile, File actualFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CompareResult compare(InputStream expectedPdfIS, InputStream actualPdfIS) throws IOException {
        this.exclusions.readExclusions();
        CompareResult result = new CompareResult();
        if (expectedPdfIS.equals(actualPdfIS)) {
            return result;
        }
        try (PDDocument expectedDocument = PDDocument.load((InputStream)expectedPdfIS);){
            PDFRenderer expectedPdfRenderer = new PDFRenderer(expectedDocument);
            try (PDDocument actualDocument = PDDocument.load((InputStream)actualPdfIS);){
                PDFRenderer actualPdfRenderer = new PDFRenderer(actualDocument);
                int minPageCount = Math.min(expectedDocument.getNumberOfPages(), actualDocument.getNumberOfPages());
                for (int pageIndex = 0; pageIndex < minPageCount; ++pageIndex) {
                    BufferedImage expectedImage = this.renderPageAsImage(expectedPdfRenderer, pageIndex);
                    BufferedImage actualImage = this.renderPageAsImage(actualPdfRenderer, pageIndex);
                    this.compare(expectedImage, actualImage, pageIndex, result);
                }
                if (expectedDocument.getNumberOfPages() > minPageCount) {
                    this.addExtraPages(expectedDocument, expectedPdfRenderer, minPageCount, result, MISSING_RGB, true);
                } else if (actualDocument.getNumberOfPages() > minPageCount) {
                    this.addExtraPages(actualDocument, actualPdfRenderer, minPageCount, result, EXTRA_RGB, false);
                }
            }
        }
        return result;
    }

    public static BufferedImage deepCopy(BufferedImage image) {
        return new BufferedImage(image.getColorModel(), image.copyData(null), image.getColorModel().isAlphaPremultiplied(), null);
    }

    private void addExtraPages(PDDocument document, PDFRenderer pdfRenderer, int minPageCount, CompareResult result, int color, boolean expected) throws IOException {
        for (int pageIndex = minPageCount; pageIndex < document.getNumberOfPages(); ++pageIndex) {
            int i;
            BufferedImage image = this.renderPageAsImage(pdfRenderer, pageIndex);
            DataBuffer dataBuffer = image.getRaster().getDataBuffer();
            for (i = 0; i < image.getWidth() * 20; ++i) {
                dataBuffer.setElem(i, color);
            }
            for (i = 0; i < image.getHeight(); ++i) {
                for (int j = 0; j < 20; ++j) {
                    dataBuffer.setElem(i * image.getWidth() + j, color);
                }
            }
            if (expected) {
                result.addPageThatsNotEqual(pageIndex, image, this.blank(image), image);
                continue;
            }
            result.addPageThatsNotEqual(pageIndex, this.blank(image), image, image);
        }
    }

    private BufferedImage blank(BufferedImage image) {
        return new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
    }

    private BufferedImage renderPageAsImage(PDFRenderer expectedPdfRenderer, int pageIndex) throws IOException {
        return expectedPdfRenderer.renderImageWithDPI(pageIndex, 300.0f);
    }

    private void compare(BufferedImage expectedImage, BufferedImage actualImage, int pageIndex, CompareResult result) {
        Optional<BufferedImage> diffImage = this.diffImages(pageIndex, expectedImage, actualImage);
        if (diffImage.isPresent()) {
            result.addPageThatsNotEqual(pageIndex, expectedImage, actualImage, diffImage.get());
        } else {
            result.addPageThatsEqual(pageIndex, expectedImage);
        }
    }

    private Optional<BufferedImage> diffImages(int page, BufferedImage expectedImage, BufferedImage actualImage) {
        DataBuffer expectedBuffer = expectedImage.getRaster().getDataBuffer();
        DataBuffer actualBuffer = actualImage.getRaster().getDataBuffer();
        int expectedImageWidth = expectedImage.getWidth();
        int expectedImageHeight = expectedImage.getHeight();
        int actualImageWidth = actualImage.getWidth();
        int actualImageHeight = actualImage.getHeight();
        int resultImageWidth = Math.max(expectedImageWidth, actualImageWidth);
        int resultImageHeight = Math.max(expectedImageHeight, actualImageHeight);
        BufferedImage resultImage = new BufferedImage(resultImageWidth, resultImageHeight, actualImage.getType());
        DataBuffer resultBuffer = resultImage.getRaster().getDataBuffer();
        int expectedElement = 0;
        int actualElement = 0;
        boolean diffFound = false;
        for (int y = 0; y < resultImageHeight; ++y) {
            int expectedLineOffset = y * expectedImageWidth;
            int actualLineOffset = y * actualImageWidth;
            int resultLineOffset = y * resultImageWidth;
            for (int x = 0; x < resultImageWidth; ++x) {
                if (this.exclusions.contains(page, x, y)) continue;
                if (x < expectedImageWidth && y < expectedImageHeight) {
                    expectedElement = expectedBuffer.getElem(x + expectedLineOffset);
                } else {
                    expectedElement = 0;
                    diffFound = true;
                }
                if (x < actualImageWidth && y < actualImageHeight) {
                    actualElement = actualBuffer.getElem(x + actualLineOffset);
                } else {
                    actualElement = 0;
                    diffFound = true;
                }
                if (expectedElement != actualElement) {
                    int actualDarkness;
                    diffFound = true;
                    int expectedDarkness = PdfComparator.calcDarkness(expectedElement);
                    int element = expectedDarkness > (actualDarkness = PdfComparator.calcDarkness(actualElement)) ? this.createElement(Math.max(50, Math.min(expectedDarkness / 3, 255)), 0, 0) : this.createElement(0, Math.max(50, Math.min(actualDarkness / 3, 255)), 0);
                    resultBuffer.setElem(x + resultLineOffset, element);
                    PdfComparator.mark(resultBuffer, x, y, resultImageWidth, MARKER_RGB);
                    continue;
                }
                resultBuffer.setElem(x + resultLineOffset, PdfComparator.fadeElement(expectedElement));
            }
        }
        if (diffFound) {
            return Optional.of(resultImage);
        }
        return Optional.empty();
    }

    private static int getRed(int element) {
        return element & 0xFF;
    }

    private static int getGreen(int element) {
        return element & 0xFF;
    }

    private static int getBlue(int element) {
        return element & 0xFF;
    }

    private int createElement(int red, int green, int blue) {
        return (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    private static void blankImage(BufferedImage resultImage) {
        Graphics2D graphics = resultImage.createGraphics();
        graphics.setPaint(Color.white);
        graphics.fillRect(0, 0, resultImage.getWidth(), resultImage.getHeight());
    }

    private static int fadeElement(int i) {
        return PdfComparator.fade(PdfComparator.getRed(i)) << 16 | PdfComparator.fade(PdfComparator.getGreen(i)) << 8 | PdfComparator.fade(PdfComparator.getBlue(i));
    }

    private static int fade(int i) {
        return i + (255 - i) * 4 / 5;
    }

    private static int calcDarkness(int element) {
        return PdfComparator.getRed(element) + PdfComparator.getGreen(element) + PdfComparator.getRed(element);
    }

    private static void mark(DataBuffer image, int x, int y, int imageWidth, int markerRGB) {
        int yOffset = y * imageWidth;
        for (int i = 0; i < 20; ++i) {
            image.setElem(x + i * imageWidth, markerRGB);
            image.setElem(i + yOffset, markerRGB);
        }
    }
}

